/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Stopwatch;
import com.google.common.base.Strings;
import com.google.common.collect.Multimap;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import com.hubspot.algebra.Result;
import com.hubspot.horizon.AsyncHttpClient;
import com.hubspot.horizon.HttpConfig;
import com.hubspot.horizon.HttpRequest;
import com.hubspot.horizon.HttpResponse;
import com.hubspot.horizon.ning.NingAsyncHttpClient;
import com.hubspot.slack.client.SlackClient;
import com.hubspot.slack.client.SlackClientRuntimeConfig;
import com.hubspot.slack.client.concurrency.CloseableExecutorService;
import com.hubspot.slack.client.concurrency.MoreExecutors;
import com.hubspot.slack.client.http.NioHttpClient;
import com.hubspot.slack.client.http.NioHttpClientFactory;
import com.hubspot.slack.client.interceptors.calls.SlackMethodAcceptor;
import com.hubspot.slack.client.interceptors.http.DefaultHttpRequestDebugger;
import com.hubspot.slack.client.interceptors.http.DefaultHttpResponseDebugger;
import com.hubspot.slack.client.interceptors.http.HttpRequestHelper;
import com.hubspot.slack.client.interceptors.http.RequestDebugger;
import com.hubspot.slack.client.interceptors.http.ResponseDebugger;
import com.hubspot.slack.client.jackson.ObjectMapperUtils;
import com.hubspot.slack.client.methods.JsonStatus;
import com.hubspot.slack.client.methods.SlackMethod;
import com.hubspot.slack.client.methods.SlackMethods;
import com.hubspot.slack.client.methods.params.auth.AuthRevokeParams;
import com.hubspot.slack.client.methods.params.channels.AbstractChannelsHistoryParams;
import com.hubspot.slack.client.methods.params.channels.BaseChannelsFilter;
import com.hubspot.slack.client.methods.params.channels.ChannelsFilter;
import com.hubspot.slack.client.methods.params.channels.ChannelsHistoryParams;
import com.hubspot.slack.client.methods.params.channels.ChannelsInfoParams;
import com.hubspot.slack.client.methods.params.channels.ChannelsKickParams;
import com.hubspot.slack.client.methods.params.channels.ChannelsListParams;
import com.hubspot.slack.client.methods.params.channels.ChannelsListParamsIF;
import com.hubspot.slack.client.methods.params.channels.FindRepliesParams;
import com.hubspot.slack.client.methods.params.channels.PagingDirection;
import com.hubspot.slack.client.methods.params.chat.ChatDeleteParams;
import com.hubspot.slack.client.methods.params.chat.ChatGetPermalinkParams;
import com.hubspot.slack.client.methods.params.chat.ChatPostEphemeralMessageParams;
import com.hubspot.slack.client.methods.params.chat.ChatPostMessageParams;
import com.hubspot.slack.client.methods.params.chat.ChatUpdateMessageParams;
import com.hubspot.slack.client.methods.params.conversations.AbstractConversationsHistoryParams;
import com.hubspot.slack.client.methods.params.conversations.BaseConversationsFilter;
import com.hubspot.slack.client.methods.params.conversations.ConversationArchiveParams;
import com.hubspot.slack.client.methods.params.conversations.ConversationCreateParams;
import com.hubspot.slack.client.methods.params.conversations.ConversationInviteParams;
import com.hubspot.slack.client.methods.params.conversations.ConversationMemberParams;
import com.hubspot.slack.client.methods.params.conversations.ConversationMemberParamsIF;
import com.hubspot.slack.client.methods.params.conversations.ConversationOpenParams;
import com.hubspot.slack.client.methods.params.conversations.ConversationUnarchiveParams;
import com.hubspot.slack.client.methods.params.conversations.ConversationsFilter;
import com.hubspot.slack.client.methods.params.conversations.ConversationsHistoryParams;
import com.hubspot.slack.client.methods.params.conversations.ConversationsInfoParams;
import com.hubspot.slack.client.methods.params.conversations.ConversationsListParams;
import com.hubspot.slack.client.methods.params.conversations.ConversationsListParamsIF;
import com.hubspot.slack.client.methods.params.conversations.ConversationsRepliesParams;
import com.hubspot.slack.client.methods.params.conversations.ConversationsUserParams;
import com.hubspot.slack.client.methods.params.conversations.ConversationsUserParamsIF;
import com.hubspot.slack.client.methods.params.dialog.DialogOpenParams;
import com.hubspot.slack.client.methods.params.files.FilesSharedPublicUrlParams;
import com.hubspot.slack.client.methods.params.files.FilesUploadParams;
import com.hubspot.slack.client.methods.params.group.GroupsKickParams;
import com.hubspot.slack.client.methods.params.group.GroupsListParams;
import com.hubspot.slack.client.methods.params.group.GroupsListParamsIF;
import com.hubspot.slack.client.methods.params.im.ImOpenParams;
import com.hubspot.slack.client.methods.params.reactions.ReactionsAddParams;
import com.hubspot.slack.client.methods.params.search.SearchMessagesParams;
import com.hubspot.slack.client.methods.params.usergroups.UsergroupCreateParams;
import com.hubspot.slack.client.methods.params.usergroups.UsergroupDisableParams;
import com.hubspot.slack.client.methods.params.usergroups.UsergroupEnableParams;
import com.hubspot.slack.client.methods.params.usergroups.UsergroupListParams;
import com.hubspot.slack.client.methods.params.usergroups.UsergroupListParamsIF;
import com.hubspot.slack.client.methods.params.usergroups.UsergroupUpdateParams;
import com.hubspot.slack.client.methods.params.usergroups.users.UsergroupUsersUpdateParams;
import com.hubspot.slack.client.methods.params.users.UserEmailParams;
import com.hubspot.slack.client.methods.params.users.UsersInfoParams;
import com.hubspot.slack.client.methods.params.users.UsersListParams;
import com.hubspot.slack.client.models.LiteMessage;
import com.hubspot.slack.client.models.SlackChannel;
import com.hubspot.slack.client.models.conversations.Conversation;
import com.hubspot.slack.client.models.group.SlackGroup;
import com.hubspot.slack.client.models.response.FindRepliesResponse;
import com.hubspot.slack.client.models.response.ResponseMetadata;
import com.hubspot.slack.client.models.response.SlackError;
import com.hubspot.slack.client.models.response.SlackErrorResponse;
import com.hubspot.slack.client.models.response.SlackErrorType;
import com.hubspot.slack.client.models.response.SlackResponse;
import com.hubspot.slack.client.models.response.auth.AuthRevokeResponse;
import com.hubspot.slack.client.models.response.auth.AuthTestResponse;
import com.hubspot.slack.client.models.response.channels.ChannelsHistoryResponse;
import com.hubspot.slack.client.models.response.channels.ChannelsInfoResponse;
import com.hubspot.slack.client.models.response.channels.ChannelsKickResponse;
import com.hubspot.slack.client.models.response.channels.ChannelsListResponse;
import com.hubspot.slack.client.models.response.chat.ChatDeleteResponse;
import com.hubspot.slack.client.models.response.chat.ChatGetPermalinkResponse;
import com.hubspot.slack.client.models.response.chat.ChatPostEphemeralMessageResponse;
import com.hubspot.slack.client.models.response.chat.ChatPostMessageResponse;
import com.hubspot.slack.client.models.response.chat.ChatUpdateMessageResponse;
import com.hubspot.slack.client.models.response.conversations.ConversationListResponse;
import com.hubspot.slack.client.models.response.conversations.ConversationMemberResponse;
import com.hubspot.slack.client.models.response.conversations.ConversationsArchiveResponse;
import com.hubspot.slack.client.models.response.conversations.ConversationsCreateResponse;
import com.hubspot.slack.client.models.response.conversations.ConversationsHistoryResponse;
import com.hubspot.slack.client.models.response.conversations.ConversationsInfoResponse;
import com.hubspot.slack.client.models.response.conversations.ConversationsInviteResponse;
import com.hubspot.slack.client.models.response.conversations.ConversationsOpenResponse;
import com.hubspot.slack.client.models.response.conversations.ConversationsRepliesResponse;
import com.hubspot.slack.client.models.response.conversations.ConversationsUnarchiveResponse;
import com.hubspot.slack.client.models.response.dialog.DialogOpenResponse;
import com.hubspot.slack.client.models.response.emoji.EmojiListResponse;
import com.hubspot.slack.client.models.response.files.FilesSharedPublicUrlResponse;
import com.hubspot.slack.client.models.response.files.FilesUploadResponse;
import com.hubspot.slack.client.models.response.group.GroupsKickResponse;
import com.hubspot.slack.client.models.response.group.GroupsListResponse;
import com.hubspot.slack.client.models.response.im.ImOpenResponse;
import com.hubspot.slack.client.models.response.reactions.AddReactionResponse;
import com.hubspot.slack.client.models.response.search.SearchMessageResponse;
import com.hubspot.slack.client.models.response.team.TeamInfoResponse;
import com.hubspot.slack.client.models.response.usergroups.UsergroupCreateResponse;
import com.hubspot.slack.client.models.response.usergroups.UsergroupDisableResponse;
import com.hubspot.slack.client.models.response.usergroups.UsergroupEnableResponse;
import com.hubspot.slack.client.models.response.usergroups.UsergroupListResponse;
import com.hubspot.slack.client.models.response.usergroups.UsergroupUpdateResponse;
import com.hubspot.slack.client.models.response.usergroups.users.UsergroupUsersUpdateResponse;
import com.hubspot.slack.client.models.response.users.UsersInfoResponse;
import com.hubspot.slack.client.models.response.users.UsersListResponse;
import com.hubspot.slack.client.models.usergroups.SlackUsergroup;
import com.hubspot.slack.client.models.users.SlackUser;
import com.hubspot.slack.client.paging.AbstractPagedIterable;
import com.hubspot.slack.client.paging.LazyLoadingPage;
import com.hubspot.slack.client.ratelimiting.ByMethodRateLimiter;
import com.hubspot.slack.client.ratelimiting.SlackRateLimiter;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlackWebClient
implements SlackClient {
    public static final int RATE_LIMIT_SENTINEL_VALUE = -1;
    public static final int RATE_LIMIT_LOG_WARNING_THRESHOLD_SECONDS = 5;
    private static final Logger LOG = LoggerFactory.getLogger(SlackWebClient.class);
    private static final HttpConfig DEFAULT_CONFIG = HttpConfig.newBuilder().setObjectMapper(ObjectMapperUtils.mapper()).build();
    private static final AtomicLong REQUEST_COUNTER = new AtomicLong(0L);
    private final NioHttpClient nioHttpClient;
    private final CloseableExecutorService recursingExecutor;
    private final ByMethodRateLimiter defaultRateLimiter;
    private final SlackClientRuntimeConfig config;
    private final SlackMethodAcceptor methodAcceptor;
    private final RequestDebugger requestDebugger;
    private final ResponseDebugger responseDebugger;

    @AssistedInject
    public SlackWebClient(DefaultHttpRequestDebugger defaultHttpRequestDebugger, DefaultHttpResponseDebugger defaultHttpResponseDebugger, NioHttpClient.Factory nioHttpClientFactory, ByMethodRateLimiter defaultRateLimiter, @Assisted SlackClientRuntimeConfig config) {
        this.nioHttpClient = nioHttpClientFactory.wrap((AsyncHttpClient)new NingAsyncHttpClient(config.getHttpConfig().orElse(DEFAULT_CONFIG)));
        this.defaultRateLimiter = defaultRateLimiter;
        this.config = config;
        this.methodAcceptor = config.getMethodFilter().orElse(new SlackMethodAcceptor(){

            @Override
            public String getFailureExplanation(SlackMethod method, Object params) {
                throw new IllegalStateException("We can't fail with the pasthrough acceptor");
            }

            @Override
            public boolean test(SlackMethod slackMethod, Object o) {
                return true;
            }
        });
        this.requestDebugger = config.getRequestDebugger().orElse(defaultHttpRequestDebugger);
        this.responseDebugger = config.getResponseDebugger().orElse(defaultHttpResponseDebugger);
        this.recursingExecutor = MoreExecutors.threadPoolDaemonExecutorBuilder("Slack-recursive-callbacks").setFollowThreadLocals(true).setUnbounded(true).build();
    }

    SlackWebClient(NioHttpClientFactory nioHttpClientFactory, SlackClientRuntimeConfig config) {
        this(new DefaultHttpRequestDebugger(), new DefaultHttpResponseDebugger(), nioHttpClientFactory, new ByMethodRateLimiter(), config);
    }

    @Override
    public CompletableFuture<Result<AuthTestResponse, SlackError>> testAuth() {
        return this.postSlackCommand((SlackMethod)SlackMethods.auth_test, Collections.emptyMap(), AuthTestResponse.class);
    }

    @Override
    public CompletableFuture<Result<AuthRevokeResponse, SlackError>> revokeAuth(AuthRevokeParams params) {
        return this.postSlackCommand((SlackMethod)SlackMethods.auth_revoke, params, AuthRevokeResponse.class);
    }

    @Override
    public CompletableFuture<Result<SearchMessageResponse, SlackError>> searchMessages(SearchMessagesParams params) {
        return this.postSlackCommand((SlackMethod)SlackMethods.search_messages, params, SearchMessageResponse.class);
    }

    @Override
    public CompletableFuture<Result<FindRepliesResponse, SlackError>> findReplies(FindRepliesParams params) {
        switch (params.getChannelType()) {
            case GROUP: {
                return this.postSlackCommand((SlackMethod)SlackMethods.groups_replies, params, FindRepliesResponse.class);
            }
            case CHANNEL: {
                return this.postSlackCommand((SlackMethod)SlackMethods.channels_replies, params, FindRepliesResponse.class);
            }
        }
        throw new IllegalArgumentException(params.getChannelType() + " is not a supported channel type for reply fetching");
    }

    @Override
    public CompletableFuture<Result<ConversationsRepliesResponse, SlackError>> getConversationReplies(ConversationsRepliesParams params) {
        return this.postSlackCommand((SlackMethod)SlackMethods.conversations_replies, params, ConversationsRepliesResponse.class);
    }

    @Override
    public Iterable<CompletableFuture<Result<List<SlackUser>, SlackError>>> listUsers() {
        return new AbstractPagedIterable<Result<List<SlackUser>, SlackError>, String>(){

            @Override
            protected String getInitialOffset() {
                return null;
            }

            @Override
            protected LazyLoadingPage<Result<List<SlackUser>, SlackError>, String> getPage(String offset) throws Exception {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Fetching user page from {}", (Object)offset);
                }
                UsersListParams.Builder requestBuilder = UsersListParams.builder().setLimit(SlackWebClient.this.config.getUsersListBatchSize().get());
                Optional.ofNullable(offset).ifPresent(arg_0 -> ((UsersListParams.Builder)requestBuilder).setCursor(arg_0));
                CompletableFuture<Result<UsersListResponse, SlackError>> resultFuture = SlackWebClient.this.postSlackCommand((SlackMethod)SlackMethods.users_list, requestBuilder.build(), UsersListResponse.class);
                CompletionStage pageFuture = resultFuture.thenApply(result -> result.mapOk(UsersListResponse::getMembers));
                CompletableFuture nextCursorMaybeFuture = SlackWebClient.this.extractNextCursor(resultFuture);
                CompletionStage hasMoreFuture = nextCursorMaybeFuture.thenApply(Optional::isPresent);
                CompletionStage nextCursorFuture = nextCursorMaybeFuture.thenApply(cursorMaybe -> cursorMaybe.orElse(null));
                return new LazyLoadingPage<Result<List<SlackUser>, SlackError>, String>((CompletableFuture<Result<List<SlackUser>, SlackError>>)pageFuture, (CompletableFuture<Boolean>)hasMoreFuture, (CompletableFuture<String>)nextCursorFuture);
            }
        };
    }

    @Override
    public CompletableFuture<Result<UsersListResponse, SlackError>> listUsersPaginated(UsersListParams params) {
        return this.postSlackCommand((SlackMethod)SlackMethods.users_list, params, UsersListResponse.class);
    }

    private <T extends SlackResponse> CompletableFuture<Optional<String>> extractNextCursor(CompletableFuture<Result<T, SlackError>> responseFuture) {
        return ((CompletableFuture)responseFuture.thenApply(result -> result.mapOk(response -> response.getResponseMetadata().flatMap(ResponseMetadata::getNextCursor).map(Strings::emptyToNull)))).thenApply(result -> (Optional)result.match(err -> Optional.empty(), ok -> ok));
    }

    @Override
    public CompletableFuture<Result<UsersInfoResponse, SlackError>> lookupUserByEmail(UserEmailParams params) {
        return this.postSlackCommand((SlackMethod)SlackMethods.users_lookupByEmail, params, UsersInfoResponse.class);
    }

    @Override
    public CompletableFuture<Result<UsersInfoResponse, SlackError>> findUser(UsersInfoParams params) {
        return this.postSlackCommand((SlackMethod)SlackMethods.users_info, params, UsersInfoResponse.class);
    }

    @Override
    public Iterable<CompletableFuture<Result<List<SlackChannel>, SlackError>>> listChannels(final ChannelsListParams filter) {
        return new AbstractPagedIterable<Result<List<SlackChannel>, SlackError>, String>(){

            @Override
            protected String getInitialOffset() {
                return null;
            }

            @Override
            protected LazyLoadingPage<Result<List<SlackChannel>, SlackError>, String> getPage(String offset) throws Exception {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Fetching channel page from {}", (Object)offset);
                }
                ChannelsListParams.Builder requestBuilder = ChannelsListParams.builder().from((ChannelsListParamsIF)filter).setLimit(SlackWebClient.this.config.getChannelsListBatchSize().get());
                Optional.ofNullable(offset).ifPresent(arg_0 -> ((ChannelsListParams.Builder)requestBuilder).setCursor(arg_0));
                CompletableFuture<Result<ChannelsListResponse, SlackError>> resultFuture = SlackWebClient.this.postSlackCommand((SlackMethod)SlackMethods.channels_list, requestBuilder.build(), ChannelsListResponse.class);
                CompletionStage pageFuture = resultFuture.thenApply(result -> result.mapOk(ChannelsListResponse::getChannels));
                CompletableFuture nextCursorMaybeFuture = SlackWebClient.this.extractNextCursor(resultFuture);
                CompletionStage hasMoreFuture = nextCursorMaybeFuture.thenApply(Optional::isPresent);
                CompletionStage nextCursorFuture = nextCursorMaybeFuture.thenApply(cursorMaybe -> cursorMaybe.orElse(null));
                return new LazyLoadingPage<Result<List<SlackChannel>, SlackError>, String>((CompletableFuture<Result<List<SlackChannel>, SlackError>>)pageFuture, (CompletableFuture<Boolean>)hasMoreFuture, (CompletableFuture<String>)nextCursorFuture);
            }
        };
    }

    @Override
    public Iterable<CompletableFuture<Result<List<LiteMessage>, SlackError>>> channelHistory(final ChannelsHistoryParams params) {
        final PagingDirection pagingDirection = params.getPagingDirection();
        return new AbstractPagedIterable<Result<List<LiteMessage>, SlackError>, Long>(){

            @Override
            protected Long getInitialOffset() {
                return null;
            }

            @Override
            protected LazyLoadingPage<Result<List<LiteMessage>, SlackError>, Long> getPage(Long offset) throws Exception {
                ChannelsHistoryParams.Builder requestBuilder = ChannelsHistoryParams.builder().from((AbstractChannelsHistoryParams)params);
                if (!params.getCount().isPresent()) {
                    requestBuilder.setCount(SlackWebClient.this.config.getChannelsHistoryMessageBatchSize().get());
                }
                Optional.ofNullable(offset).ifPresent(presentOffset -> {
                    if (pagingDirection == PagingDirection.FORWARD_IN_TIME) {
                        requestBuilder.setOldestTimestamp(presentOffset.toString());
                    } else {
                        requestBuilder.setNewestTimestamp(presentOffset.toString());
                    }
                });
                ChannelsHistoryParams currentRequest = requestBuilder.build();
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Fetching channel history page for {} from [{}, {}]", new Object[]{currentRequest.getChannelId(), currentRequest.getOldestTimestamp(), currentRequest.getNewestTimestamp()});
                }
                CompletableFuture<Result<ChannelsHistoryResponse, SlackError>> resultFuture = SlackWebClient.this.postSlackCommand((SlackMethod)SlackMethods.channels_history, currentRequest, ChannelsHistoryResponse.class);
                CompletionStage pageFuture = resultFuture.thenApply(result -> result.mapOk(ChannelsHistoryResponse::getMessages));
                CompletionStage hasMoreFuture = resultFuture.thenApply(result -> (Boolean)result.match(err -> false, ok -> ok.hasMore()));
                CompletableFuture nextOffset = SlackWebClient.this.nextOffset(pagingDirection, (CompletableFuture)pageFuture);
                return new LazyLoadingPage<Result<List<LiteMessage>, SlackError>, Long>((CompletableFuture<Result<List<LiteMessage>, SlackError>>)pageFuture, (CompletableFuture<Boolean>)hasMoreFuture, nextOffset);
            }
        };
    }

    private CompletableFuture<Long> nextOffset(PagingDirection pagingDirection, CompletableFuture<Result<List<LiteMessage>, SlackError>> pageFuture) {
        return pageFuture.thenApply(page -> (Long)page.match(err -> null, messages -> {
            Set timestamps = messages.stream().map(LiteMessage::getTimestamp).collect(Collectors.toSet());
            if (pagingDirection == PagingDirection.FORWARD_IN_TIME && !messages.isEmpty()) {
                return timestamps.stream().max(Comparator.comparing(Function.identity())).map(largestTs -> (long)Double.parseDouble(largestTs)).get();
            }
            if (!messages.isEmpty()) {
                return timestamps.stream().min(Comparator.comparing(Function.identity())).map(smallestTs -> (long)Double.parseDouble(smallestTs)).get();
            }
            return null;
        }));
    }

    @Override
    public CompletableFuture<Result<SlackChannel, SlackError>> getChannelByName(String channelName, ChannelsFilter channelsFilter) {
        return this.findChannelByName(channelName, channelsFilter).thenApply(channelMaybe -> {
            if (channelMaybe.isPresent()) {
                return Result.ok(channelMaybe.get());
            }
            return Result.err((Object)SlackError.builder().setError("No channel found with name: " + channelName).setType(SlackErrorType.CHANNEL_NOT_FOUND).build());
        });
    }

    private CompletableFuture<Optional<SlackChannel>> findChannelByName(String name, ChannelsFilter channelsFilter) {
        return this.searchNextPage(name, this.listChannels(ChannelsListParams.builder().from((BaseChannelsFilter)channelsFilter).build()).iterator());
    }

    private CompletableFuture<Optional<SlackChannel>> searchNextPage(String channelName, Iterator<CompletableFuture<Result<List<SlackChannel>, SlackError>>> pageIterator) {
        if (!pageIterator.hasNext()) {
            return CompletableFuture.completedFuture(Optional.empty());
        }
        CompletableFuture<Result<List<SlackChannel>, SlackError>> nextPage = pageIterator.next();
        return ((CompletableFuture)nextPage.thenApply(Result::unwrapOrElseThrow)).thenComposeAsync(channels -> {
            Optional<SlackChannel> matchInPage = channels.stream().filter(channel -> channel.getName().equals(channelName)).findFirst();
            if (matchInPage.isPresent()) {
                return CompletableFuture.completedFuture(matchInPage);
            }
            return this.searchNextPage(channelName, pageIterator);
        }, (Executor)this.recursingExecutor);
    }

    @Override
    public CompletableFuture<Result<ChannelsInfoResponse, SlackError>> getChannelInfo(ChannelsInfoParams params) {
        return this.postSlackCommand((SlackMethod)SlackMethods.channels_info, params, ChannelsInfoResponse.class);
    }

    @Override
    public CompletableFuture<Result<ChannelsKickResponse, SlackError>> kickUserFromChannel(ChannelsKickParams params) {
        return this.postSlackCommand((SlackMethod)SlackMethods.channels_kick, params, ChannelsKickResponse.class);
    }

    @Override
    public CompletableFuture<Result<ImOpenResponse, SlackError>> openIm(ImOpenParams params) {
        return this.postSlackCommand((SlackMethod)SlackMethods.im_open, params, ImOpenResponse.class);
    }

    @Override
    public CompletableFuture<Result<ChatPostMessageResponse, SlackError>> postMessage(ChatPostMessageParams params) {
        return this.postSlackCommand((SlackMethod)SlackMethods.chat_postMessage, params, ChatPostMessageResponse.class);
    }

    @Override
    public CompletableFuture<Result<ChatPostEphemeralMessageResponse, SlackError>> postEphemeralMessage(ChatPostEphemeralMessageParams params) {
        return this.postSlackCommand((SlackMethod)SlackMethods.chat_postEphemeral, params, ChatPostEphemeralMessageResponse.class);
    }

    @Override
    public CompletableFuture<Result<ChatUpdateMessageResponse, SlackError>> updateMessage(ChatUpdateMessageParams params) {
        return this.postSlackCommand((SlackMethod)SlackMethods.chat_update, params, ChatUpdateMessageResponse.class);
    }

    @Override
    public CompletableFuture<Result<ChatGetPermalinkResponse, SlackError>> getPermalink(ChatGetPermalinkParams params) {
        return this.postSlackCommand((SlackMethod)SlackMethods.chat_getPermalink, params, ChatGetPermalinkResponse.class);
    }

    @Override
    public CompletableFuture<Result<ChatDeleteResponse, SlackError>> deleteMessage(ChatDeleteParams params) {
        return this.postSlackCommand((SlackMethod)SlackMethods.chat_delete, params, ChatDeleteResponse.class);
    }

    @Override
    public Iterable<CompletableFuture<Result<List<Conversation>, SlackError>>> listConversations(final ConversationsListParams params) {
        return new AbstractPagedIterable<Result<List<Conversation>, SlackError>, String>(){

            @Override
            protected String getInitialOffset() {
                return null;
            }

            @Override
            protected LazyLoadingPage<Result<List<Conversation>, SlackError>, String> getPage(String offset) throws Exception {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Fetching slack conversation page from {}", (Object)offset);
                }
                ConversationsListParams.Builder requestBuilder = ConversationsListParams.builder().from((ConversationsListParamsIF)params).setLimit(SlackWebClient.this.config.getChannelsListBatchSize().get());
                Optional.ofNullable(offset).ifPresent(arg_0 -> ((ConversationsListParams.Builder)requestBuilder).setCursor(arg_0));
                CompletableFuture<Result<ConversationListResponse, SlackError>> resultFuture = SlackWebClient.this.postSlackCommand((SlackMethod)SlackMethods.conversations_list, requestBuilder.build(), ConversationListResponse.class);
                CompletionStage pageFuture = resultFuture.thenApply(result -> result.mapOk(ConversationListResponse::getConversations));
                CompletableFuture nextCursorMaybeFuture = SlackWebClient.this.extractNextCursor(resultFuture);
                CompletionStage hasMoreFuture = nextCursorMaybeFuture.thenApply(Optional::isPresent);
                CompletionStage nextCursorFuture = nextCursorMaybeFuture.thenApply(cursorMaybe -> cursorMaybe.orElse(null));
                return new LazyLoadingPage<Result<List<Conversation>, SlackError>, String>((CompletableFuture<Result<List<Conversation>, SlackError>>)pageFuture, (CompletableFuture<Boolean>)hasMoreFuture, (CompletableFuture<String>)nextCursorFuture);
            }
        };
    }

    @Override
    public Iterable<CompletableFuture<Result<List<Conversation>, SlackError>>> usersConversations(final ConversationsUserParams params) {
        return new AbstractPagedIterable<Result<List<Conversation>, SlackError>, String>(){

            @Override
            protected String getInitialOffset() {
                return null;
            }

            @Override
            protected LazyLoadingPage<Result<List<Conversation>, SlackError>, String> getPage(String offset) throws Exception {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Fetching slack user conversation page from {}", (Object)offset);
                }
                ConversationsUserParams.Builder requestBuilder = ConversationsUserParams.builder().from((ConversationsUserParamsIF)params).setLimit(SlackWebClient.this.config.getChannelsListBatchSize().get());
                Optional.ofNullable(offset).ifPresent(arg_0 -> ((ConversationsUserParams.Builder)requestBuilder).setCursor(arg_0));
                CompletableFuture<Result<ConversationListResponse, SlackError>> resultFuture = SlackWebClient.this.postSlackCommand((SlackMethod)SlackMethods.users_conversations, requestBuilder.build(), ConversationListResponse.class);
                CompletionStage pageFuture = resultFuture.thenApply(result -> result.mapOk(ConversationListResponse::getConversations));
                CompletableFuture nextCursorMaybeFuture = SlackWebClient.this.extractNextCursor(resultFuture);
                CompletionStage hasMoreFuture = nextCursorMaybeFuture.thenApply(Optional::isPresent);
                CompletionStage nextCursorFuture = nextCursorMaybeFuture.thenApply(cursorMaybe -> cursorMaybe.orElse(null));
                return new LazyLoadingPage<Result<List<Conversation>, SlackError>, String>((CompletableFuture<Result<List<Conversation>, SlackError>>)pageFuture, (CompletableFuture<Boolean>)hasMoreFuture, (CompletableFuture<String>)nextCursorFuture);
            }
        };
    }

    @Override
    public CompletableFuture<Result<ConversationsCreateResponse, SlackError>> createConversation(ConversationCreateParams params) {
        return this.postSlackCommand((SlackMethod)SlackMethods.conversations_create, params, ConversationsCreateResponse.class);
    }

    @Override
    public CompletableFuture<Result<ConversationsInviteResponse, SlackError>> inviteToConversation(ConversationInviteParams params) {
        return this.postSlackCommand((SlackMethod)SlackMethods.conversations_invite, params, ConversationsInviteResponse.class);
    }

    @Override
    public CompletableFuture<Result<ConversationsUnarchiveResponse, SlackError>> unarchiveConversation(ConversationUnarchiveParams params) {
        return this.postSlackCommand((SlackMethod)SlackMethods.conversations_unarchive, params, ConversationsUnarchiveResponse.class);
    }

    @Override
    public Iterable<CompletableFuture<Result<List<LiteMessage>, SlackError>>> getConversationHistory(final ConversationsHistoryParams params) {
        final PagingDirection pagingDirection = params.getPagingDirection();
        return new AbstractPagedIterable<Result<List<LiteMessage>, SlackError>, Long>(){

            @Override
            protected Long getInitialOffset() {
                return null;
            }

            @Override
            protected LazyLoadingPage<Result<List<LiteMessage>, SlackError>, Long> getPage(Long offset) throws Exception {
                ConversationsHistoryParams.Builder requestBuilder = ConversationsHistoryParams.builder().from((AbstractConversationsHistoryParams)params);
                if (!params.getLimit().isPresent()) {
                    requestBuilder.setLimit(SlackWebClient.this.config.getConversationsHistoryMessageBatchSize().get());
                }
                Optional.ofNullable(offset).ifPresent(presentOffset -> {
                    if (pagingDirection == PagingDirection.FORWARD_IN_TIME) {
                        requestBuilder.setOldestTimestamp(presentOffset.toString());
                    } else {
                        requestBuilder.setNewestTimestamp(presentOffset.toString());
                    }
                });
                ConversationsHistoryParams currentRequest = requestBuilder.build();
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Fetching conversation history page for {} from [{}, {}]", new Object[]{currentRequest.getChannelId(), currentRequest.getOldestTimestamp(), currentRequest.getNewestTimestamp()});
                }
                CompletableFuture<Result<ConversationsHistoryResponse, SlackError>> resultFuture = SlackWebClient.this.postSlackCommand((SlackMethod)SlackMethods.conversations_history, currentRequest, ConversationsHistoryResponse.class);
                CompletionStage pageFuture = resultFuture.thenApply(result -> result.mapOk(ConversationsHistoryResponse::getMessages));
                CompletionStage hasMoreFuture = resultFuture.thenApply(result -> (Boolean)result.match(err -> false, ok -> ok.hasMore()));
                CompletableFuture nextOffset = SlackWebClient.this.nextOffset(pagingDirection, (CompletableFuture)pageFuture);
                return new LazyLoadingPage<Result<List<LiteMessage>, SlackError>, Long>((CompletableFuture<Result<List<LiteMessage>, SlackError>>)pageFuture, (CompletableFuture<Boolean>)hasMoreFuture, nextOffset);
            }
        };
    }

    @Override
    public CompletableFuture<Result<ConversationsArchiveResponse, SlackError>> archiveConversation(ConversationArchiveParams params) {
        return this.postSlackCommand((SlackMethod)SlackMethods.conversations_archive, params, ConversationsArchiveResponse.class);
    }

    @Override
    public CompletableFuture<Result<ConversationsInfoResponse, SlackError>> getConversationInfo(ConversationsInfoParams params) {
        return this.postSlackCommand((SlackMethod)SlackMethods.conversations_info, params, ConversationsInfoResponse.class);
    }

    @Override
    public CompletableFuture<Result<Conversation, SlackError>> getConversationByName(String conversationName, ConversationsFilter conversationsFilter) {
        return this.findConversationByName(conversationName, conversationsFilter).thenApply(conversation -> {
            if (conversation.isPresent()) {
                return Result.ok(conversation.get());
            }
            return Result.err((Object)SlackError.builder().setType(SlackErrorType.CHANNEL_NOT_FOUND).setError("No conversation found with name: " + conversationName).build());
        });
    }

    @Override
    public CompletableFuture<Result<ConversationsOpenResponse, SlackError>> openConversation(ConversationOpenParams params) {
        return this.postSlackCommand((SlackMethod)SlackMethods.conversations_open, params, ConversationsOpenResponse.class);
    }

    @Override
    public Iterable<CompletableFuture<Result<List<String>, SlackError>>> getConversationMembers(final ConversationMemberParams params) {
        return new AbstractPagedIterable<Result<List<String>, SlackError>, String>(){

            @Override
            protected String getInitialOffset() {
                return null;
            }

            @Override
            protected LazyLoadingPage<Result<List<String>, SlackError>, String> getPage(String offset) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Fetching slack conversation members page from {}", (Object)offset);
                }
                ConversationMemberParams.Builder requestBuilder = ConversationMemberParams.builder().from((ConversationMemberParamsIF)params);
                if (!params.getLimit().isPresent()) {
                    requestBuilder.setLimit(SlackWebClient.this.config.getConversationMembersBatchSize().get());
                }
                Optional.ofNullable(offset).ifPresent(arg_0 -> ((ConversationMemberParams.Builder)requestBuilder).setCursor(arg_0));
                ConversationMemberParams params2 = requestBuilder.build();
                CompletableFuture<Result<ConversationMemberResponse, SlackError>> resultFuture = SlackWebClient.this.postSlackCommand((SlackMethod)SlackMethods.conversations_members, params2, ConversationMemberResponse.class);
                CompletionStage pageFuture = resultFuture.thenApply(result -> result.mapOk(ConversationMemberResponse::getMemberIds));
                CompletableFuture nextCursorMaybeFuture = SlackWebClient.this.extractNextCursor(resultFuture);
                CompletionStage hasMoreFuture = nextCursorMaybeFuture.thenApply(Optional::isPresent);
                CompletionStage nextCursorFuture = nextCursorMaybeFuture.thenApply(cursorMaybe -> cursorMaybe.orElse(null));
                return new LazyLoadingPage<Result<List<String>, SlackError>, String>((CompletableFuture<Result<List<String>, SlackError>>)pageFuture, (CompletableFuture<Boolean>)hasMoreFuture, (CompletableFuture<String>)nextCursorFuture);
            }
        };
    }

    private CompletableFuture<Optional<Conversation>> findConversationByName(String conversationName, ConversationsFilter conversationsFilter) {
        return this.searchNextConversationPage(conversationName, this.listConversations(ConversationsListParams.builder().from((BaseConversationsFilter)conversationsFilter).build()).iterator());
    }

    private CompletableFuture<Optional<Conversation>> searchNextConversationPage(String conversationName, Iterator<CompletableFuture<Result<List<Conversation>, SlackError>>> pageIterator) {
        if (!pageIterator.hasNext()) {
            return CompletableFuture.completedFuture(Optional.empty());
        }
        CompletableFuture<Result<List<Conversation>, SlackError>> nextPage = pageIterator.next();
        return ((CompletableFuture)nextPage.thenApply(Result::unwrapOrElseThrow)).thenComposeAsync(conversations -> {
            Optional<Conversation> matchInPage = conversations.stream().filter(conversation -> conversation.getName().isPresent() && ((String)conversation.getName().get()).equals(conversationName)).findFirst();
            if (matchInPage.isPresent()) {
                return CompletableFuture.completedFuture(matchInPage);
            }
            return this.searchNextConversationPage(conversationName, pageIterator);
        }, (Executor)this.recursingExecutor);
    }

    @Override
    public CompletableFuture<Result<UsergroupCreateResponse, SlackError>> createUsergroup(UsergroupCreateParams params) {
        return this.postSlackCommand((SlackMethod)SlackMethods.usergroups_create, params, UsergroupCreateResponse.class);
    }

    @Override
    public Iterable<CompletableFuture<Result<List<SlackUsergroup>, SlackError>>> listUsergroups(final UsergroupListParams params) {
        return new AbstractPagedIterable<Result<List<SlackUsergroup>, SlackError>, String>(){

            @Override
            protected String getInitialOffset() {
                return null;
            }

            @Override
            protected LazyLoadingPage<Result<List<SlackUsergroup>, SlackError>, String> getPage(String offset) throws Exception {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Fetching slack usergroup page from {}", (Object)offset);
                }
                CompletableFuture<Result<UsergroupListResponse, SlackError>> resultFuture = SlackWebClient.this.postSlackCommand((SlackMethod)SlackMethods.usergroups_list, UsergroupListParams.builder().from((UsergroupListParamsIF)params).build(), UsergroupListResponse.class);
                CompletionStage pageFuture = resultFuture.thenApply(result -> result.mapOk(UsergroupListResponse::getUsergroups));
                CompletableFuture nextCursorMaybeFuture = SlackWebClient.this.extractNextCursor(resultFuture);
                CompletionStage hasMoreFuture = nextCursorMaybeFuture.thenApply(Optional::isPresent);
                CompletionStage nextCursorFuture = nextCursorMaybeFuture.thenApply(cursorMaybe -> cursorMaybe.orElse(null));
                return new LazyLoadingPage<Result<List<SlackUsergroup>, SlackError>, String>((CompletableFuture<Result<List<SlackUsergroup>, SlackError>>)pageFuture, (CompletableFuture<Boolean>)hasMoreFuture, (CompletableFuture<String>)nextCursorFuture);
            }
        };
    }

    @Override
    public CompletableFuture<Result<UsergroupUpdateResponse, SlackError>> updateUsergroup(UsergroupUpdateParams params) {
        return this.postSlackCommand((SlackMethod)SlackMethods.usergroups_update, params, UsergroupUpdateResponse.class);
    }

    @Override
    public CompletableFuture<Result<UsergroupEnableResponse, SlackError>> enableUsergroup(UsergroupEnableParams params) {
        return this.postSlackCommand((SlackMethod)SlackMethods.usergroups_enable, params, UsergroupEnableResponse.class);
    }

    @Override
    public CompletableFuture<Result<UsergroupDisableResponse, SlackError>> disableUsergroup(UsergroupDisableParams params) {
        return this.postSlackCommand((SlackMethod)SlackMethods.usergroups_disable, params, UsergroupDisableResponse.class);
    }

    @Override
    public CompletableFuture<Result<UsergroupUsersUpdateResponse, SlackError>> updateUsergroupUsers(UsergroupUsersUpdateParams params) {
        return this.postSlackCommand((SlackMethod)SlackMethods.usergroups_users_update, params, UsergroupUsersUpdateResponse.class);
    }

    @Override
    public CompletableFuture<Result<DialogOpenResponse, SlackError>> openDialog(DialogOpenParams params) {
        return this.postSlackCommand((SlackMethod)SlackMethods.dialog_open, params, DialogOpenResponse.class);
    }

    @Override
    public CompletableFuture<Result<AddReactionResponse, SlackError>> addReaction(ReactionsAddParams params) {
        return this.postSlackCommand((SlackMethod)SlackMethods.reactions_add, params, AddReactionResponse.class);
    }

    @Override
    public CompletableFuture<Result<FilesUploadResponse, SlackError>> uploadFile(FilesUploadParams params) {
        return this.postSlackCommand((SlackMethod)SlackMethods.files_upload, params, FilesUploadResponse.class);
    }

    @Override
    public CompletableFuture<Result<FilesSharedPublicUrlResponse, SlackError>> shareFilePublically(FilesSharedPublicUrlParams params) {
        return this.postSlackCommand((SlackMethod)SlackMethods.files_sharedPublicURL, params, FilesSharedPublicUrlResponse.class);
    }

    @Override
    public Iterable<CompletableFuture<Result<List<SlackGroup>, SlackError>>> listGroups(final GroupsListParams filter) {
        return new AbstractPagedIterable<Result<List<SlackGroup>, SlackError>, String>(){

            @Override
            protected String getInitialOffset() {
                return null;
            }

            @Override
            protected LazyLoadingPage<Result<List<SlackGroup>, SlackError>, String> getPage(String offset) throws Exception {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Fetching slack group page from {}", (Object)offset);
                }
                CompletableFuture<Result<GroupsListResponse, SlackError>> resultFuture = SlackWebClient.this.postSlackCommand((SlackMethod)SlackMethods.groups_list, GroupsListParams.builder().from((GroupsListParamsIF)filter).build(), GroupsListResponse.class);
                CompletionStage pageFuture = resultFuture.thenApply(result -> result.mapOk(GroupsListResponse::getGroups));
                CompletableFuture nextCursorMaybeFuture = SlackWebClient.this.extractNextCursor(resultFuture);
                CompletionStage hasMoreFuture = nextCursorMaybeFuture.thenApply(Optional::isPresent);
                CompletionStage nextCursorFuture = nextCursorMaybeFuture.thenApply(cursorMaybe -> cursorMaybe.orElse(null));
                return new LazyLoadingPage<Result<List<SlackGroup>, SlackError>, String>((CompletableFuture<Result<List<SlackGroup>, SlackError>>)pageFuture, (CompletableFuture<Boolean>)hasMoreFuture, (CompletableFuture<String>)nextCursorFuture);
            }
        };
    }

    @Override
    public CompletableFuture<Result<GroupsKickResponse, SlackError>> kickUserFromGroup(GroupsKickParams params) {
        return this.postSlackCommand((SlackMethod)SlackMethods.groups_kick, params, GroupsKickResponse.class);
    }

    @Override
    public CompletableFuture<Result<TeamInfoResponse, SlackError>> getTeamInfo() {
        return this.postSlackCommand((SlackMethod)SlackMethods.team_info, new Object(), TeamInfoResponse.class);
    }

    @Override
    public CompletableFuture<Result<EmojiListResponse, SlackError>> listEmoji() {
        return this.postSlackCommand((SlackMethod)SlackMethods.emoji_list, Collections.emptyMap(), EmojiListResponse.class);
    }

    @Override
    public <T extends SlackResponse> CompletableFuture<Result<T, SlackError>> postSlackCommand(SlackMethod method, Object params, Class<T> returnClazz) {
        if (!this.methodAcceptor.test(method, params)) {
            LOG.info("Acceptor failed: {}", (Object)this.methodAcceptor.getFailureExplanation(method, params));
            return CompletableFuture.completedFuture(Result.err((Object)SlackError.builder().setType(SlackErrorType.PARAMS_FAILED_API_FILTER).setError(SlackErrorType.PARAMS_FAILED_API_FILTER.getCode()).build()));
        }
        if (method.jsonWhitelistStatus() == JsonStatus.ACCEPTS_JSON) {
            return this.postSlackCommandJsonEncoded(method, params, returnClazz);
        }
        return this.postSlackCommandUrlEncoded(method, (Multimap<String, String>)HttpRequestHelper.objectToQueryParams(params), returnClazz);
    }

    private <T extends SlackResponse> CompletableFuture<Result<T, SlackError>> postSlackCommandJsonEncoded(SlackMethod method, Object params, Class<T> responseType) {
        HttpRequest request = this.buildBaseSlackPost(method).setContentType(HttpRequest.ContentType.JSON).setBody(params).addHeader("Authorization", "Bearer " + this.config.getTokenSupplier().get()).build();
        return this.executeLoggedAs(method, request, responseType);
    }

    private HttpRequest.Builder buildBaseSlackPost(SlackMethod method) {
        return HttpRequest.newBuilder().setMethod(HttpRequest.Method.POST).setUrl(this.config.getSlackApiBasePath().get() + "/" + method.getMethod());
    }

    @VisibleForTesting
    <T extends SlackResponse> CompletableFuture<Result<T, SlackError>> executeLoggedAs(SlackMethod method, HttpRequest request, Class<T> responseType) {
        long requestId = REQUEST_COUNTER.getAndIncrement();
        this.requestDebugger.debug(requestId, method, request);
        Stopwatch timer = Stopwatch.createStarted();
        double acquireSeconds = this.acquirePermit(method);
        if (acquireSeconds == -1.0) {
            this.responseDebugger.debugProactiveRateLimit(requestId, method, request);
            return CompletableFuture.completedFuture(Result.err((Object)SlackError.of((String)SlackErrorType.RATE_LIMITED.key())));
        }
        return this.executeLogged(requestId, method, request, timer).thenApply(response -> {
            try {
                return this.parseSlackResponse((HttpResponse)response, responseType, requestId, method, request);
            }
            catch (JsonProcessingException e) {
                this.responseDebugger.debugProcessingFailure(requestId, method, request, (HttpResponse)response, e);
                return Result.err((Object)SlackError.builder().setError(SlackErrorType.JSON_PARSING_FAILED.getCode()).setType(SlackErrorType.JSON_PARSING_FAILED).build());
            }
            catch (RuntimeException ex) {
                this.responseDebugger.debugProcessingFailure(requestId, method, request, (HttpResponse)response, ex);
                throw ex;
            }
        });
    }

    private <T extends SlackResponse> Result<T, SlackError> parseSlackResponse(HttpResponse response, Class<T> responseType, long requestId, SlackMethod method, HttpRequest request) throws JsonProcessingException {
        JsonNode responseJson = response.getAsJsonNode();
        boolean isOk = responseJson.get("ok").asBoolean();
        if (isOk) {
            return Result.ok((Object)ObjectMapperUtils.mapper().treeToValue((TreeNode)responseJson, responseType));
        }
        SlackErrorResponse errorResponse = (SlackErrorResponse)ObjectMapperUtils.mapper().treeToValue((TreeNode)response.getAsJsonNode(), SlackErrorResponse.class);
        this.responseDebugger.debugSlackApiError(requestId, method, request, response);
        return Result.err((Object)errorResponse.getError().orElseGet(() -> (SlackError)errorResponse.getErrors().get(0)));
    }

    private <T extends SlackResponse> CompletableFuture<Result<T, SlackError>> postSlackCommandUrlEncoded(SlackMethod method, Multimap<String, String> params, Class<T> responseType) {
        HttpRequest.Builder requestBuilder = this.buildBaseSlackPost(method).setContentType(HttpRequest.ContentType.FORM);
        params.entries().forEach(param -> requestBuilder.setFormParam((String)param.getKey()).to(new String[]{(String)param.getValue()}));
        requestBuilder.setQueryParam("token").to(new String[]{this.config.getTokenSupplier().get()});
        return this.executeLoggedAs(method, requestBuilder.build(), responseType);
    }

    private CompletableFuture<HttpResponse> executeLogged(long requestId, SlackMethod method, HttpRequest request, Stopwatch timer) {
        CompletableFuture<HttpResponse> responseFuture = this.nioHttpClient.executeCompletableFuture(request);
        responseFuture.whenComplete((httpResponse, throwable) -> {
            if (throwable != null) {
                this.responseDebugger.debugTransportException(requestId, method, request, (Throwable)throwable);
            } else {
                this.responseDebugger.debug(requestId, method, timer, request, (HttpResponse)httpResponse);
            }
        });
        return responseFuture;
    }

    private double acquirePermit(SlackMethod method) {
        double acquireSeconds = this.getSlackRateLimiter().acquire(this.config.getTokenSupplier().get(), method);
        if (acquireSeconds > 5.0) {
            LOG.warn("Throttling {}, waited {} seconds to acquire permit to run", (Object)method, (Object)acquireSeconds);
        }
        return acquireSeconds;
    }

    private SlackRateLimiter getSlackRateLimiter() {
        return this.config.getSlackRateLimiter().orElse(this.defaultRateLimiter);
    }

    @Override
    public void close() throws IOException {
        this.recursingExecutor.close();
        this.nioHttpClient.close();
    }

    public static interface Factory {
        public SlackWebClient build(@Assisted SlackClientRuntimeConfig var1);
    }
}

