/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.http.status;

import com.hubspot.slack.client.http.status.HttpStatusFamily;
import com.hubspot.slack.client.http.status.HttpStatusImpl;
import com.hubspot.slack.client.http.status.StandardHttpStatus;

public interface HttpStatus {
    public int getCode();

    public HttpStatusFamily getFamily();

    public static HttpStatus forCode(int code) {
        return StandardHttpStatus.lookup(code).orElseGet(() -> new HttpStatusImpl(code));
    }

    default public boolean isInformation() {
        return this.getFamily() == HttpStatusFamily.INFORMATION;
    }

    default public boolean isSuccess() {
        return this.getFamily() == HttpStatusFamily.SUCCESS;
    }

    default public boolean isRedirect() {
        return this.getFamily() == HttpStatusFamily.REDIRECT;
    }

    default public boolean isNotFound() {
        return this.getCode() == StandardHttpStatus.NOT_FOUND.getCode();
    }

    default public boolean isError() {
        return this.isClientError() || this.isServerError();
    }

    default public boolean isClientError() {
        return this.getFamily() == HttpStatusFamily.CLIENT_ERROR;
    }

    default public boolean isServerError() {
        return this.getFamily() == HttpStatusFamily.SERVER_ERROR;
    }

    default public boolean isValid() {
        return this.getFamily() != HttpStatusFamily.INVALID;
    }
}

