package com.huifu.adapay;

/**
 * @author will.wang
 */
public enum APIUrlEnum {
    /**
     * 支付
     */
    PAYMENT_V1("/v1/payments", "支付V1"),
    /**
     * 支付查询
     */
    QUERY_PAYMENT_V1("/v1/payments/", "支付查询V1"),
    /**
     * 关单
     */
    CLOSE_PAYMENT_V1("/v1/payments/", "关单V1"),

    /**
     * 支付撤销
     */
    REVERSE_PAYMENT_V1("/v1/payments/reverse", "支付撤销V1"),

    /**
     * 查询支付撤销
     */
    QUERY_REVERSE_PAYMENT_V1("/v1/payments/reverse/", "支付撤销查询V1"),

    /**
     * 支付撤销列表查询
     */
    REVERSE_PAYMENT_LIST_V1("/v1/payments/reverse/list", "支付撤销列表查询V1"),

    /**
     * 支付确认
     */
    CONFIRM_PAYMENT_V1("/v1/payments/confirm", "支付确认V1"),

    /**
     * 支付确认查询
     */
    QUERY_CONFIRM_PAYMENT_V1("/v1/payments/confirm/", "支付确认查询V1"),

    /**
     * 支付确认列表查询
     */
    CONFIRM_PAYMENT_LIST_V1("/v1/payments/confirm/list", "支付确认列表查询V1"),

    /**
     * 退款
     */
    REFUND_V1("/v1/payments/", "退款V1"),
    /**
     * 退款查询
     */
    QUERY_REFUND_V1("/v1/payments/refunds", "退款查询V1"),

    /**
     * 创建用户
     */
    MEMBER_V1("/v1/members", "用户V1"),

    /**
     * 查询用户对象
     */
    QUERY_MEMBER_V1("/v1/members/", "查询用户V1"),

    /**
     * 查询用户列表
     */
    QUERY_MEMBER_LIST_V1("/v1/members/list", "查询用户V1"),
    /**
     * 更新用户
     */
    UPDATE_MEMBER_V1("/v1/members/update", "更新用户V1"),

    /**
     * 创建企业用户对象
     */
    CORP_MEMBER_V1("/v1/corp_members", "企业用户V1"),

    /**
     * 查询企业用户对象
     */
    QUERY_CORP_MEMBER_V1("/v1/corp_members/", "查询企业用户V1"),

    /**
     * 创建结算账户
     */
    SETTLE_ACCOUNT_V1("/v1/settle_accounts", "创建结算账户v1"),

    /**
     * 查询结算账户
     */
    QUERY_SETTLE_ACCOUNT_V1("/v1/settle_accounts/", "查询结算账户V1"),

    /**
     * 查询结算明细列表
     */
    QUERY_SETTLE_DETAILS_V1("/v1/settle_accounts/settle_details", "查询结算明细列表V1"),

    /**
     * 删除结算账户
     */
    DELETE_SETTLE_ACCOUNT_V1("/v1/settle_accounts/delete", "删除结算账户V1"),

    /**
     * 修改结算账户
     */
    MODIFY_SETTLE_ACCOUNT_V1("/v1/settle_accounts/modify", "修改结算账户V1"),

    /**
     * 获取银联云闪付用户标识
     */
    UNION_USER_ID_V1("/v1/union/user_identity", "获取银联云闪付用户标识"),

    /**
     * 下载对账单
     */
    BILL_DOWNLOAD_V1("/v1/bill/download", "下载对账单"),

    /**
     * 创建取现对象
     */
    CASH_V1("/v1/cashs", "创建取现对象"),

    /**
     * 查询取现对象
     */
    QUERY_CASH_V1("/v1/cashs/stat", "查询取现对象"),

    /**
     * 查询账户余额对象
     */
    QUERY_BALANCE_V1("/v1/settle_accounts/balance", "查询账户余额对象"),


    /**
     * 查询账户余额对象
     */
    USER_LOGIN_V1("/v1/walletLogin", "用户登录对象"),
    USER_WALLET("/page/wallet/v1/", "用户钱包"),
    PAYMENT_PAGE_V1("/v1/account/payment", "钱包支付V1"),
    /**
     * 收银台支付
     */
    PAYMENT_CHECK_V1("/v1/checkout", "收银台对象V1"),
    /**
     * 查询支付对象列表
     */
    QUERY_PAYMENT_LIST_V1("/v1/payments/list", "支付对象列表查询"),

    /**
     * 查询收银台对象列表
     */
    QUERY_CHECKOUT_LIST_V1("/v1/checkout/list", "收银台对象列表查询"),

    /**
     * 创建账户转账对象
     */
    SETTLE_ACCOUNTS_TRANSFER_V1("/v1/settle_accounts/transfer", "创建账户转账对象"),

    /**
     * 查询账户转账对象列表
     */
    SETTLE_ACCOUNTS_TRANSFER_LIST_V1("/v1/settle_accounts/transfer/list", "转账对象列表查询"),


    /**
     * 创建账户冻结对象
     */
    SETTLE_ACCOUNTS_FREEZE_V1("/v1/settle_accounts/freeze", "创建账户冻结对象"),

    /**
     * 查询账户冻结对象列表
     */
    SETTLE_ACCOUNTS_FREEZE_LIST_V1("/v1/settle_accounts/freeze/list", "冻结对象列表查询"),

    /**
     * 创建账户解冻对象
     */
    SETTLE_ACCOUNTS_UNFREEZE_V1("/v1/settle_accounts/unfreeze", "创建账户解冻对象"),

    /**
     * 查询账户解冻对象列表
     */
    SETTLE_ACCOUNTS_UNFREEZE_LIST_V1("/v1/settle_accounts/unfreeze/list", "解冻对象列表查询"),

    /**
     * 创建快捷绑卡申请
     */
    FAST_CARD_APPLY_V1("/v1/fast_card/apply", "创建快捷绑卡申请"),

    /**
     * 创建快捷绑卡确认
     */
    FAST_CARD_CONFIRM_V1("/v1/fast_card/confirm", "创建快捷绑卡确认"),

    /**
     * 查询快捷卡对象列表
     */
    FAST_CARD_LIST_V1("/v1/fast_card/list", "查询快捷卡对象列表"),

    /**
     * 快捷支付确认
     */
    FAST_PAY_CONFIRM_V1("/v1/fast_pay/confirm", "快捷支付确认"),

    /**
     * 快捷支付重发短信
     */
    FAST_PAY_SMS_CODE_V1("/v1/fast_pay/sms_code", "快捷支付重发短信"),

    /**
     * 查询服务商分账对象列表
     */
    SETTLE_ACCOUNTS_COMMISSIONS_LIST_V1("/v1/settle_accounts/commissions/list", "查询服务商分账对象列表"),

    /**
     * 创建服务商分账对象
     */
    SETTLE_ACCOUNTS__COMMISSIONS_V1("/v1/settle_accounts/commissions", "创建服务商分账对象"),

    /**
     * 微信小程序预下单
     */
    WX_PAY_CREATE_ORDER_V1("/v1/wxpay/createOrder", "微信小程序预下单"),

    /**
     * 微信小程序下单
     */
    WX_PAY_ORDER_V1("/v1/wxapay/payOrder", "快捷支付重发短信"),

    /**
     * H5查询接口
     */
    WX_PAY_QUERY_HASH_V1("/v1/wxpay/queryHash", "查询服务商分账对象列表");


    private String code;
    private String desc;

    APIUrlEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static APIUrlEnum findByCode(String code) {
        for (APIUrlEnum respEnum : values()) {
            if (respEnum.getCode().equals(code)) {
                return respEnum;
            }
        }
        return null;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public APIUrlEnum replaceUrlId(String id) {
        setCode(getCode().replace("%id%", id));
        return this;
    }
}
