package com.huifu.adapay;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import com.huifu.adapay.core.AdapayCore;
import com.huifu.adapay.model.MerConfig;

/**
 * @author jane.zhao
 */
public class Adapay {
    private Adapay() {

    }

    public static volatile String sdk_version = "Java_v1.2.5";

    public static volatile String publicKey = null;


    /**
     * 商户服务器为单服务器时传入，固定id,集群服务器可忽略
     */
    public static volatile String deviceID = "Adapay_0001";

    /** 商户使用时必须先设置的全局数据 end */

    /**
     * 是否打印调用日志，默认不打印
     */
    public static volatile boolean debug = false;

    /**
     * 是否是prod_mode 默认为 true
     */
    public static volatile boolean prodMode = true;

    /**
     * 是否是prod_mode 默认为 true
     */
    public static volatile boolean verifyRSA = true;

    /**
     * adapay服务器地址
     */
    public static volatile String apiBase = "https://api.adapay.tech";

    /**
     * adapay服务器地址
     */
    public static volatile String pageBase = "https://page.adapay.tech";

    /**
     * adapay默认商户配置存储key
     */
    public static final String defaultMerchantKey = "default";

    private static volatile Map<String, MerConfig> configMap = new HashMap<>();

    public static void addMerConfig(MerConfig merConfig, String merchantKey) throws Exception {
        configMap.put(merchantKey, merConfig);
    }

    /**
     * @param merConfig 商户配置文件路径
     */
    public static void initWithMerConfig(MerConfig merConfig) throws Exception {
        configEnv();
        if (merConfig == null) {
            throw new Exception("配置不能为空");
        }
        configMap.put(defaultMerchantKey, merConfig);
    }

    /**
     * 配置环境参数
     */
    private static void configEnv() {
        AdapayCore.debug = debug;
        AdapayCore.apiBase = apiBase;
        AdapayCore.pageBase = pageBase;
        AdapayCore.sdkVersion = sdk_version;
        if (null != Adapay.publicKey) {
            AdapayCore.PUBLIC_KEY = Adapay.publicKey;
        }

    }

    /**
     * @param multiConfigs 商户配置信息
     */
    public static void initWithMerConfigs(Map<String, MerConfig> multiConfigs) throws Exception {
        configEnv();
        if (multiConfigs == null) {
            throw new Exception("配置信息不能为空");
        }
        if (multiConfigs.size() > 0) {
            for (Map.Entry<String, MerConfig> entry : multiConfigs.entrySet()) {
                try {
                    configMap.put(entry.getKey(), entry.getValue());
                } catch (Exception e) {
                    System.out.println("初始化校验配置出现错误，常见是秘钥不匹配," + entry.getValue().getApiKey());
                }
            }
        } else {
            throw new Exception("配置信息不能为空");
        }

    }


    public static MerConfig getConfig(String merchantKey) {
        return configMap.get(merchantKey);
    }

    /**
     * @return the deviceID
     */
    public static String getDeviceID() {
        return deviceID;
    }

    /**
     * @param deviceID the deviceID to set
     */
    public static void setDeviceID(String deviceID) {
        Adapay.deviceID = deviceID;
    }
}
