package com.huifu.adapay.model;

import com.huifu.adapay.core.exception.BaseAdaPayException;
import com.huifu.adapay.core.exception.FailureCode;
import com.huifu.adapay.core.util.ServerTypeEnum;
import org.apache.commons.lang3.StringUtils;

import java.io.File;
import java.util.Map;

/**
 * @ClassName: AdapayCommon
 * @Description: 通用请求接口
 * @Create by: chunying.jia
 * @Date: 2021/4/16 10:00 上午
 */
public class AdapayCommon {

    private static String packageRequestUrl(Map<String, Object> requestParams) throws BaseAdaPayException {
        String adapayFuncCode = (String) requestParams.get("adapay_func_code");
        if (StringUtils.isBlank(adapayFuncCode)){
            throw new BaseAdaPayException(FailureCode.ADAPAY_FUNC_CODE_NOT_BLANK.getFailureCode());
        }
        String adapayApiVersion = (String) requestParams.getOrDefault("adapay_api_version", "v1");
        return "/" + adapayApiVersion + "/" + StringUtils.replace(adapayFuncCode, ".", "/");
    }

    /**
     * 通用请求接口 - POST - 多商户模式
     *
     * @param params      请求参数
     * @param merchantKey merchantKey
     * @return POST返回对象
     * @throws BaseAdaPayException 异常
     */
    public static Map<String, Object> requestAdapay(Map<String, Object> params, String merchantKey) throws BaseAdaPayException {

        return AdapayRequest.requestAdapay(AdapayCommon.packageRequestUrl(params), params, merchantKey);
    }

    /**
     * 通用请求接口 - POST
     *
     * @param params      请求参数
     * @return POST返回对象
     * @throws BaseAdaPayException 异常
     */
    public static Map<String, Object> requestAdapay(Map<String, Object> params) throws BaseAdaPayException {
        return AdapayRequest.requestAdapay(AdapayCommon.packageRequestUrl(params), params);
    }

    /**
     * 通用请求接口 - POST - 多商户模式
     *
     * @param params      请求参数
     * @param file        文件流对象
     * @param merchantKey merchantKey
     * @return POST返回对象
     * @throws BaseAdaPayException 异常
     */
    public static Map<String, Object> requestAdapayFile(Map<String, Object> params, File file, String merchantKey) throws BaseAdaPayException {
        return AdapayRequest.requestAdapay(AdapayCommon.packageRequestUrl(params), params,  file, "attach_file", merchantKey);
    }

    /**
     * 通用请求接口 - POST
     *
     * @param params      请求参数
     * @param file        文件流对象
     * @return POST返回对象
     * @throws BaseAdaPayException 异常
     */
    public static Map<String, Object> requestAdapayFile(Map<String, Object> params, File file) throws BaseAdaPayException {
        return AdapayRequest.requestAdapay(AdapayCommon.packageRequestUrl(params), params, file,"attach_file", "default" );
    }

    /**
     * 通用查询接口 - GET - 多商户模式
     *
     * @param params      请求参数
     * @param merchantKey merchantKey
     * @return GET返回对象
     * @throws BaseAdaPayException 异常
     */
    public static Map<String, Object> queryAdapay(Map<String, Object> params, String merchantKey) throws BaseAdaPayException {
        return AdapayRequest.getRequestAdapay(AdapayCommon.packageRequestUrl(params), params, merchantKey);
    }

    /**
     * 通用查询接口 - GET
     *
     * @param params      请求参数
     * @return GET返回对象
     * @throws BaseAdaPayException 异常
     */
    public static Map<String, Object> queryAdapay(Map<String, Object> params) throws BaseAdaPayException {
        return AdapayRequest.getRequestAdapay(AdapayCommon.packageRequestUrl(params), params);
    }

    /**
     * 通用请求接口 - POST - 多商户模式
     *
     * @param params      请求参数
     * @param merchantKey merchantKey
     * @return POST返回对象
     * @throws BaseAdaPayException 异常
     */
    public static Map<String, Object> requestAdapayUits(Map<String, Object> params, String merchantKey) throws BaseAdaPayException {
        return AdapayRequest.requestAdapay(AdapayCommon.packageRequestUrl(params), params, merchantKey, ServerTypeEnum.PAGE);
    }

    /**
     * 通用请求接口 - POST
     *
     * @param params      请求参数
     * @return POST返回对象
     * @throws BaseAdaPayException 异常
     */
    public static Map<String, Object> requestAdapayUits(Map<String, Object> params) throws BaseAdaPayException {
        return AdapayRequest.requestAdapay(AdapayCommon.packageRequestUrl(params), params, ServerTypeEnum.PAGE);
    }

    /**
     * 通用查询接口 - GET - 多商户模式
     *
     * @param params      请求参数
     * @param merchantKey merchantKey
     * @return GET返回对象
     * @throws BaseAdaPayException 异常
     */
    public static Map<String, Object> queryAdapayUits(Map<String, Object> params, String merchantKey) throws BaseAdaPayException {
        return AdapayRequest.getRequestAdapay(AdapayCommon.packageRequestUrl(params), params, merchantKey, ServerTypeEnum.PAGE);
    }

    /**
     * 通用查询接口 - GET
     *
     * @param params      请求参数
     * @return GET返回对象
     * @throws BaseAdaPayException 异常
     */
    public static Map<String, Object> queryAdapayUits(Map<String, Object> params) throws BaseAdaPayException {
        return AdapayRequest.getRequestAdapay(AdapayCommon.packageRequestUrl(params), params, ServerTypeEnum.PAGE);
    }

}
