package com.huifu.adapay.model;

import java.io.File;
import java.util.Map;

import com.huifu.adapay.Adapay;
import com.huifu.adapay.core.exception.BaseAdaPayException;
import com.huifu.adapay.core.exception.FailureCode;
import com.huifu.adapay.core.net.AbstractRequest;
import com.huifu.adapay.core.util.ServerTypeEnum;

public class AdapayRequest extends AbstractRequest {

    public static Map<String, Object> requestAdapay(String uri, Map<String, Object> params) throws BaseAdaPayException {
        return requestAdapay(uri, params, Adapay.defaultMerchantKey);
    }

    public static Map<String, Object> requestAdapay(String uri, Map<String, Object> params, ServerTypeEnum serverType) throws BaseAdaPayException {
        return requestAdapay(uri, params, Adapay.defaultMerchantKey, serverType);
    }

    public static Map<String, Object> requestAdapay(String uri, Map<String, Object> params, String merchantKey) throws BaseAdaPayException {
        return requestAdapay(uri, params, (File) null, (String)null, merchantKey);
    }


    public static Map<String, Object> requestAdapay(String uri, Map<String, Object> params, String merchantKey, ServerTypeEnum serverType) throws BaseAdaPayException {
        return requestAdapay(uri, params, (File) null, (String)null, merchantKey, serverType);
    }


    public static Map<String, Object> requestAdapay(String uri, Map<String, Object> params, File file, String fileParam, String merchantKey) throws BaseAdaPayException {
        return requestAdapay(uri, params, file, fileParam, merchantKey, null);

    }

    public static Map<String, Object> requestAdapay(String uri, Map<String, Object> params, File file, String fileParam, String merchantKey, ServerTypeEnum serverType) throws BaseAdaPayException {

        MerConfig config = Adapay.getConfig(merchantKey);

        if (null == config) {

            throw new BaseAdaPayException(FailureCode.CONFIG_EXCEPTION.getFailureCode(), "未找到对应" + merchantKey + "商户配置");
        }

        String apikey = config.getApiKey();
        if (!Adapay.prodMode) {
            apikey = config.getApiMockKey();
        }

        return requestAdapayCore(RequestMethod.POST, uri, params, file, fileParam, config.getRSAPrivateKey(), apikey, serverType);

    }

    public static Map<String, Object> getRequestAdapay(String uri, Map<String, Object> params) throws BaseAdaPayException {

        return getRequestAdapay(uri, params, Adapay.defaultMerchantKey);
    }

    public static Map<String, Object> getRequestAdapay(String uri, Map<String, Object> params, ServerTypeEnum serverType) throws BaseAdaPayException {

        return getRequestAdapay(uri, params, Adapay.defaultMerchantKey,serverType);
    }

    public static Map<String, Object> getRequestAdapay(String uri, Map<String, Object> params, String merchantKey) throws BaseAdaPayException {

        MerConfig config = Adapay.getConfig(merchantKey);
        if (null == config) {

            throw new BaseAdaPayException(FailureCode.CONFIG_EXCEPTION.getFailureCode(), "未找到对应" + merchantKey + "的商户配置");
        }

        String apikey = config.getApiKey();
        if (!Adapay.prodMode) {
            apikey = config.getApiMockKey();
        }

        return requestAdapayCore(RequestMethod.GET, uri, params, config.getRSAPrivateKey(), apikey);
    }

    public static Map<String, Object> getRequestAdapay(String uri, Map<String, Object> params, String merchantKey, ServerTypeEnum serverType) throws BaseAdaPayException {

        MerConfig config = Adapay.getConfig(merchantKey);
        if (null == config) {

            throw new BaseAdaPayException(FailureCode.CONFIG_EXCEPTION.getFailureCode(), "未找到对应" + merchantKey + "的商户配置");
        }

        String apikey = config.getApiKey();
        if (!Adapay.prodMode) {
            apikey = config.getApiMockKey();
        }

        return requestAdapayCore(RequestMethod.GET, uri, params, config.getRSAPrivateKey(), apikey,serverType);
    }
    //

}