package com.huifu.adapay.model;

import java.io.File;
import java.util.Map;

import com.huifu.adapay.APIUrlEnum;
import com.huifu.adapay.Adapay;
import com.huifu.adapay.core.exception.BaseAdaPayException;
import com.huifu.adapay.model.AdapayRequest;


/**
 * @author yingyong.wang
 */
public class CorpMember {


    /**
     * 创建企业用户对象
     *
     * @param params 创建企业用户对象的请求参数，参见 AdaPay api
     * @param params 创建企业用户对象的附件文件参数，参见 AdaPay api
     * @param merchantKey merchantKey
     * @return 创建用户对象
     * @throws BaseAdaPayException 异常
     */
    public static Map<String, Object> create(Map<String, Object> params, File file, String merchantKey) throws BaseAdaPayException {

        if (!file.exists()) {
            throw new BaseAdaPayException("invalidate params", "文件不能为空");
        }

        return AdapayRequest.requestAdapay( APIUrlEnum.CORP_MEMBER_V1.getCode(), params, file,"attach_file", merchantKey);
    }

    /**
     * 查询企业用户对象
     *
     * @param params 查询企业用户对象的请求参数，参见 AdaPay api
     * @return 查询的企业用户对象
     * @throws BaseAdaPayException 异常
     */
    public static Map<String, Object> query(Map<String, Object> params, String merchantKey) throws BaseAdaPayException {

        String memberId = (String) params.get("member_id");
        String uri = new StringBuilder(APIUrlEnum.QUERY_CORP_MEMBER_V1.getCode()).append(memberId).toString();
        
        return AdapayRequest.getRequestAdapay( uri, params, merchantKey);
    }

    /**
     * 创建企业用户对象
     *
     * @param params 创建企业用户对象的请求参数，参见 AdaPay api
     * @param params 创建企业用户对象的附件文件参数，参见 AdaPay api
     * @param merchantKey merchantKey
     * @return 创建用户对象
     * @throws BaseAdaPayException 异常
     */
    public static Map<String, Object> create(Map<String, Object> params, File file) throws BaseAdaPayException {

        if (!file.exists()) {
            throw new BaseAdaPayException("invalidate params", "文件不能为空");
        }
        return AdapayRequest.requestAdapay( APIUrlEnum.CORP_MEMBER_V1.getCode(), params, file, "attach_file", Adapay.defaultMerchantKey);
    }

    /**
     * 查询企业用户对象
     *
     * @param params 查询企业用户对象的请求参数，参见 AdaPay api
     * @return 查询的企业用户对象
     * @throws BaseAdaPayException 异常
     */
    public static Map<String, Object> query(Map<String, Object> params) throws BaseAdaPayException {

        String memberId = (String) params.get("member_id");
        String uri = new StringBuilder(APIUrlEnum.QUERY_CORP_MEMBER_V1.getCode()).append(memberId).toString();
        
        return AdapayRequest.getRequestAdapay( uri, params);
    }


}
