package com.huifu.adapay.model;

import com.alibaba.fastjson.annotation.JSONField;
import com.huifu.adapay.APIUrlEnum;
import com.huifu.adapay.core.exception.BaseAdaPayException;

import java.util.Map;

/**
 * @author yi.tang
 * @apiNote 取现
 * @since 2020/1/16 10:40
 */
public class Drawcash {

    /**
     * 返参，必填，由AdaPay生成的取现对象 ID
     */
    @JSONField(name = "id")
    private String id;

    /**
     * 商户的应用id
     */
    @JSONField(name = "app_id")
    private String appId;

    /**
     * 必填，订单号
     */
    @JSONField(name = "order_no")
    private String orderNo;

    /**
     * 返参，必填，取现创建时的时间戳
     */
    @JSONField(name = "created_time")
    private String createdTime;

    /**
     * 是否测试模式
     */
    @JSONField(name = "prod_mode")
    private String prodMode;

    /**
     * T1,目前只支持 T1 取现
     */
    @JSONField(name = "cash_type")
    private String cashType;

    /**
     * 取现金额（必须大于0），人民币为元，保留两位小数点，如0.10、100.05等
     */
    @JSONField(name = "cash_amt")
    private String cashAmt;

    /**
     * 用户对象 的 id；若是商户本身时，传入 0
     */
    @JSONField(name = "member_id")
    private String memberId;

    /**
     * 异步通知地址，默认使用轻量、简单 MQTT 通知（强烈建议使用），url为http/https 路径，服务器 POST 回调，请不要地址上带有参数。
     */
    @JSONField(name = "notify_url")
    private String notifyUrl;

    /**
     * 实际取现金额
     */
    @JSONField(name = "real_amt")
    private String realAmt;

    /**
     * 取现手续费金额
     */
    @JSONField(name = "fee_amt")
    private String feeAmt;


    /**
     * 创建取现对象
     *
     * @param params      创建取现对象的请求参数，参见 AdaPay api
     * @param merchantKey merchantKey
     * @return 创建取现对象
     * @throws BaseAdaPayException 异常
     */
    public static Map<String, Object> create(Map<String, Object> params, String merchantKey) throws BaseAdaPayException {

        String uri = new StringBuilder(APIUrlEnum.CASH_V1.getCode()).toString();
        return AdapayRequest.requestAdapay(uri, params, merchantKey);
    }

    /**
     * 创建取现对象
     *
     * @param params 创建取现对象的请求参数，参见 AdaPay api
     * @return 创建取现对象
     * @throws BaseAdaPayException 异常
     */
    public static Map<String, Object> create(Map<String, Object> params) throws BaseAdaPayException {

        String uri = new StringBuilder(APIUrlEnum.CASH_V1.getCode()).toString();
        return AdapayRequest.requestAdapay(uri, params);
    }

    /**
     * 多商户模式下的查询取现对象
     *
     * @param params      查询取现对象的请求参数，参见 AdaPay api
     * @param merchantKey merchantKey
     * @return 查询取现对象
     * @throws BaseAdaPayException 异常
     */
    public static Map<String, Object> query(Map<String, Object> params, String merchantKey) throws BaseAdaPayException {
        String uri = new StringBuilder(APIUrlEnum.QUERY_CASH_V1.getCode()).toString();
        return AdapayRequest.getRequestAdapay(uri, params, merchantKey);
    }

    /**
     * 单商户模式下的查询取现对象
     *
     * @param params 查询取现对象的请求参数，参见 AdaPay api
     * @return 查询取现对象
     * @throws BaseAdaPayException 异常
     */
    public static Map<String, Object> query(Map<String, Object> params) throws BaseAdaPayException {
        String uri = new StringBuilder(APIUrlEnum.QUERY_CASH_V1.getCode()).toString();
        return AdapayRequest.getRequestAdapay(uri, params);
    }

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder("Drawcash{");
        sb.append("id='").append(id).append('\'');
        sb.append(", appId='").append(appId).append('\'');
        sb.append(", orderNo='").append(orderNo).append('\'');
        sb.append(", createdTime='").append(createdTime).append('\'');
        sb.append(", prodMode='").append(prodMode).append('\'');
        sb.append(", cashType='").append(cashType).append('\'');
        sb.append(", cashAmt='").append(cashAmt).append('\'');
        sb.append(", memberId='").append(memberId).append('\'');
        sb.append(", notify_url='").append(notifyUrl).append('\'');
        sb.append(", realAmt='").append(realAmt).append('\'');
        sb.append(", feeAmt='").append(feeAmt).append('\'');
        sb.append('}');
        return sb.toString();
    }
}
