package com.huifu.adapay.model;

import com.huifu.adapay.APIUrlEnum;
import com.huifu.adapay.core.exception.BaseAdaPayException;
import com.huifu.adapay.core.util.ServerTypeEnum;

import java.util.Map;


/**
 * @author jane.zhao
 * @date  2020-12-03
 */
public class FastPay {

    /**
     * 创建一个快捷绑卡申请
     * @param params      创建快捷绑卡申请的请求参数，参见 AdaPay api
     * @param merchantKey merchantKey
     * @return 创建的快捷绑卡申请对象
     * @throws BaseAdaPayException 异常
     */
    public static Map<String, Object> cardApply(Map<String, Object> params, String merchantKey) throws BaseAdaPayException {
        return AdapayRequest.requestAdapay(APIUrlEnum.FAST_CARD_APPLY_V1.getCode(), params, merchantKey, ServerTypeEnum.PAGE);
    }

    /**
     * 创建一个快捷绑卡申请
     * @param params      创建快捷绑卡申请的请求参数，参见 AdaPay api
     * @return 创建的快捷绑卡申请对象
     * @throws BaseAdaPayException 异常
     */
    public static Map<String, Object> cardApply(Map<String, Object> params) throws BaseAdaPayException {
        return AdapayRequest.requestAdapay(APIUrlEnum.FAST_CARD_APPLY_V1.getCode(), params, ServerTypeEnum.PAGE);
    }


    /**
     * 创建一个创建快捷绑卡确认
     *      * @param merchantKey merchantKey
     * @param params      创建创建快捷绑卡确认的请求参数，参见 AdaPay api
     * @return 创建的创建快捷绑卡确认对象
     * @throws BaseAdaPayException 异常
     */
    public static Map<String, Object> cardConfirm(Map<String, Object> params, String merchantKey) throws BaseAdaPayException {
        return AdapayRequest.requestAdapay(APIUrlEnum.FAST_CARD_CONFIRM_V1.getCode(), params, merchantKey, ServerTypeEnum.PAGE);
    }

    /**
     * 创建一个创建快捷绑卡确认
     *
     * @param params      创建创建快捷绑卡确认的请求参数，参见 AdaPay api
     * @return 创建的创建快捷绑卡确认对象
     * @throws BaseAdaPayException 异常
     */
    public static Map<String, Object> cardConfirm(Map<String, Object> params) throws BaseAdaPayException {
        return AdapayRequest.requestAdapay(APIUrlEnum.FAST_CARD_CONFIRM_V1.getCode(), params, ServerTypeEnum.PAGE);
    }

    /**
     * 查询快捷卡对象列表
     *
     * @param params 要查询的支付params
     * @param merchantKey merchantKey
     * @return 查询快捷卡对象列表
     * @throws BaseAdaPayException 异常
     */
    public static Map<String, Object> cardList(Map<String, Object> params, String merchantKey) throws BaseAdaPayException {
        return AdapayRequest.getRequestAdapay(APIUrlEnum.FAST_CARD_LIST_V1.getCode(), params, merchantKey, ServerTypeEnum.PAGE);

    }

    /**
     * 查询快捷卡对象列表
     *
     * @param params 要查询的支付params
     * @return 查询快捷卡对象列表
     * @throws BaseAdaPayException 异常
     */
    public static Map<String, Object> cardList(Map<String, Object> params) throws BaseAdaPayException {
        return AdapayRequest.getRequestAdapay(APIUrlEnum.FAST_CARD_LIST_V1.getCode(), params, ServerTypeEnum.PAGE);
    }


    /**
     * 创建快捷支付确认
     * @param merchantKey merchantKey
     * @param params      创建快捷支付确认的请求参数，参见 AdaPay api
     * @return 创建快捷支付确认
     * @throws BaseAdaPayException 异常
     */
    public static Map<String, Object> confirm(Map<String, Object> params, String merchantKey) throws BaseAdaPayException {
        return AdapayRequest.requestAdapay(APIUrlEnum.FAST_PAY_CONFIRM_V1.getCode(), params, merchantKey);
    }

    /**
     * 创建快捷支付确认
     * @param params      创建快捷支付确认的请求参数，参见 AdaPay api
     * @return 创建快捷支付确认
     * @throws BaseAdaPayException 异常
     */
    public static Map<String, Object> confirm(Map<String, Object> params) throws BaseAdaPayException {
        return AdapayRequest.requestAdapay(APIUrlEnum.FAST_PAY_CONFIRM_V1.getCode(), params);
    }

    /**
     * 创建快捷支付短信重发
     * @param merchantKey merchantKey
     * @param params      创建创建快捷绑卡确认的请求参数，参见 AdaPay api
     * @return 创建的创建快捷绑卡确认对象
     * @throws BaseAdaPayException 异常
     */
    public static Map<String, Object> smsCode(Map<String, Object> params, String merchantKey) throws BaseAdaPayException {
        return AdapayRequest.requestAdapay(APIUrlEnum.FAST_PAY_SMS_CODE_V1.getCode(), params, merchantKey);
    }

    /**
     * 创建快捷支付短信重发
     * @param params      创建创建快捷绑卡确认的请求参数，参见 AdaPay api
     * @return 创建的创建快捷绑卡确认对象
     * @throws BaseAdaPayException 异常
     */
    public static Map<String, Object> smsCode(Map<String, Object> params) throws BaseAdaPayException {
        return AdapayRequest.requestAdapay(APIUrlEnum.FAST_PAY_SMS_CODE_V1.getCode(), params);
    }


}
