package com.huifu.adapay.model;

import java.util.Map;

import com.alibaba.fastjson.annotation.JSONField;
import com.huifu.adapay.APIUrlEnum;
import com.huifu.adapay.core.exception.BaseAdaPayException;
import com.huifu.adapay.model.AdapayRequest;

/**
 * @author jane.zhao
 */
public class Member  {

    /**
     * 可选，用户昵称
     */
    @JSONField(name = "nickname")
    private String nickname;
    /**
     * 可选，用户手机号
     */
    @JSONField(name = "tel_no")
    private String telNo;

    /**
     * 返参，必填，用户id 64 位以内，首字母必须是英文、数字或者下划线
     */
    @JSONField(name = "member_id")
    private String memberId;
    /**
     * 返参，用户邮箱
     */
    @JSONField(name = "email")
    private String email;

    /**
     * 返参，可选，MALE：男，FEMALE：女，为空时表示未填写
     */
    @JSONField(name = "gender")
    private String gender;

    /**
     * 返参，用户状态，N-正常，C-禁用
     */
    @JSONField(name = "disabled")
    private Boolean disabled;

    /**
     * 返参，是否已实名认证
     */
    @JSONField(name = "identified")
    private Boolean identified;

    /**
     * 返参，用户地址
     */
    @JSONField(name = "location")
    private String location;

    /**
     * 返参，用户地址
     */
    @JSONField(name = "prod_mode")
    private String prodMode;


    /**
     * 返参，必选，创建时间
     */
    @JSONField(name = "created_time")
    private String createdTime;


    /**
     * 创建用户对象
     *
     * @param params 创建用户对象的请求参数，参见 AdaPay api
     * @param merchantKey merchantKey
     * @return 创建用户对象
     * @throws BaseAdaPayException 异常
     */
    public static Map<String, Object> create(Map<String, Object> params, String merchantKey) throws BaseAdaPayException {
        String uri = new StringBuilder(APIUrlEnum.MEMBER_V1.getCode()).toString();
        return AdapayRequest.requestAdapay( uri, params, merchantKey);
    }

    /**
     * 查询用户对象
     *
     * @param params 查询用户对象的请求参数，参见 AdaPay api
     * @param merchantKey merchantKey
     * @return 查询的用户对象
     * @throws BaseAdaPayException 异常
     */
    public static Map<String, Object> query(Map<String, Object> params, String merchantKey) throws BaseAdaPayException {
        String memberId = (String) params.get("member_id");
        String uri = new StringBuilder(APIUrlEnum.QUERY_MEMBER_V1.getCode()).append(memberId).toString();
        return AdapayRequest.getRequestAdapay( uri, params, merchantKey);
    }

    /**
     * 查询用户列表
     *
     * @param params 查询用户列表的请求参数，参见 AdaPay api
     * @param merchantKey merchantKey
     * @return 查询的用户列表
     * @throws BaseAdaPayException 异常
     */
    public static Map<String, Object> queryList(Map<String, Object> params, String merchantKey) throws BaseAdaPayException {

        String uri = new StringBuilder(APIUrlEnum.QUERY_MEMBER_LIST_V1.getCode()).toString();
        return AdapayRequest.getRequestAdapay( uri, params, merchantKey);
    }

    /**
     * 更新用户对象
     *
     * @param params 更新用户对象的请求参数，参见 AdaPay api
     * @param merchantKey merchantKey
     * @return 更新后的用户对象
     * @throws BaseAdaPayException 异常
     */
    public static Map<String, Object> update(Map<String, Object> params, String merchantKey) throws BaseAdaPayException {

        String uri = new StringBuilder(APIUrlEnum.UPDATE_MEMBER_V1.getCode()).toString();
        return AdapayRequest.requestAdapay( uri, params, merchantKey);
    }


    /**
     * 创建用户对象
     *
     * @param params 创建用户对象的请求参数，参见 AdaPay api
     * @return 创建用户对象
     * @throws BaseAdaPayException 异常
     */
    public static Map<String, Object> create(Map<String, Object> params) throws BaseAdaPayException {
        String uri = new StringBuilder(APIUrlEnum.MEMBER_V1.getCode()).toString();
        return AdapayRequest.requestAdapay( uri, params);
    }

    /**
     * 查询用户对象
     *
     * @param params 查询用户对象的请求参数，参见 AdaPay api
     * @return 查询的用户对象
     * @throws BaseAdaPayException 异常
     */
    public static Map<String, Object> query(Map<String, Object> params) throws BaseAdaPayException {
        String memberId = (String) params.get("member_id");
        String uri = new StringBuilder(APIUrlEnum.QUERY_MEMBER_V1.getCode()).append(memberId).toString();
        return AdapayRequest.getRequestAdapay( uri, params);
    }

    /**
     * 查询用户列表
     *
     * @param params 查询用户列表的请求参数，参见 AdaPay api
     * @return 查询的用户列表
     * @throws BaseAdaPayException 异常
     */
    public static Map<String, Object> queryList(Map<String, Object> params) throws BaseAdaPayException {

        String uri = new StringBuilder(APIUrlEnum.QUERY_MEMBER_LIST_V1.getCode()).toString();
        return AdapayRequest.getRequestAdapay( uri, params);
    }

    /**
     * 更新用户对象
     *
     * @param params 更新用户对象的请求参数，参见 AdaPay api
     * @return 更新后的用户对象
     * @throws BaseAdaPayException 异常
     */
    public static Map<String, Object> update(Map<String, Object> params) throws BaseAdaPayException {

        String uri = new StringBuilder(APIUrlEnum.UPDATE_MEMBER_V1.getCode()).toString();
        return AdapayRequest.requestAdapay( uri, params);
    }


    public String getCreatedTime() {
        return createdTime;
    }

    public void setCreatedTime(String createdTime) {
        this.createdTime = createdTime;
    }

    public String getNickname() {
        return nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public String getTelNo() {
        return telNo;
    }

    public void setTelNo(String telNo) {
        this.telNo = telNo;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getMemberId() {
        return memberId;
    }

    public void setMemberId(String memberId) {
        this.memberId = memberId;
    }


    @Override
    public String toString() {
        return "Member{" +
                "nickname='" + nickname + '\'' +
                ", tel_no='" + telNo + '\'' +
                ", gender=" + gender +
                ", member_id='" + memberId + '\'' +
                ", disabled='" + disabled + '\'' +
                ", identified='" + identified + '\'' +
                ", location='" + location + '\'' +
                ", created_time='" + createdTime + '\'' +
                ", prod_mode='" + prodMode + '\'' +
                ", email=" + email +
                '}';
    }
}
