package com.huifu.adapay.model;

import com.alibaba.fastjson.annotation.JSONField;
import com.huifu.adapay.APIUrlEnum;
import com.huifu.adapay.core.exception.BaseAdaPayException;
import com.huifu.adapay.core.util.ServerTypeEnum;

import java.util.HashMap;
import java.util.Map;


/**
 * @author jane.zhao
 */
public class Payment {
    /**
     * 返参，必填，由AdaPay生成的支付对象 ID
     */
    @JSONField(name = "id")
    private String id;

    /**
     * 返参，必填，支付创建时的时间戳
     */
    @JSONField(name = "created_time")
    private String createdTime;
    /**
     * 必填，订单号
     */
    @JSONField(name = "order_no")
    private String orderNo;
    /**
     * 是否测试模式
     */
    @JSONField(name = "prod_mode")
    private String prodMode;
    /**
     * 商户发起支付的应用id，不同的前端应用将无法使用该 Payment 对象完成支付
     */
    @JSONField(name = "app_id")
    private String appId;
    /**
     * 必填，支付渠道
     */
    @JSONField(name = "pay_channel")
    private String payChannel;
    /**
     * 必填，订单总金额（必须大于0），人民币为元。
     */
    @JSONField(name = "pay_amt")
    private String payAmt;
    /**
     * 可临时用来查询支付订单状态的链接，此链接只具有比较短的有效期
     */
    @JSONField(name = "query_url")
    private String queryUrl;
    /**
     * 可选，订单附加说明
     */
    @JSONField(name = "reason")
    private String reason;


    /**
     * 返参，原支付id，关单时有
     */
    @JSONField(name = "pay_id")
    private String payId;

    private static final String CLOSE = "/close";

    /**
     * 创建一个支付交易
     *
     * @param params      创建支付的请求参数，参见 AdaPay api
     * @param merchantKey merchantKey
     * @return 创建的支付对象
     * @throws BaseAdaPayException 异常
     */
    public static Map<String, Object> create(Map<String, Object> params, String merchantKey) throws BaseAdaPayException {

        String currency = (String) params.get("currency");
        if (null == currency || currency.isEmpty()) {
            params.put("currency", "cny");
        }

        return AdapayRequest.requestAdapay(APIUrlEnum.PAYMENT_V1.getCode(), params, merchantKey);
    }

    /**
     * 创建一个支付交易
     *
     * @param params 创建支付的请求参数，参见 AdaPay api
     * @return 创建的支付对象
     * @throws BaseAdaPayException 异常
     */
    public static Map<String, Object> create(Map<String, Object> params) throws BaseAdaPayException {
        String currency = (String) params.get("currency");
        if (null == currency || currency.isEmpty()) {
            params.put("currency", "cny");
        }

        return AdapayRequest.requestAdapay(APIUrlEnum.PAYMENT_V1.getCode(), params);
    }


    /**
     * 关闭一个支付
     *
     * @param params      关单请求参数
     * @param merchantKey merchantKey
     * @return 关闭的支付对象
     * @throws BaseAdaPayException 异常
     */
    public static Map<String, Object> close(Map<String, Object> params, String merchantKey) throws BaseAdaPayException {
        String payment_id = (String) params.get("payment_id");

        String uri = new StringBuilder(APIUrlEnum.CLOSE_PAYMENT_V1.getCode()).append(payment_id).append(CLOSE).toString();
        return AdapayRequest.requestAdapay(uri, params, merchantKey);
    }

    /**
     * 关闭一个支付
     *
     * @param params 关单请求参数
     * @return 关闭的支付对象
     * @throws BaseAdaPayException 异常
     */
    public static Map<String, Object> close(Map<String, Object> params) throws BaseAdaPayException {
        String payment_id = (String) params.get("payment_id");
        String uri = new StringBuilder(APIUrlEnum.CLOSE_PAYMENT_V1.getCode()).append(payment_id).append(CLOSE).toString();
        return AdapayRequest.requestAdapay(uri, params);
    }

    /**
     * 查询已有的支付信息
     *
     * @param id          要查询的支付id
     * @param merchantKey merchantKey
     * @return 查询的支付对象
     * @throws BaseAdaPayException 异常
     */
    public static Map<String, Object> query(String id, String merchantKey) throws BaseAdaPayException {
        return AdapayRequest.getRequestAdapay(APIUrlEnum.QUERY_PAYMENT_V1.getCode() + id, new HashMap<String, Object>(1), merchantKey);
    }

    /**
     * 查询已有的支付信息
     *
     * @param id 要查询的支付id
     * @return 查询的支付对象
     * @throws BaseAdaPayException 异常
     */
    public static Map<String, Object> query(String id) throws BaseAdaPayException {
        return AdapayRequest.getRequestAdapay(APIUrlEnum.QUERY_PAYMENT_V1.getCode() + id, new HashMap<String, Object>(1));
    }


    /**
     * 创建一个支付交易
     *
     * @param params      创建支付的请求参数，参见 AdaPay api
     * @param merchantKey merchantKey
     * @return 创建页面的支付对象
     * @throws BaseAdaPayException 异常
     */
    @Deprecated
    public static Map<String, Object> createPage(Map<String, Object> params, String merchantKey) throws BaseAdaPayException {

        String currency = (String) params.get("currency");
        if (null == currency || currency.isEmpty()) {
            params.put("currency", "cny");
        }

        return AdapayRequest.requestAdapay(APIUrlEnum.PAYMENT_PAGE_V1.getCode(), params, merchantKey, ServerTypeEnum.PAGE);
    }

    /**
     * 创建一个页面支付交易
     *
     * @param params 创建支付的请求参数，参见 AdaPay api
     * @return 创建的支付对象
     * @throws BaseAdaPayException 异常
     */
    @Deprecated
    public static Map<String, Object> createPage(Map<String, Object> params) throws BaseAdaPayException {
        String currency = (String) params.get("currency");
        if (null == currency || currency.isEmpty()) {
            params.put("currency", "cny");
        }

        return AdapayRequest.requestAdapay(APIUrlEnum.PAYMENT_PAGE_V1.getCode(), params, ServerTypeEnum.PAGE);
    }

    /**
     * 查询支付对象列表
     *
     * @param params      要查询的支付对象参数
     * @param merchantKey merchantKey
     * @return 查询的支付对象
     * @throws BaseAdaPayException 异常
     */
    public static Map<String, Object> queryList(Map<String, Object> params, String merchantKey) throws BaseAdaPayException {

        return AdapayRequest.getRequestAdapay(APIUrlEnum.QUERY_PAYMENT_LIST_V1.getCode(), params, merchantKey);
    }

    /**
     * 查询支付对象列表
     *
     * @param params      要查询的支付对象参数
     * @return 查询的支付对象
     * @throws BaseAdaPayException 异常
     */
    public static Map<String, Object> queryList(Map<String, Object> params) throws BaseAdaPayException {

        return AdapayRequest.getRequestAdapay(APIUrlEnum.QUERY_PAYMENT_LIST_V1.getCode(), params);
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public String getPayChannel() {
        return payChannel;
    }

    public void setPayChannel(String payChannel) {
        this.payChannel = payChannel;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getAppId() {
        return appId;
    }

    public String getPayAmt() {
        return payAmt;
    }

    public String getProdMode() {
        return prodMode;
    }

    public void setProdMode(String prodMode) {
        this.prodMode = prodMode;
    }

    public void setPayAmt(String payAmt) {
        this.payAmt = payAmt;
    }


    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getQueryUrl() {
        return queryUrl;
    }

    public void setQueryUrl(String queryUrl) {
        this.queryUrl = queryUrl;
    }

    public String getReason() {
        return reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public String getCreatedTime() {
        return createdTime;
    }

    public void setCreatedTime(String createdTime) {
        this.createdTime = createdTime;
    }

    public String getPayId() {
        return payId;
    }

    public void setPayId(String payId) {
        this.payId = payId;
    }

    @Override
    public String toString() {
        return "Payment{" +
                "id='" + id + '\'' +
                ", createdTime='" + createdTime + '\'' +
                ", orderNo='" + orderNo + '\'' +
                ", prodMode=" + prodMode +
                ", appId='" + appId + '\'' +
                ", payChannel='" + payChannel + '\'' +
                ", payAmt='" + payAmt + '\'' +
                ", queryUrl='" + queryUrl + '\'' +
                ", reason='" + reason + '\'' +
                ", expend=" +
                ", payId='" + payId + '\'' +
                '}';
    }


    /**
     * 创建撤销对象
     *
     * @param params      创建支付撤销对象参数
     * @param merchantKey merchantKey
     * @return 查询的支付对象
     * @throws BaseAdaPayException 异常
     */
    @Deprecated
    public static Map<String, Object> createReverse(Map<String, Object> params, String merchantKey) throws BaseAdaPayException {
        return AdapayRequest.requestAdapay(APIUrlEnum.REVERSE_PAYMENT_V1.getCode(), params, merchantKey);
    }


    /**
     * 创建撤销对象
     *
     * @param params 创建支付撤销对象参数
     * @return 查询的支付对象
     * @throws BaseAdaPayException 异常
     */
    @Deprecated
    public static Map<String, Object> createReverse(Map<String, Object> params) throws BaseAdaPayException {
        return AdapayRequest.requestAdapay(APIUrlEnum.REVERSE_PAYMENT_V1.getCode(), params);
    }


    /**
     * 查询已有的支付撤销对象列表
     *
     * @param params      要查询的支付撤销对象参数
     * @param merchantKey merchantKey
     * @return 查询的支付撤销对象
     * @throws BaseAdaPayException 异常
     */
    @Deprecated
    public static Map<String, Object> queryReverseList(Map<String, Object> params, String merchantKey) throws BaseAdaPayException {

        return AdapayRequest.getRequestAdapay(APIUrlEnum.REVERSE_PAYMENT_LIST_V1.getCode(), params, merchantKey);
    }

    /**
     * 查询已有的支付撤销对象列表
     *
     * @param params 要查询的支付撤销对象参数
     * @return 查询的支付撤销对象
     * @throws BaseAdaPayException 异常
     */
    @Deprecated
    public static Map<String, Object> queryReverseList(Map<String, Object> params) throws BaseAdaPayException {

        return AdapayRequest.getRequestAdapay(APIUrlEnum.REVERSE_PAYMENT_LIST_V1.getCode(), params);
    }

    /**
     * 查询已有的支付撤销对象
     *
     * @param params      要查询的支付撤销对象参数
     * @param merchantKey merchantKey
     * @return 查询的支付撤销对象
     * @throws BaseAdaPayException 异常
     */
    @Deprecated
    public static Map<String, Object> queryReverse(Map<String, Object> params, String merchantKey) throws BaseAdaPayException {
        String reverseId = (String) params.get("reverse_id");
        return AdapayRequest.getRequestAdapay(APIUrlEnum.QUERY_REVERSE_PAYMENT_V1.getCode() + reverseId, params, merchantKey);
    }

    /**
     * 查询已有的支付撤销对象
     *
     * @param params 要查询的支付撤销对象参数
     * @return 查询的支付撤销对象
     * @throws BaseAdaPayException 异常
     */
    @Deprecated
    public static Map<String, Object> queryReverse(Map<String, Object> params) throws BaseAdaPayException {
        String reverseId = (String) params.get("reverse_id");
        return AdapayRequest.getRequestAdapay(APIUrlEnum.QUERY_REVERSE_PAYMENT_V1.getCode() + reverseId, params);
    }

    /**
     * 创建支付确认对象
     *
     * @param params      创建支付确认对象参数
     * @param merchantKey merchantKey
     * @return 查询的支付对象
     * @throws BaseAdaPayException 异常
     */
    @Deprecated
    public static Map<String, Object> createConfirm(Map<String, Object> params, String merchantKey) throws BaseAdaPayException {
        return AdapayRequest.requestAdapay(APIUrlEnum.CONFIRM_PAYMENT_V1.getCode(), params, merchantKey);
    }

    /**
     * 创建支付确认对象
     *
     * @param params 创建支付确认对象参数
     * @return 查询的支付对象
     * @throws BaseAdaPayException 异常
     */
    @Deprecated
    public static Map<String, Object> createConfirm(Map<String, Object> params) throws BaseAdaPayException {
        return AdapayRequest.requestAdapay(APIUrlEnum.CONFIRM_PAYMENT_V1.getCode(), params);
    }

    /**
     * 查询已有的支付确认对象列表
     *
     * @param params      要查询的支付撤销对象参数
     * @param merchantKey merchantKey
     * @return 查询的支付撤销对象
     * @throws BaseAdaPayException 异常
     */
    @Deprecated
    public static Map<String, Object> queryConfirmList(Map<String, Object> params, String merchantKey) throws BaseAdaPayException {

        return AdapayRequest.getRequestAdapay(APIUrlEnum.CONFIRM_PAYMENT_LIST_V1.getCode(), params, merchantKey);
    }

    /**
     * 查询已有的支付确认对象列表
     *
     * @param params 要查询的支付撤销对象参数
     * @return 查询的支付撤销对象
     * @throws BaseAdaPayException 异常
     */
    @Deprecated
    public static Map<String, Object> queryConfirmList(Map<String, Object> params) throws BaseAdaPayException {

        return AdapayRequest.getRequestAdapay(APIUrlEnum.CONFIRM_PAYMENT_LIST_V1.getCode(), params);
    }

    /**
     * 查询已有的支付确认对象
     *
     * @param params      要查询的支付确认对象参数
     * @param merchantKey merchantKey
     * @return 查询的支付撤销对象
     * @throws BaseAdaPayException 异常
     */
    @Deprecated
    public static Map<String, Object> queryConfirm(Map<String, Object> params, String merchantKey) throws BaseAdaPayException {
        String confirmId = (String) params.get("payment_confirm_id");
        return AdapayRequest.getRequestAdapay(APIUrlEnum.QUERY_CONFIRM_PAYMENT_V1.getCode() + confirmId, params, merchantKey);
    }

    /**
     * 查询已有的支付确认对象
     *
     * @param params 要查询的支付确认对象参数
     * @return 查询的支付撤销对象
     * @throws BaseAdaPayException 异常
     */
    @Deprecated
    public static Map<String, Object> queryConfirm(Map<String, Object> params) throws BaseAdaPayException {
        String confirmId = (String) params.get("payment_confirm_id");
        return AdapayRequest.getRequestAdapay(APIUrlEnum.QUERY_CONFIRM_PAYMENT_V1.getCode() + confirmId, params);
    }

    /**
     * 创建一个支付交易
     *
     * @param params      创建支付的请求参数，参见 AdaPay api
     * @param merchantKey merchantKey
     * @return 创建页面的支付对象
     * @throws BaseAdaPayException 异常
     */
    @Deprecated
    public static Map<String, Object> createCheckOut(Map<String, Object> params, String merchantKey) throws BaseAdaPayException {

        String currency = (String) params.get("currency");
        if (null == currency || currency.isEmpty()) {
            params.put("currency", "cny");
        }

        return AdapayRequest.requestAdapay(APIUrlEnum.PAYMENT_CHECK_V1.getCode(), params, merchantKey, ServerTypeEnum.PAGE);
    }

    /**
     * 创建一个页面支付交易
     *
     * @param params 创建支付的请求参数，参见 AdaPay api
     * @return 创建的支付对象
     * @throws BaseAdaPayException 异常
     */
    @Deprecated
    public static Map<String, Object> createCheckOut(Map<String, Object> params) throws BaseAdaPayException {
        String currency = (String) params.get("currency");
        if (null == currency || currency.isEmpty()) {
            params.put("currency", "cny");
        }

        return AdapayRequest.requestAdapay(APIUrlEnum.PAYMENT_CHECK_V1.getCode(), params, ServerTypeEnum.PAGE);
    }

    /**
     * 查询收银台对象列表
     *
     * @param params      要查询的收银台对象参数
     * @param merchantKey merchantKey
     * @return 查询的收银台对象
     * @throws BaseAdaPayException 异常
     */
    @Deprecated
    public static Map<String, Object> queryCheckoutList(Map<String, Object> params, String merchantKey) throws BaseAdaPayException {
        return AdapayRequest.getRequestAdapay(APIUrlEnum.QUERY_CHECKOUT_LIST_V1.getCode(), params, merchantKey, ServerTypeEnum.PAGE);
    }

    /**
     * 查询收银台对象列表
     *
     * @param params      要查询的收银台对象参数
     * @return 查询的收银台对象
     * @throws BaseAdaPayException 异常
     */
    @Deprecated
    public static Map<String, Object> queryCheckoutList(Map<String, Object> params) throws BaseAdaPayException {
        return AdapayRequest.getRequestAdapay(APIUrlEnum.QUERY_CHECKOUT_LIST_V1.getCode(), params, ServerTypeEnum.PAGE);
    }
}
