package com.huifu.adapay.model;

import java.util.Map;

import com.alibaba.fastjson.annotation.JSONField;
import com.huifu.adapay.APIUrlEnum;
import com.huifu.adapay.core.exception.BaseAdaPayException;
import com.huifu.adapay.model.AdapayRequest;


/**
 * @author jane.zhao
 */
public class Refund {
    /**
     * 可选，退款描述
     */
    @JSONField(name="reason")
    private String reason;
    /**
     * 可选，扩展域
     */
    @JSONField(name="expend")
    private String expend;
    
    
    /**
     * 返参，必填，系统id
     */
    @JSONField(name="id")
    private String id;
    /**
     * 返参，必填，原交易id
     */
    @JSONField(name="payment_id")
    private String paymentId;

    /**
     * 返参，可选，退款金额
     */
    @JSONField(name="refund_amt")
    private String refundAmt;

    /**
     * 返参，可选，退款手续费，退款成功时有值
     */
    @JSONField(name="fee_amt")
    private String feeAmt;
    /**
     * 返参，可选，创建时间
     */
    @JSONField(name="created_time")
    private String createdTime;

    
    
    private static final String REFUNDS = "/refunds";

    /**
     * 创建一个退款交易
     * @param paymentId 要退款的原支付id
     * @param params 创建退款的请求参数，参见 AdaPay api
     * @param merchantKey merchantKey
     * @return 创建的退款对象
     * @throws BaseAdaPayException 异常
     */
    public static Map<String, Object> create(String paymentId, Map<String, Object> params, String merchantKey) throws BaseAdaPayException {
        String uri = new StringBuilder(APIUrlEnum.REFUND_V1.getCode()).append(paymentId).append(REFUNDS).toString();
        return AdapayRequest.requestAdapay( uri, params, merchantKey);
    }

    /**
     * 查询一个退款交易
     * @param params 查询退款的请求参数，参见 AdaPay api
     * @param merchantKey merchantKey
     * @return 查询的退款对象
     * @throws BaseAdaPayException 异常
     */
    public static Map<String, Object> query(Map<String, Object> params, String merchantKey) throws BaseAdaPayException {
        return AdapayRequest.getRequestAdapay( APIUrlEnum.QUERY_REFUND_V1.getCode(), params, merchantKey);
    }


    /**
     * 创建一个退款交易
     * @param paymentId 要退款的原支付id
     * @param params 创建退款的请求参数，参见 AdaPay api
     * @param merchantKey merchantKey
     * @return 创建的退款对象
     * @throws BaseAdaPayException 异常
     */
    public static Map<String, Object> create(String paymentId, Map<String, Object> params) throws BaseAdaPayException {
        String uri = new StringBuilder(APIUrlEnum.REFUND_V1.getCode()).append(paymentId).append(REFUNDS).toString();
        return AdapayRequest.requestAdapay( uri, params);
    }

    /**
     * 查询一个退款交易
     * @param params 查询退款的请求参数，参见 AdaPay api
     * @param merchantKey merchantKey
     * @return 查询的退款对象
     * @throws BaseAdaPayException 异常
     */
    public static Map<String, Object> query(Map<String, Object> params) throws BaseAdaPayException {
        return AdapayRequest.getRequestAdapay( APIUrlEnum.QUERY_REFUND_V1.getCode(), params);
    }

    
    

    public String getFeeAmt() {
        return feeAmt;
    }

    public void setFeeAmt(String feeAmt) {
        this.feeAmt = feeAmt;
    }

    public String getCreatedTime() {
        return createdTime;
    }

    public void setCreatedTime(String createdTime) {
        this.createdTime = createdTime;
    }

    public String getReason() {
        return reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public String getExpend() {
        return expend;
    }

    public void setExpend(String expend) {
        this.expend = expend;
    }

    public String getPaymentId() {
        return paymentId;
    }

    public void setPaymentId(String paymentId) {
        this.paymentId = paymentId;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getRefundAmt() {
        return refundAmt;
    }

    public void setRefundAmt(String refundAmt) {
        this.refundAmt = refundAmt;
    }

    @Override
    public String toString() {
        return "Refund{" +
                "reason='" + reason + '\'' +
                ", expend='" + expend + '\'' +
                ", deviceInfo="  +
                ", id='" + id + '\'' +
                ", paymentId='" + paymentId + '\'' +
                ", refundAmt='" + refundAmt + '\'' +
                ", feeAmt='" + feeAmt + '\'' +
                ", createdTime='" + createdTime + '\'' +
                ", refunds="  +
                '}';
    }
}
