package com.huifu.adapay.model;

import java.util.Map;

import com.huifu.adapay.APIUrlEnum;
import com.huifu.adapay.core.exception.BaseAdaPayException;
import com.huifu.adapay.model.AdapayRequest;



/**
 * @author yingyong.wang
 */
public class SettleAccount {

    /**
     * 创建结算账户对象
     *
     * @param params 创建结算账户对象的请求参数，参见 AdaPay api
     * @param merchantKey merchantKey
     * @return 创建结算账户对象
     * @throws BaseAdaPayException 异常
     */
    public static Map<String, Object> create(Map<String, Object> params, String merchantKey) throws BaseAdaPayException {

        String uri = new StringBuilder(APIUrlEnum.SETTLE_ACCOUNT_V1.getCode()).toString();
        return AdapayRequest.requestAdapay( uri, params, merchantKey);
    }

    /**
     * 查询结算账户对象
     *
     * @param params 查询结算账户对象的请求参数，参见 AdaPay api
     * @param merchantKey merchantKey
     * @return 查询的结算账户对象
     * @throws BaseAdaPayException 异常
     */
    public static Map<String, Object> query(Map<String, Object> params, String merchantKey) throws BaseAdaPayException {
        String settleAccountId = (String) params.get("settle_account_id");
        String uri = new StringBuilder(APIUrlEnum.QUERY_SETTLE_ACCOUNT_V1.getCode()).append(settleAccountId).toString();

        return AdapayRequest.getRequestAdapay( uri, params, merchantKey);
    }

    /**
     * 删除结算账户对象
     *
     * @param params 删除结算账户对象的请求参数，参见 AdaPay api
     * @param merchantKey merchantKey
     * @return 删除的结算账户对象
     * @throws BaseAdaPayException 异常
     */
    public static Map<String, Object> delete(Map<String, Object> params, String merchantKey) throws BaseAdaPayException {
        String uri = new StringBuilder(APIUrlEnum.DELETE_SETTLE_ACCOUNT_V1.getCode()).toString();

        return AdapayRequest.requestAdapay( uri, params, merchantKey);
    }

    /**
     * 修改结算账户对象
     *
     * @param params 修改结算账户对象的请求参数，参见 AdaPay api
     * @return 修改的结算账户对象
     * @throws BaseAdaPayException 异常
     */
    public static Map<String, Object> modify(Map<String, Object> params, String merchantKey) throws BaseAdaPayException {
        String uri = new StringBuilder(APIUrlEnum.MODIFY_SETTLE_ACCOUNT_V1.getCode()).toString();

        return AdapayRequest.requestAdapay( uri, params, merchantKey);
    }


    /**
     * 查询结算明细列表
     *
     * @param params 查询结算明细列表的请求参数，参见 AdaPay api
     * @param merchantKey merchantKey
     * @return 查询的结算账户对象
     * @throws BaseAdaPayException 异常
     */
    public static Map<String, Object> detail(Map<String, Object> params, String merchantKey) throws BaseAdaPayException {
        String uri = new StringBuilder(APIUrlEnum.QUERY_SETTLE_DETAILS_V1.getCode()).toString();
        return AdapayRequest.getRequestAdapay( uri, params, merchantKey);
    }


    /**
     * 创建结算账户对象
     *
     * @param params 创建结算账户对象的请求参数，参见 AdaPay api
     * @return 创建结算账户对象
     * @throws BaseAdaPayException 异常
     */
    public static Map<String, Object> create(Map<String, Object> params) throws BaseAdaPayException {

        String uri = new StringBuilder(APIUrlEnum.SETTLE_ACCOUNT_V1.getCode()).toString();
        return AdapayRequest.requestAdapay( uri, params);
    }

    /**
     * 查询结算账户对象
     *
     * @param params 查询结算账户对象的请求参数，参见 AdaPay api
     * @return 查询的结算账户对象
     * @throws BaseAdaPayException 异常
     */
    public static Map<String, Object> query(Map<String, Object> params) throws BaseAdaPayException {
        String settleAccountId = (String) params.get("settle_account_id");
        String uri = new StringBuilder(APIUrlEnum.QUERY_SETTLE_ACCOUNT_V1.getCode()).append(settleAccountId).toString();

        return AdapayRequest.getRequestAdapay( uri, params);
    }

    /**
     * 修改结算账户对象
     *
     * @param params 修改结算账户对象的请求参数，参见 AdaPay api
     * @return 修改的结算账户对象
     * @throws BaseAdaPayException 异常
     */
    public static Map<String, Object> update(Map<String, Object> params) throws BaseAdaPayException {
        String uri = new StringBuilder(APIUrlEnum.MODIFY_SETTLE_ACCOUNT_V1.getCode()).toString();

        return AdapayRequest.requestAdapay( uri, params);
    }

    /**
     * 删除结算账户对象
     *
     * @param params 删除结算账户对象的请求参数，参见 AdaPay api
     * @return 删除的结算账户对象
     * @throws BaseAdaPayException 异常
     */
    public static Map<String, Object> delete(Map<String, Object> params) throws BaseAdaPayException {
        String uri = new StringBuilder(APIUrlEnum.DELETE_SETTLE_ACCOUNT_V1.getCode()).toString();

        return AdapayRequest.requestAdapay( uri, params);
    }

    /**
     * 查询结算明细列表
     *
     * @param params 查询结算明细列表的请求参数，参见 AdaPay api
     * @return 查询的结算账户对象
     * @throws BaseAdaPayException 异常
     */
    public static Map<String, Object> detail(Map<String, Object> params) throws BaseAdaPayException {
        String uri = new StringBuilder(APIUrlEnum.QUERY_SETTLE_DETAILS_V1.getCode()).toString();
        return AdapayRequest.getRequestAdapay( uri, params);
    }

    /**
     * 查询账户余额
     *
     * @param params 查询查询账户余额请求参数，参见 AdaPay api
     * @return 查询账户余额
     * @throws BaseAdaPayException 异常
     */
    public static Map<String, Object> balance(Map<String, Object> params) throws BaseAdaPayException {
        String uri = new StringBuilder(APIUrlEnum.QUERY_BALANCE_V1.getCode()).toString();
        return AdapayRequest.getRequestAdapay( uri, params);
    }
    /**
     * 查询账户余额
     *
     * @param params 查询查询账户余额请求参数，参见 AdaPay api
     * @return 查询账户余额
     * @throws BaseAdaPayException 异常
     */
    public static Map<String, Object> balance(Map<String, Object> params, String merchantKey) throws BaseAdaPayException {
        String uri = new StringBuilder(APIUrlEnum.QUERY_BALANCE_V1.getCode()).toString();
        return AdapayRequest.getRequestAdapay( uri, params, merchantKey);
    }


    /**
     * 查询结算明细列表
     *
     * @param params 查询结算明细列表的请求参数，参见 AdaPay api
     * @param merchantKey merchantKey
     * @return 查询的结算账户对象
     * @throws BaseAdaPayException 异常
     */
    @Deprecated
    public static Map<String, Object> querySettleDetails(Map<String, Object> params, String merchantKey) throws BaseAdaPayException {
        String uri = new StringBuilder(APIUrlEnum.QUERY_SETTLE_DETAILS_V1.getCode()).toString();
        return AdapayRequest.getRequestAdapay( uri, params, merchantKey);
    }

    /**
     * 修改结算账户对象
     *
     * @param params 修改结算账户对象的请求参数，参见 AdaPay api
     * @return 修改的结算账户对象
     * @throws BaseAdaPayException 异常
     */
    @Deprecated
    public static Map<String, Object> modify(Map<String, Object> params) throws BaseAdaPayException {
        String uri = new StringBuilder(APIUrlEnum.MODIFY_SETTLE_ACCOUNT_V1.getCode()).toString();

        return AdapayRequest.requestAdapay( uri, params);
    }
    /**
     * 查询结算明细列表
     *
     * @param params 查询结算明细列表的请求参数，参见 AdaPay api
     * @return 查询的结算账户对象
     * @throws BaseAdaPayException 异常
     */
    @Deprecated
    public static Map<String, Object> querySettleDetails(Map<String, Object> params) throws BaseAdaPayException {
        String uri = new StringBuilder(APIUrlEnum.QUERY_SETTLE_DETAILS_V1.getCode()).toString();
        return AdapayRequest.getRequestAdapay( uri, params);
    }

    /**
     * 查询账户余额
     *
     * @param params 查询查询账户余额请求参数，参见 AdaPay api
     * @return 查询账户余额
     * @throws BaseAdaPayException 异常
     */
    @Deprecated
    public static Map<String, Object> queryBalance(Map<String, Object> params) throws BaseAdaPayException {
        String uri = new StringBuilder(APIUrlEnum.QUERY_BALANCE_V1.getCode()).toString();
        return AdapayRequest.getRequestAdapay( uri, params);
    }
    /**
     * 查询账户余额
     *
     * @param params 查询查询账户余额请求参数，参见 AdaPay api
     * @return 查询账户余额
     * @throws BaseAdaPayException 异常
     */
    @Deprecated
    public static Map<String, Object> queryBalance(Map<String, Object> params, String merchantKey) throws BaseAdaPayException {
        String uri = new StringBuilder(APIUrlEnum.QUERY_BALANCE_V1.getCode()).toString();
        return AdapayRequest.getRequestAdapay( uri, params, merchantKey);
    }

    /**
     * 取现
     *
     * @param params 取现请求参数，参见 AdaPay api
     * @return 取现结果
     * @throws BaseAdaPayException 异常
     */
    @Deprecated
    public static Map<String, Object> drawCash(Map<String, Object> params, String merchantKey) throws BaseAdaPayException {
        String uri = new StringBuilder(APIUrlEnum.CASH_V1.getCode()).toString();
        return AdapayRequest.requestAdapay( uri, params, merchantKey);
    }

    /**
     * 取现
     *
     * @param params 取现请求参数，参见 AdaPay api
     * @return 取现结果
     * @throws BaseAdaPayException 异常
     */
    @Deprecated
    public static Map<String, Object> drawCash(Map<String, Object> params) throws BaseAdaPayException {
        String uri = new StringBuilder(APIUrlEnum.CASH_V1.getCode()).toString();
        return AdapayRequest.requestAdapay( uri, params);
    }


    /**
     * 转账对象
     *
     * @param params 转账对象请求参数，参见 AdaPay api
     * @return 转账对象结果
     * @throws BaseAdaPayException 异常
     */
    public static Map<String, Object> transfer(Map<String, Object> params, String merchantKey) throws BaseAdaPayException {
        String uri = new StringBuilder(APIUrlEnum.SETTLE_ACCOUNTS_TRANSFER_V1.getCode()).toString();
        return AdapayRequest.requestAdapay( uri, params, merchantKey);
    }

    /**
     * 转账对象
     *
     * @param params 转账对象请求参数，参见 AdaPay api
     * @return 转账对象结果
     * @throws BaseAdaPayException 异常
     */
    public static Map<String, Object> transfer(Map<String, Object> params) throws BaseAdaPayException {
        String uri = new StringBuilder(APIUrlEnum.SETTLE_ACCOUNTS_TRANSFER_V1.getCode()).toString();
        return AdapayRequest.requestAdapay( uri, params);
    }

    /**
     * 转账对象列表
     *
     * @param params 转账对象列表请求参数，参见 AdaPay api
     * @return 转账对象列表结果
     * @throws BaseAdaPayException 异常
     */
    public static Map<String, Object> transferList(Map<String, Object> params, String merchantKey) throws BaseAdaPayException {
        String uri = new StringBuilder(APIUrlEnum.SETTLE_ACCOUNTS_TRANSFER_LIST_V1.getCode()).toString();
        return AdapayRequest.getRequestAdapay( uri, params, merchantKey);
    }

    /**
     * 转账对象列表
     *
     * @param params 转账对象列表请求参数，参见 AdaPay api
     * @return 转账对象列表结果
     * @throws BaseAdaPayException 异常
     */
    public static Map<String, Object> transferList(Map<String, Object> params) throws BaseAdaPayException {
        String uri = new StringBuilder(APIUrlEnum.SETTLE_ACCOUNTS_TRANSFER_LIST_V1.getCode()).toString();
        return AdapayRequest.getRequestAdapay( uri, params);
    }

    /**
     * 冻结对象
     *
     * @param params 冻结对象请求参数，参见 AdaPay api
     * @return 冻结对象结果
     * @throws BaseAdaPayException 异常
     */
    public static Map<String, Object> freeze(Map<String, Object> params, String merchantKey) throws BaseAdaPayException {
        String uri = new StringBuilder(APIUrlEnum.SETTLE_ACCOUNTS_FREEZE_V1.getCode()).toString();
        return AdapayRequest.requestAdapay( uri, params, merchantKey);
    }

    /**
     * 冻结对象
     *
     * @param params 冻结对象请求参数，参见 AdaPay api
     * @return 冻结对象结果
     * @throws BaseAdaPayException 异常
     */
    public static Map<String, Object> freeze(Map<String, Object> params) throws BaseAdaPayException {
        String uri = new StringBuilder(APIUrlEnum.SETTLE_ACCOUNTS_FREEZE_V1.getCode()).toString();
        return AdapayRequest.requestAdapay( uri, params);
    }

    /**
     * 冻结对象列表
     *
     * @param params 冻结对象列表请求参数，参见 AdaPay api
     * @return 冻结对象列表结果
     * @throws BaseAdaPayException 异常
     */
    public static Map<String, Object> freezeList(Map<String, Object> params, String merchantKey) throws BaseAdaPayException {
        String uri = new StringBuilder(APIUrlEnum.SETTLE_ACCOUNTS_FREEZE_LIST_V1.getCode()).toString();
        return AdapayRequest.getRequestAdapay( uri, params, merchantKey);
    }

    /**
     * 冻结对象列表
     *
     * @param params 冻结对象列表请求参数，参见 AdaPay api
     * @return 冻结对象列表结果
     * @throws BaseAdaPayException 异常
     */
    public static Map<String, Object> freezeList(Map<String, Object> params) throws BaseAdaPayException {
        String uri = new StringBuilder(APIUrlEnum.SETTLE_ACCOUNTS_FREEZE_LIST_V1.getCode()).toString();
        return AdapayRequest.getRequestAdapay( uri, params);
    }

    /**
     * 解冻对象
     *
     * @param params 解冻对象请求参数，参见 AdaPay api
     * @return 解冻对象结果
     * @throws BaseAdaPayException 异常
     */
    public static Map<String, Object> unfreeze(Map<String, Object> params, String merchantKey) throws BaseAdaPayException {
        String uri = new StringBuilder(APIUrlEnum.SETTLE_ACCOUNTS_UNFREEZE_V1.getCode()).toString();
        return AdapayRequest.requestAdapay( uri, params, merchantKey);
    }

    /**
     * 解冻对象
     *
     * @param params 解冻对象请求参数，参见 AdaPay api
     * @return 解冻对象结果
     * @throws BaseAdaPayException 异常
     */
    public static Map<String, Object> unfreeze(Map<String, Object> params) throws BaseAdaPayException {
        String uri = new StringBuilder(APIUrlEnum.SETTLE_ACCOUNTS_UNFREEZE_V1.getCode()).toString();
        return AdapayRequest.requestAdapay( uri, params);
    }

    /**
     * 解冻对象列表
     *
     * @param params 解冻对象列表请求参数，参见 AdaPay api
     * @return 解冻对象列表结果
     * @throws BaseAdaPayException 异常
     */
    public static Map<String, Object> unfreezeList(Map<String, Object> params, String merchantKey) throws BaseAdaPayException {
        String uri = new StringBuilder(APIUrlEnum.SETTLE_ACCOUNTS_UNFREEZE_LIST_V1.getCode()).toString();
        return AdapayRequest.getRequestAdapay( uri, params, merchantKey);
    }

    /**
     * 解冻对象列表
     *
     * @param params 解冻对象列表请求参数，参见 AdaPay api
     * @return 解冻对象列表结果
     * @throws BaseAdaPayException 异常
     */
    public static Map<String, Object> unfreezeList(Map<String, Object> params) throws BaseAdaPayException {
        String uri = new StringBuilder(APIUrlEnum.SETTLE_ACCOUNTS_UNFREEZE_LIST_V1.getCode()).toString();
        return AdapayRequest.getRequestAdapay( uri, params);
    }


    /**
     * 创建服务商分账对象
     *
     * @param params 创建服务商分账对象请求参数，参见 AdaPay api
     * @return 创建服务商分账对象结果
     * @throws BaseAdaPayException 异常
     */
    public static Map<String, Object> commission(Map<String, Object> params) throws BaseAdaPayException {
        String uri = new StringBuilder(APIUrlEnum.SETTLE_ACCOUNTS__COMMISSIONS_V1.getCode()).toString();
        return AdapayRequest.requestAdapay( uri, params);
    }

    /**
     * 创建服务商分账对象
     *
     * @param params 创建服务商分账对象请求参数，参见 AdaPay api
     * @return 创建服务商分账对象结果
     * @throws BaseAdaPayException 异常
     */
    public static Map<String, Object> commission(Map<String, Object> params, String merchantKey) throws BaseAdaPayException {
        String uri = new StringBuilder(APIUrlEnum.SETTLE_ACCOUNTS__COMMISSIONS_V1.getCode()).toString();
        return AdapayRequest.requestAdapay( uri, params, merchantKey);
    }
    /**
     * 查询服务商分账对象列表
     *
     * @param params 查询服务商分账对象列表请求参数，参见 AdaPay api
     * @return 查询服务商分账对象列表结果
     * @throws BaseAdaPayException 异常
     */
    public static Map<String, Object> commissionList(Map<String, Object> params) throws BaseAdaPayException {
        String uri = new StringBuilder(APIUrlEnum.SETTLE_ACCOUNTS_COMMISSIONS_LIST_V1.getCode()).toString();
        return AdapayRequest.getRequestAdapay( uri, params);
    }

    /**
     * 查询服务商分账对象列表
     *
     * @param params 查询服务商分账对象列表请求参数，参见 AdaPay api
     * @return 查询服务商分账对象列表结果
     * @throws BaseAdaPayException 异常
     */
    public static Map<String, Object> commissionList(Map<String, Object> params, String merchantKey) throws BaseAdaPayException {
        String uri = new StringBuilder(APIUrlEnum.SETTLE_ACCOUNTS_COMMISSIONS_LIST_V1.getCode()).toString();
        return AdapayRequest.getRequestAdapay( uri, params, merchantKey);
    }
}
