package com.huifu.adapay.model;

import com.huifu.adapay.APIUrlEnum;
import com.huifu.adapay.core.AdapayCore;
import com.huifu.adapay.core.exception.BaseAdaPayException;
import com.huifu.adapay.core.util.ServerTypeEnum;
import com.huifu.adapay.core.util.WebUtils;

import java.util.Map;

public class Wallet {
    /**
     * 用户登录
     * 详见https://docs.adapay.tech/api/wallet.html#login
     *
     * @param params
     * @param merchantKey
     * @return
     * @throws BaseAdaPayException
     */
    public static Map<String, Object> login(Map<String, Object> params, String merchantKey) throws BaseAdaPayException {
        String uri = new StringBuilder(APIUrlEnum.USER_LOGIN_V1.getCode()).toString();
        return AdapayRequest.requestAdapay(uri, params, merchantKey, ServerTypeEnum.PAGE);
    }

    /**
     * 用户登录
     * 详见https://docs.adapay.tech/api/wallet.html#login
     *
     * @param params
     * @return
     * @throws BaseAdaPayException
     */
    public static Map<String, Object> login(Map<String, Object> params) throws BaseAdaPayException {
        String uri = new StringBuilder(APIUrlEnum.USER_LOGIN_V1.getCode()).toString();
        return AdapayRequest.requestAdapay(uri, params, ServerTypeEnum.PAGE);
    }
}
