/*
 * Decompiled with CFR 0.152.
 */
package com.huifu.adapay.model;

import com.huifu.adapay.core.exception.BaseAdaPayException;
import com.huifu.adapay.core.exception.FailureCode;
import com.huifu.adapay.core.util.ServerTypeEnum;
import com.huifu.adapay.model.AdapayRequest;
import java.io.File;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class AdapayCommon {
    private static String packageRequestUrl(Map<String, Object> requestParams) throws BaseAdaPayException {
        String adapayFuncCode = (String)requestParams.get("adapay_func_code");
        if (StringUtils.isBlank((CharSequence)adapayFuncCode)) {
            throw new BaseAdaPayException(FailureCode.ADAPAY_FUNC_CODE_NOT_BLANK.getFailureCode());
        }
        String adapayApiVersion = (String)requestParams.getOrDefault("adapay_api_version", "v1");
        return "/" + adapayApiVersion + "/" + StringUtils.replace((String)adapayFuncCode, (String)".", (String)"/");
    }

    public static Map<String, Object> requestAdapay(Map<String, Object> params, String merchantKey) throws BaseAdaPayException {
        return AdapayRequest.requestAdapay(AdapayCommon.packageRequestUrl(params), params, merchantKey);
    }

    public static Map<String, Object> requestAdapay(Map<String, Object> params) throws BaseAdaPayException {
        return AdapayRequest.requestAdapay(AdapayCommon.packageRequestUrl(params), params);
    }

    public static Map<String, Object> requestAdapayFile(Map<String, Object> params, File file, String merchantKey) throws BaseAdaPayException {
        return AdapayRequest.requestAdapay(AdapayCommon.packageRequestUrl(params), params, file, "attach_file", merchantKey);
    }

    public static Map<String, Object> requestAdapayFile(Map<String, Object> params, File file) throws BaseAdaPayException {
        return AdapayRequest.requestAdapay(AdapayCommon.packageRequestUrl(params), params, file, "attach_file", "default");
    }

    public static Map<String, Object> queryAdapay(Map<String, Object> params, String merchantKey) throws BaseAdaPayException {
        return AdapayRequest.getRequestAdapay(AdapayCommon.packageRequestUrl(params), params, merchantKey);
    }

    public static Map<String, Object> queryAdapay(Map<String, Object> params) throws BaseAdaPayException {
        return AdapayRequest.getRequestAdapay(AdapayCommon.packageRequestUrl(params), params);
    }

    public static Map<String, Object> requestAdapayUits(Map<String, Object> params, String merchantKey) throws BaseAdaPayException {
        return AdapayRequest.requestAdapay(AdapayCommon.packageRequestUrl(params), params, merchantKey, ServerTypeEnum.PAGE);
    }

    public static Map<String, Object> requestAdapayUits(Map<String, Object> params) throws BaseAdaPayException {
        return AdapayRequest.requestAdapay(AdapayCommon.packageRequestUrl(params), params, ServerTypeEnum.PAGE);
    }

    public static Map<String, Object> queryAdapayUits(Map<String, Object> params, String merchantKey) throws BaseAdaPayException {
        return AdapayRequest.getRequestAdapay(AdapayCommon.packageRequestUrl(params), params, merchantKey, ServerTypeEnum.PAGE);
    }

    public static Map<String, Object> queryAdapayUits(Map<String, Object> params) throws BaseAdaPayException {
        return AdapayRequest.getRequestAdapay(AdapayCommon.packageRequestUrl(params), params, ServerTypeEnum.PAGE);
    }
}

