/*
 * Decompiled with CFR 0.152.
 */
package com.huifu.adapay.model;

import com.huifu.adapay.APIUrlEnum;
import com.huifu.adapay.core.exception.BaseAdaPayException;
import com.huifu.adapay.core.util.AdapaySign;
import com.huifu.adapay.core.util.StreamUtil;
import com.huifu.adapay.model.AdapayRequest;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.X509EncodedKeySpec;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;

public class AdapayTools {
    public static Map<String, Object> unionUserId(Map<String, Object> params, String merchantKey) throws BaseAdaPayException {
        String uri = APIUrlEnum.UNION_USER_ID_V1.getCode();
        return AdapayRequest.requestAdapay(uri, params, merchantKey);
    }

    public static Map<String, Object> unionUserId(Map<String, Object> params) throws BaseAdaPayException {
        String uri = APIUrlEnum.UNION_USER_ID_V1.getCode();
        return AdapayRequest.requestAdapay(uri, params);
    }

    public static Map<String, Object> downloadBill(Map<String, Object> params, String merchantKey) throws BaseAdaPayException {
        String uri = APIUrlEnum.BILL_DOWNLOAD_V1.getCode();
        return AdapayRequest.requestAdapay(uri, params, merchantKey);
    }

    public static Map<String, Object> downloadBill(Map<String, Object> params) throws BaseAdaPayException {
        String uri = APIUrlEnum.BILL_DOWNLOAD_V1.getCode();
        return AdapayRequest.requestAdapay(uri, params);
    }

    public static boolean verifySign(String content, String sign, String publicKey) throws Exception {
        return AdapaySign.verifySign((String)content, (String)sign, (String)publicKey, (String)"UTF-8");
    }

    public static boolean verifySign(String content, String sign, String publicKey, String charset) throws Exception {
        try {
            PublicKey pubKey = AdapayTools.getPublicKeyFromX509("RSA", new ByteArrayInputStream(publicKey.getBytes()));
            Signature signature = Signature.getInstance("SHA1withRSA");
            signature.initVerify(pubKey);
            if (charset == null || charset.length() == 0) {
                signature.update(content.getBytes());
            } else {
                signature.update(content.getBytes(charset));
            }
            return signature.verify(Base64.decodeBase64((byte[])sign.getBytes()));
        }
        catch (Exception var6) {
            throw new Exception("RSAcontent = " + content + ",sign=" + sign + ",charset = " + charset, var6);
        }
    }

    public static PublicKey getPublicKeyFromX509(String algorithm, InputStream ins) throws Exception {
        KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
        StringWriter writer = new StringWriter();
        StreamUtil.io((Reader)new InputStreamReader(ins), (Writer)writer);
        byte[] encodedKey = writer.toString().getBytes();
        encodedKey = Base64.decodeBase64((byte[])encodedKey);
        return keyFactory.generatePublic(new X509EncodedKeySpec(encodedKey));
    }
}

