package com.hummingwave.activity;


import android.Manifest;
import android.app.Activity;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.media.ExifInterface;
import android.media.ThumbnailUtils;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.provider.MediaStore;
import android.support.v4.content.ContextCompat;
import android.util.Log;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.LinearLayout;
import android.widget.Toast;

import com.hummingwave.R;
import com.hummingwave.cropImage.Crop;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;


public class ImageCropActivity extends Activity{
    private static final String TAG = "ImageCropActivity";
    Uri source,destination,selectedImageUri;
    public int mode;
    public String imageName;
    boolean thumbnail;
    String folderName;

    // Constants
    public static final int RESULT_OK = -1;
    private final int SELECT_FILE = 1000,CAMERA = 5000;
    private final int REQUEST_CAMERA = 100;
    private final int CAMERA_PERMISSION = 200;
    private final int REQUEST_WRITE_STORAGE = 201;
    public  final String URI ="uri";
    public  final String FOLDER_NAME ="folderName";
    public  final String  THUMBNAIL = "thumbnail";
    public  final String  IMAGE_NAME = "imageName";


    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        requestWindowFeature(Window.FEATURE_NO_TITLE);
        getWindow().addFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN);
        setContentView(R.layout.main);
        fetchImageConfiguration();
        createDirectory();
        initialiseUI();
    }

    public void fetchImageConfiguration(){
        try {
            Bundle bundle = getIntent().getExtras();
            if(bundle != null){
                if (bundle.containsKey(FOLDER_NAME)) {
                    folderName = bundle.getString(FOLDER_NAME);
                }
                if(bundle.containsKey(IMAGE_NAME)){
                    imageName =  bundle.getString(IMAGE_NAME);
                }
                if(bundle.containsKey(THUMBNAIL)){
                    thumbnail =  bundle.getBoolean(THUMBNAIL);
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void createDirectory(){
        try {
            File sdCard = Environment.getExternalStorageDirectory();
            File dir = new File(sdCard.getAbsolutePath() + "/"+folderName);
            dir.mkdirs();
            source = Uri.parse(dir.toString());
            String imageFileName = null;
            if (imageName != null && !imageName.equalsIgnoreCase("")) {
                imageFileName = String.format("%s.jpg",imageName);
            }else{
                imageFileName = String.format("%s.jpg", System.currentTimeMillis());
            }

            String temp = String.format("%s.jpg",imageName+"_thumb");
            new File(source.toString(), imageFileName).delete();
            new File(source.toString(), temp).delete();

            refreshInternalstorage();

            File outFile = new File(dir.toString(), imageFileName);
            destination = Uri.fromFile(outFile);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void initialiseUI(){
        try {
            LinearLayout cameraLL = (LinearLayout) findViewById(R.id.cameraLL);
            LinearLayout galleryLL = (LinearLayout) findViewById(R.id.galleryLL);

            cameraLL.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    mode =CAMERA;
                    if (checkPermissions()) {
                        openCamera();
                    }
                }
            });

            galleryLL.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    mode = SELECT_FILE;
                    if (checkPermissions()) {
                        Crop.pickImage(ImageCropActivity.this);
                    }

                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, String permissions[], int[] grantResults) {
        try {
            switch (requestCode) {
                case CAMERA_PERMISSION:
                    Log.e(TAG, "onRequestPermissionsResult case");
                    if (grantResults.length > 0 && grantResults[0] == PackageManager.PERMISSION_GRANTED) {
                        if (checkPermissions()) {
                            openCamera();
                        }
                    } else {
                        Toast.makeText(ImageCropActivity.this, "Please grant camera permission", Toast.LENGTH_SHORT).show();
                        Log.e(TAG, "else RequestPermission");
                    }
                    return;
                case REQUEST_WRITE_STORAGE: {
                    if (grantResults.length > 0 && grantResults[0] == PackageManager.PERMISSION_GRANTED) {
                        if (mode== CAMERA) {
                            if (checkPermissions()) {
                                openCamera();
                            }
                        }else{
                            Crop.pickImage(ImageCropActivity.this);
                        }
                    } else {
                        Toast.makeText(ImageCropActivity.this, "Please grant storage permission", Toast.LENGTH_LONG).show();
                    }
                }
                default:
                    Log.e(TAG, "default");
                    return;
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, Intent result) {
        try {
            if (resultCode == RESULT_OK) {
                if (requestCode == REQUEST_CAMERA) {
                    Crop.of(selectedImageUri, destination).start(this);
                }else if (requestCode == Crop.REQUEST_PICK) {
                    Crop.of(result.getData(), destination).start(this);
                } else if (requestCode == Crop.REQUEST_CROP) {
                    handleCrop(resultCode, result);
                }
            } else if(resultCode == 0){
                ImageCropActivity.this.finish();
            }
            super.onActivityResult(requestCode, resultCode, result);
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void handleCrop(int resultCode, Intent result) {
        try {
            if (resultCode == RESULT_OK) {
                Intent intent = new Intent();
                intent.putExtra(URI,destination.toString());
                if (thumbnail) {
                    Bitmap resized = ThumbnailUtils.extractThumbnail(BitmapFactory.decodeFile(destination.getPath()), 200, 200);
                    Uri thumbnail = getThumbnail(resized);
                    intent.putExtra(THUMBNAIL,thumbnail.toString());
                }
                setResult(2,intent);
                refreshGallery(destination);
                ImageCropActivity.this.finish();
            } else if (resultCode == Crop.RESULT_ERROR) {
                Toast.makeText(getBaseContext(), Crop.getError(result).getMessage(), Toast.LENGTH_SHORT).show();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Uri getThumbnail(Bitmap bitmap ){
        FileOutputStream out = null;
        try {
            String thumbnailName=  null;
            if (imageName != null && !imageName.equalsIgnoreCase("")) {
                thumbnailName = String.format("%s.jpg",imageName+"_thumb");
            }else{
                thumbnailName = String.format("%s.jpg", System.currentTimeMillis()+"_thumb");
            }
            File outFile = new File(source.toString(), thumbnailName);

            out = new FileOutputStream(outFile);
            float rotation = getCameraPhotoOrientation(getBaseContext(),destination,destination.getPath());
            Matrix matrix = new Matrix();
            matrix.postRotate(rotation);

            int height = bitmap.getHeight();
            int width = bitmap.getWidth();

            bitmap = Bitmap.createBitmap(bitmap, 0, 0, width,
                    height, matrix, true);

            bitmap.compress(Bitmap.CompressFormat.JPEG,90, out); // bmp is your Bitmap instance
            // PNG is a lossless format, the compression factor (100) is ignored
            Log.d(TAG, "thumbnail generated- wrote bytes: " + " to " + outFile.getAbsolutePath());
            return Uri.fromFile(outFile);
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            try {
                if (out != null) {
                    out.close();
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static int getCameraPhotoOrientation(Context context, Uri imageUri, String imagePath) {
        int rotate = 0;
        try {
            context.getContentResolver().notifyChange(imageUri, null);
            File imageFile = new File(imagePath);

            ExifInterface exif = new ExifInterface(imageFile.getAbsolutePath());
            int orientation = exif.getAttributeInt(ExifInterface.TAG_ORIENTATION, ExifInterface.ORIENTATION_NORMAL);

            switch (orientation) {
                case ExifInterface.ORIENTATION_ROTATE_270:
                    rotate = 270;
                    break;
                case ExifInterface.ORIENTATION_ROTATE_180:
                    rotate = 180;
                    break;
                case ExifInterface.ORIENTATION_ROTATE_90:
                    rotate = 90;
                    break;
            }

            Log.i("RotateImage", "Exif orientation: " + orientation);
            Log.i("RotateImage", "Rotate value: " + rotate);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return rotate;
    }

    public boolean  checkPermissions(){
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
            if (ContextCompat.checkSelfPermission(ImageCropActivity.this, Manifest.permission.CAMERA)
                    != PackageManager.PERMISSION_GRANTED) {
                requestPermissions(new String[]{Manifest.permission.CAMERA}, CAMERA_PERMISSION);
                return false;
            } else if (ContextCompat.checkSelfPermission(ImageCropActivity.this, Manifest.permission.WRITE_EXTERNAL_STORAGE)
                    != PackageManager.PERMISSION_GRANTED) {
                requestPermissions(new String[]{Manifest.permission.WRITE_EXTERNAL_STORAGE}, REQUEST_WRITE_STORAGE);
                return false;
            } else{
                return true;
            }
        }else{
            return true;
        }
    }

    public void openCamera(){
        Intent intent = new Intent(MediaStore.ACTION_IMAGE_CAPTURE);
        ContentValues values = new ContentValues();
        values.put(MediaStore.Images.Media.TITLE, "New Picture");
        values.put(MediaStore.Images.Media.DESCRIPTION, "From your Camera");
        selectedImageUri = getContentResolver().insert(
                MediaStore.Images.Media.EXTERNAL_CONTENT_URI, values);
        intent.putExtra(MediaStore.EXTRA_OUTPUT, selectedImageUri);
        ImageCropActivity.this.startActivityForResult(intent, REQUEST_CAMERA);
    }

    private void refreshGallery(Uri uri) {
        Intent mediaScanIntent = new Intent(Intent.ACTION_MEDIA_SCANNER_SCAN_FILE);
        mediaScanIntent.setData(uri);
        sendBroadcast(mediaScanIntent);
    }

    public void refreshInternalstorage(){
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT) {
            Intent mediaScanIntent = new Intent(
                    Intent.ACTION_MEDIA_SCANNER_SCAN_FILE);
            Uri contentUri = Uri.fromFile( new File(source.toString()));
            mediaScanIntent.setData(contentUri);
            ImageCropActivity.this.sendBroadcast(mediaScanIntent);
        } else {
            sendBroadcast(new Intent(
                    Intent.ACTION_MEDIA_MOUNTED,
                    Uri.parse("file://"
                            + Environment.getExternalStorageDirectory())));
        }
    }

}


