/*
 * Decompiled with CFR 0.152.
 */
package com.hummingwave.activity;

import android.app.Activity;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.media.ExifInterface;
import android.media.ThumbnailUtils;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.Parcelable;
import android.provider.MediaStore;
import android.support.v4.content.ContextCompat;
import android.util.Log;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.Toast;
import com.hummingwave.R;
import com.hummingwave.cropImage.Crop;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ImageCropActivity
extends Activity {
    private static final String TAG = "ImageCropActivity";
    Uri source;
    Uri destination;
    Uri selectedImageUri;
    public int mode;
    public String imageName;
    boolean thumbnail;
    String folderName;
    public static final int RESULT_OK = -1;
    private final int SELECT_FILE = 1000;
    private final int CAMERA = 5000;
    private final int REQUEST_CAMERA = 100;
    private final int CAMERA_PERMISSION = 200;
    private final int REQUEST_WRITE_STORAGE = 201;
    public final String URI = "uri";
    public final String FOLDER_NAME = "folderName";
    public final String THUMBNAIL = "thumbnail";
    public final String IMAGE_NAME = "imageName";

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.requestWindowFeature(1);
        this.getWindow().addFlags(1024);
        this.setContentView(R.layout.main);
        this.fetchImageConfiguration();
        this.createDirectory();
        this.initialiseUI();
    }

    public void fetchImageConfiguration() {
        try {
            Bundle bundle = this.getIntent().getExtras();
            if (bundle != null) {
                if (bundle.containsKey("folderName")) {
                    this.folderName = bundle.getString("folderName");
                }
                if (bundle.containsKey("imageName")) {
                    this.imageName = bundle.getString("imageName");
                }
                if (bundle.containsKey("thumbnail")) {
                    this.thumbnail = bundle.getBoolean("thumbnail");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void createDirectory() {
        try {
            File sdCard = Environment.getExternalStorageDirectory();
            File dir = new File(sdCard.getAbsolutePath() + "/" + this.folderName);
            dir.mkdirs();
            this.source = Uri.parse((String)dir.toString());
            String imageFileName = null;
            imageFileName = this.imageName != null && !this.imageName.equalsIgnoreCase("") ? String.format("%s.jpg", this.imageName) : String.format("%s.jpg", System.currentTimeMillis());
            String temp = String.format("%s.jpg", this.imageName + "_thumb");
            new File(this.source.toString(), imageFileName).delete();
            new File(this.source.toString(), temp).delete();
            this.refreshInternalstorage();
            File outFile = new File(dir.toString(), imageFileName);
            this.destination = Uri.fromFile((File)outFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void initialiseUI() {
        try {
            LinearLayout cameraLL = (LinearLayout)this.findViewById(R.id.cameraLL);
            LinearLayout galleryLL = (LinearLayout)this.findViewById(R.id.galleryLL);
            cameraLL.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    ImageCropActivity.this.mode = 5000;
                    if (ImageCropActivity.this.checkPermissions()) {
                        ImageCropActivity.this.openCamera();
                    }
                }
            });
            galleryLL.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    ImageCropActivity.this.mode = 1000;
                    if (ImageCropActivity.this.checkPermissions()) {
                        Crop.pickImage(ImageCropActivity.this);
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        try {
            switch (requestCode) {
                case 200: {
                    Log.e((String)TAG, (String)"onRequestPermissionsResult case");
                    if (grantResults.length > 0 && grantResults[0] == 0) {
                        if (this.checkPermissions()) {
                            this.openCamera();
                        }
                    } else {
                        Toast.makeText((Context)this, (CharSequence)"Please grant camera permission", (int)0).show();
                        Log.e((String)TAG, (String)"else RequestPermission");
                    }
                    return;
                }
                case 201: {
                    if (grantResults.length > 0 && grantResults[0] == 0) {
                        if (this.mode == 5000) {
                            if (!this.checkPermissions()) break;
                            this.openCamera();
                            break;
                        }
                        Crop.pickImage(this);
                        break;
                    }
                    Toast.makeText((Context)this, (CharSequence)"Please grant storage permission", (int)1).show();
                }
            }
            Log.e((String)TAG, (String)"default");
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent result) {
        try {
            if (resultCode == -1) {
                if (requestCode == 100) {
                    Crop.of(this.selectedImageUri, this.destination).start(this);
                } else if (requestCode == 9162) {
                    Crop.of(result.getData(), this.destination).start(this);
                } else if (requestCode == 6709) {
                    this.handleCrop(resultCode, result);
                }
            } else if (resultCode == 0) {
                this.finish();
            }
            super.onActivityResult(requestCode, resultCode, result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void handleCrop(int resultCode, Intent result) {
        try {
            if (resultCode == -1) {
                Intent intent = new Intent();
                intent.putExtra("uri", this.destination.toString());
                if (this.thumbnail) {
                    Bitmap resized = ThumbnailUtils.extractThumbnail((Bitmap)BitmapFactory.decodeFile((String)this.destination.getPath()), (int)200, (int)200);
                    Uri thumbnail = this.getThumbnail(resized);
                    intent.putExtra("thumbnail", thumbnail.toString());
                }
                this.setResult(2, intent);
                this.refreshGallery(this.destination);
                this.finish();
            } else if (resultCode == 404) {
                Toast.makeText((Context)this.getBaseContext(), (CharSequence)Crop.getError(result).getMessage(), (int)0).show();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Uri getThumbnail(Bitmap bitmap) {
        FileOutputStream out = null;
        try {
            String thumbnailName = null;
            thumbnailName = this.imageName != null && !this.imageName.equalsIgnoreCase("") ? String.format("%s.jpg", this.imageName + "_thumb") : String.format("%s.jpg", System.currentTimeMillis() + "_thumb");
            File outFile = new File(this.source.toString(), thumbnailName);
            out = new FileOutputStream(outFile);
            float rotation = ImageCropActivity.getCameraPhotoOrientation(this.getBaseContext(), this.destination, this.destination.getPath());
            Matrix matrix = new Matrix();
            matrix.postRotate(rotation);
            int height = bitmap.getHeight();
            int width = bitmap.getWidth();
            bitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)true);
            bitmap.compress(Bitmap.CompressFormat.JPEG, 90, (OutputStream)out);
            Log.d((String)TAG, (String)("thumbnail generated- wrote bytes:  to " + outFile.getAbsolutePath()));
            Uri uri = Uri.fromFile((File)outFile);
            return uri;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static int getCameraPhotoOrientation(Context context, Uri imageUri, String imagePath) {
        int rotate = 0;
        try {
            context.getContentResolver().notifyChange(imageUri, null);
            File imageFile = new File(imagePath);
            ExifInterface exif = new ExifInterface(imageFile.getAbsolutePath());
            int orientation = exif.getAttributeInt("Orientation", 1);
            switch (orientation) {
                case 8: {
                    rotate = 270;
                    break;
                }
                case 3: {
                    rotate = 180;
                    break;
                }
                case 6: {
                    rotate = 90;
                }
            }
            Log.i((String)"RotateImage", (String)("Exif orientation: " + orientation));
            Log.i((String)"RotateImage", (String)("Rotate value: " + rotate));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rotate;
    }

    public boolean checkPermissions() {
        if (Build.VERSION.SDK_INT >= 23) {
            if (ContextCompat.checkSelfPermission((Context)this, (String)"android.permission.CAMERA") != 0) {
                this.requestPermissions(new String[]{"android.permission.CAMERA"}, 200);
                return false;
            }
            if (ContextCompat.checkSelfPermission((Context)this, (String)"android.permission.WRITE_EXTERNAL_STORAGE") != 0) {
                this.requestPermissions(new String[]{"android.permission.WRITE_EXTERNAL_STORAGE"}, 201);
                return false;
            }
            return true;
        }
        return true;
    }

    public void openCamera() {
        Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
        ContentValues values = new ContentValues();
        values.put("title", "New Picture");
        values.put("description", "From your Camera");
        this.selectedImageUri = this.getContentResolver().insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, values);
        intent.putExtra("output", (Parcelable)this.selectedImageUri);
        this.startActivityForResult(intent, 100);
    }

    private void refreshGallery(Uri uri) {
        Intent mediaScanIntent = new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE");
        mediaScanIntent.setData(uri);
        this.sendBroadcast(mediaScanIntent);
    }

    public void refreshInternalstorage() {
        if (Build.VERSION.SDK_INT >= 19) {
            Intent mediaScanIntent = new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE");
            Uri contentUri = Uri.fromFile((File)new File(this.source.toString()));
            mediaScanIntent.setData(contentUri);
            this.sendBroadcast(mediaScanIntent);
        } else {
            this.sendBroadcast(new Intent("android.intent.action.MEDIA_MOUNTED", Uri.parse((String)("file://" + Environment.getExternalStorageDirectory()))));
        }
    }
}

