/*
 * Decompiled with CFR 0.152.
 */
package org.bson.io;

import java.nio.ByteOrder;
import java.nio.charset.Charset;
import org.bson.BsonSerializationException;
import org.bson.ByteBuf;
import org.bson.io.BsonInput;
import org.bson.types.ObjectId;

public class ByteBufferBsonInput
implements BsonInput {
    private static final Charset UTF8_CHARSET = Charset.forName("UTF-8");
    private ByteBuf buffer;
    private int mark = -1;

    public ByteBufferBsonInput(ByteBuf buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException("buffer can not be null");
        }
        this.buffer = buffer;
        buffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    public int getPosition() {
        this.ensureOpen();
        return this.buffer.position();
    }

    public byte readByte() {
        this.ensureOpen();
        this.ensureAvailable(1);
        return this.buffer.get();
    }

    public void readBytes(byte[] bytes) {
        this.ensureOpen();
        this.ensureAvailable(bytes.length);
        this.buffer.get(bytes);
    }

    public void readBytes(byte[] bytes, int offset, int length) {
        this.ensureOpen();
        this.ensureAvailable(length);
        this.buffer.get(bytes, offset, length);
    }

    public long readInt64() {
        this.ensureOpen();
        this.ensureAvailable(8);
        return this.buffer.getLong();
    }

    public double readDouble() {
        this.ensureOpen();
        this.ensureAvailable(8);
        return this.buffer.getDouble();
    }

    public int readInt32() {
        this.ensureOpen();
        this.ensureAvailable(4);
        return this.buffer.getInt();
    }

    public String readString() {
        this.ensureOpen();
        int size = this.readInt32();
        if (size <= 0) {
            throw new BsonSerializationException(String.format("While decoding a BSON string found a size that is not a positive number: %d", size));
        }
        byte[] bytes = new byte[size];
        this.readBytes(bytes);
        if (bytes[size - 1] != 0) {
            throw new BsonSerializationException("Found a BSON string that is not null-terminated");
        }
        return new String(bytes, 0, size - 1, UTF8_CHARSET);
    }

    public ObjectId readObjectId() {
        this.ensureOpen();
        byte[] bytes = new byte[12];
        this.readBytes(bytes);
        return new ObjectId(bytes);
    }

    public String readCString() {
        this.ensureOpen();
        int mark = this.buffer.position();
        this.readUntilNullByte();
        int size = this.buffer.position() - mark - 1;
        this.buffer.position(mark);
        byte[] bytes = new byte[size];
        this.readBytes(bytes);
        this.readByte();
        return new String(bytes, UTF8_CHARSET);
    }

    private void readUntilNullByte() {
        while (this.readByte() != 0) {
        }
    }

    public void skipCString() {
        this.ensureOpen();
        this.readUntilNullByte();
    }

    public void skip(int numBytes) {
        this.ensureOpen();
        this.buffer.position(this.buffer.position() + numBytes);
    }

    public void mark(int readLimit) {
        this.ensureOpen();
        this.mark = this.buffer.position();
    }

    public void reset() {
        this.ensureOpen();
        if (this.mark == -1) {
            throw new IllegalStateException("Mark not set");
        }
        this.buffer.position(this.mark);
    }

    public boolean hasRemaining() {
        this.ensureOpen();
        return this.buffer.hasRemaining();
    }

    public void close() {
        this.buffer.release();
        this.buffer = null;
    }

    private void ensureOpen() {
        if (this.buffer == null) {
            throw new IllegalStateException("Stream is closed");
        }
    }

    private void ensureAvailable(int bytesNeeded) {
        if (this.buffer.remaining() < bytesNeeded) {
            throw new BsonSerializationException(String.format("While decoding a BSON document %d bytes were required, but only %d remain", bytesNeeded, this.buffer.remaining()));
        }
    }
}

