/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class ClientGUI
extends JFrame {
    final JRadiusWiFiClient client;
    JButton loginButton = new JButton("Login");
    JButton logoutButton = new JButton("Logout");
    JLabel statusLabel = new JLabel("Not yet on-line");
    JLabel locationLabel = new JLabel("unknown");

    public ClientGUI(JRadiusWiFiClient client) {
        super("JRadius WiFi WISPr Client");
        this.client = client;
        this.setSize(350, 275);
        this.getContentPane().setLayout(new BorderLayout());
        GridBagLayout gridBagLayout = new GridBagLayout();
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(gridBagLayout);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(25, 25, 10, 25);
        contentPanel.add((Component)new JLabel("Status:"), gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridwidth = 0;
        gbc.insets = new Insets(25, 25, 25, 10);
        contentPanel.add((Component)this.statusLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.insets = new Insets(10, 25, 10, 25);
        contentPanel.add((Component)new JLabel("Location:"), gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridwidth = 0;
        gbc.insets = new Insets(10, 25, 25, 10);
        contentPanel.add((Component)this.locationLabel, gbc);
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.loginButton);
        buttonPanel.add(this.logoutButton);
        this.getContentPane().add((Component)contentPanel, "Center");
        this.getContentPane().add((Component)buttonPanel, "South");
        this.loginButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClientGUI.this.login();
            }
        });
        this.logoutButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClientGUI.this.logoff();
            }
        });
    }

    public void login() {
        String username = this.client.getUsername();
        String password = this.client.getPassword();
        JTextField usernameField = new JTextField(username);
        JPasswordField passwordField = new JPasswordField(password);
        passwordField.setEchoChar('*');
        Object[] msg = new Object[]{"User Name", usernameField, "Password", passwordField};
        int result = JOptionPane.showConfirmDialog(this, msg, "WISPr Login", 2, -1);
        if (result == 0) {
            username = usernameField.getText();
            password = new String(passwordField.getPassword());
        }
        this.client.login(username, password);
    }

    public void logoff() {
        this.client.logoff();
    }

    public void setLocation(String location) {
        this.locationLabel.setText(location);
    }

    public void setStatus(String status) {
        this.statusLabel.setText(status);
    }
}

