/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.applet.AppletContext;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.KeyManagementException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.security.cert.X509Certificate;
import javax.net.SocketFactory;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.X509TrustManager;

public class JRadiusWiFiClient
extends Applet
implements Runnable {
    static final long serialVersionUID = 0L;
    private Thread guiThread = null;
    private String prefixRealm = null;
    private String username = null;
    private String realm = null;
    private String password = null;
    private String WISPrLogin = null;
    private String WISPrAbortLogin = null;
    private String WISPrLogoff = null;
    private String WISPrLocationName = null;
    private String[] WISPrXML = new String[2];
    private static String cookie = null;
    private static boolean secureRoaming = false;
    private static String otpProxyServer = "ap.coova.org";
    private static String otpProxyPort = "1810";
    private static boolean otpUseSSL = true;
    private static boolean otpTrustAnyCert = true;
    private static String otpCertChain = null;
    private static boolean isJavaReady = true;
    private static boolean isReady = false;
    private static boolean isOnline = false;
    private boolean paused;
    private final Object pauseLock = new Object();
    private volatile boolean noStopRequested;
    private Dimension d;
    private String message = "JRadius WiFi Client";
    private String ENCODING = "utf-8";
    public static String publicURL = "http://www.microsoft.com/en/us/default.aspx";
    public static String titleMatch = "Microsoft Corporation";
    public static String baseURL = "http://ap.coova.org/wifi/";
    public static String welcomeURL = "welcome";
    public static String onlineURL = "online";
    public static String loginURL = "login";
    public static String noWISPrURL = "nowispr";
    public static String badWISPrURL = "badwispr";
    private static boolean DEBUG = true;
    private static StringBuffer debugString = new StringBuffer();
    private boolean isApplet = true;
    private static Boolean isCommunicator;
    private Boolean haveJavaSecurity = null;
    private SecurityManager securityManager;
    private static JRadiusWiFiClient client;
    private static Thread clientThread;
    private static ClientGUI clientGUI;
    private static boolean runLogout;
    private static String copy;
    public static final int EAP_HEADERLEN = 4;
    public static final int EAP_REQUEST = 1;
    public static final int EAP_RESPONSE = 2;
    public static final int EAP_SUCCESS = 3;
    public static final int EAP_FAILURE = 4;
    public static final int EAP_IDENTITY = 1;
    public static final int EAP_NOTIFICATION = 2;
    public static final int EAP_NAK = 3;
    public static final int EAP_MD5 = 4;
    public static final int EAP_OTP = 5;
    public static final int EAP_GTC = 6;
    public static final int EAP_TLS = 13;
    public static final int EAP_LEAP = 17;
    public static final int EAP_SIM = 18;
    public static final int EAP_TTLS = 21;
    public static final int EAP_PEAP = 25;
    public static final int EAP_MSCHAPV2 = 26;
    public static final int EAP_CISCO_MSCHAPV2 = 29;
    public static final int EAP_TLV = 33;

    public JRadiusWiFiClient getInstance() {
        return new JRadiusWiFiClient();
    }

    public String getAppletInfo() {
        return copy;
    }

    public static void main(String[] args) {
        client = new JRadiusWiFiClient();
        client.isApplet(false);
        if (args.length >= 2) {
            client.setUsername(args[0]);
            client.setPassword(args[1]);
        }
        if (args.length >= 3) {
            otpProxyServer = args[2];
        }
        if (args.length == 4) {
            publicURL = args[3];
        }
        clientGUI = new ClientGUI(client);
        client.findWISPrLogin(publicURL);
        clientGUI.setVisible(true);
    }

    public void run() {
        if (runLogout) {
            this.doWISPrLogoff();
        } else {
            this.doWISPrLogin();
        }
    }

    public void login(String username, String password) {
        if (username != null) {
            this.setUsername(username);
        }
        if (password != null) {
            this.setPassword(password);
        }
        if (client != null) {
            runLogout = false;
            if (clientThread != null) {
                clientThread.interrupt();
            }
            clientThread = new Thread(client);
            clientThread.start();
        } else {
            this.doWISPrLogin();
        }
    }

    public void logoff() {
        if (client != null) {
            runLogout = true;
            if (clientThread != null) {
                clientThread.interrupt();
            }
            clientThread = new Thread(client);
            clientThread.start();
        } else {
            this.doWISPrLogoff();
        }
    }

    public void reset() {
        this.findWISPrLogin(publicURL);
    }

    public void init() {
        System.err.println(copy);
        this.setFont(new Font("Verdana", 0, 12));
        this.securityManager = System.getSecurityManager();
        if (this.isCommunicator()) {
            try {
                Class<?> privilegeManager = Class.forName("netscape.security.PrivilegeManager");
                Method enablePrivilege = privilegeManager.getMethod("enablePrivilege", String.class);
                enablePrivilege.invoke(null, "UniversalXPConnect");
                enablePrivilege.invoke(null, "UniversalConnect");
            }
            catch (Throwable privilegeManager) {}
        } else {
            try {
                Class<?> policyEngine = Class.forName("com.ms.security.PolicyEngine");
                Class<?> permissionID = Class.forName("com.ms.security.PermissionID");
                Method assertPermission = policyEngine.getMethod("assertPermission", permissionID);
                Field permId = permissionID.getField("NETIO");
                assertPermission.invoke(null, permId.get(null));
            }
            catch (Throwable policyEngine) {
                // empty catch block
            }
        }
        try {
            this.d = this.getSize();
        }
        catch (NoSuchMethodError e) {
            this.d = this.size();
        }
        URL docBase = this.getCodeBase();
        baseURL = docBase.toExternalForm();
        this.debugWrite("Version Info:\n" + System.getProperty("java.vendor") + " " + System.getProperty("java.version") + " running on " + System.getProperty("os.name") + " " + System.getProperty("os.version") + " " + System.getProperty("os.arch"));
        this.validate();
        this.startGuiThread();
    }

    private void startGuiThread() {
        this.paused = true;
        this.noStopRequested = true;
        Runnable r = new Runnable(){

            public void run() {
                JRadiusWiFiClient.this.runGui();
            }
        };
        this.guiThread = new Thread(r, "GUI-Thread");
        this.guiThread.start();
    }

    private void stopGuiThread() {
        this.noStopRequested = false;
        this.guiThread.interrupt();
    }

    private void runGui() {
        try {
            while (this.noStopRequested) {
                this.waitWhilePaused();
                this.repaint();
                if (!isOnline && !isReady) {
                    this.addItem("Finding out how to login...");
                    this.findWISPrLogin(publicURL);
                }
                Thread.sleep(1000L);
            }
        }
        catch (InterruptedException x) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPaused(boolean newPauseState) {
        Object object = this.pauseLock;
        synchronized (object) {
            if (this.paused != newPauseState) {
                this.paused = newPauseState;
                this.pauseLock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitWhilePaused() throws InterruptedException {
        Object object = this.pauseLock;
        synchronized (object) {
            while (this.paused) {
                this.pauseLock.wait();
            }
        }
    }

    public void start() {
        this.setPaused(false);
    }

    public void stop() {
        isReady = false;
        isOnline = false;
        this.setPaused(true);
    }

    public void destroy() {
        this.stopGuiThread();
    }

    public void update(Graphics g) {
    }

    public void paint(Graphics g) {
    }

    private void addItem(String newWord) {
        this.addItem(newWord, true);
    }

    private void addItem(String newWord, boolean clean1st) {
        this.message = clean1st ? newWord : this.message + newWord;
        this.setStatus(this.message);
        System.out.println(newWord);
    }

    private void debugWrite(String msg) {
        if (DEBUG) {
            System.out.println(msg);
            debugString.append(msg).append("\n");
        }
    }

    private void redirect(String page) {
        if (!this.isApplet()) {
            return;
        }
        try {
            AppletContext context = this.getAppletContext();
            context.showDocument(new URL("javascript:showPage('" + page + "');"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setStatus(String s) {
        if (!this.isApplet()) {
            clientGUI.setStatus(s);
            return;
        }
        try {
            AppletContext context = this.getAppletContext();
            context.showDocument(new URL("javascript:showStatus('" + s + "');"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void findWISPrLogin(String url) {
        PageResult result = this.getPage(url, cookie);
        if (result == null) {
            return;
        }
        if (result.getIsXML() == 0) {
            String title = this.getXMLParam(result.getContent(), null, "title");
            if (title != null && titleMatch.equals(title)) {
                isOnline = true;
                this.addItem("You are already online.");
                this.redirect(onlineURL);
            } else {
                this.addItem("WISPr is not supported here.");
                this.redirect(noWISPrURL);
            }
        } else {
            String xml = this.WISPrXML[0] = result.getContent();
            this.debugWrite("Extracted WISPr XML:\n" + xml);
            String xmll = xml.toLowerCase();
            String responseCode = this.getXMLParam(xml, xmll, "responsecode");
            if (responseCode == null) {
                this.redirect(badWISPrURL);
                return;
            }
            if ("200".equals(responseCode)) {
                String nextUrl = this.getXMLParam(xml, xmll, "nexturl");
                if (nextUrl != null && !"".equals(nextUrl)) {
                    this.findWISPrLogin(nextUrl);
                } else {
                    this.redirect(badWISPrURL);
                }
            } else if ("201".equals(responseCode)) {
                String loginResultsURL = this.getXMLParam(xml, xmll, "loginresultsurl");
                if (loginResultsURL != null && !"".equals(loginResultsURL)) {
                    this.findWISPrLogin(loginResultsURL);
                } else {
                    this.redirect(badWISPrURL);
                }
            } else {
                this.WISPrLogin = this.getXMLParam(xml, xmll, "loginurl");
                this.WISPrAbortLogin = this.getXMLParam(xml, xmll, "abortloginurl");
                this.WISPrLocationName = this.getXMLParam(xml, xmll, "locationname");
                this.debugWrite("Extracted login URL from WISPr XML:\n" + this.WISPrLogin);
                String msg = "Found WiFi Network";
                if (this.WISPrLogin != null) {
                    isReady = true;
                }
                if (this.isApplet()) {
                    if (this.WISPrLocationName != null) {
                        msg = msg + " - Location: " + this.WISPrLocationName;
                    }
                } else {
                    clientGUI.setLocation(this.WISPrLocationName);
                }
                this.addItem(msg);
                this.redirect(loginURL);
            }
        }
    }

    private void doWISPrLogin() {
        try {
            if (this.WISPrLogin == null) {
                return;
            }
            if (this.username.length() < 1) {
                throw new RuntimeException("Please enter username");
            }
            if (this.password.length() < 1) {
                throw new RuntimeException("Please enter username");
            }
            String wisprUsername = this.username;
            String wisprPassword = this.password;
            if (secureRoaming) {
                try {
                    ControlThread control = new ControlThread(this.username);
                    wisprUsername = control.getOtpUsername();
                    wisprPassword = control.getOtpPassword();
                    control.start();
                    System.out.println("Using OTP " + wisprUsername + "/" + wisprPassword);
                }
                catch (IOException ioe) {
                    System.err.println("Unable to secure username and password!");
                }
            }
            StringBuffer loginUrl = new StringBuffer(this.WISPrLogin);
            if (this.WISPrLogin.indexOf("?") > 0) {
                loginUrl.append("&");
            } else {
                loginUrl.append("?");
            }
            if (this.prefixRealm != null && this.prefixRealm.length() > 0) {
                wisprUsername = this.prefixRealm + "/" + wisprUsername;
            }
            loginUrl.append("UserName=").append(this.urlEncode(wisprUsername));
            loginUrl.append("&Password=").append(this.urlEncode(wisprPassword));
            String providerUrl = loginUrl.toString();
            this.addItem("Logging into the WiFi Network...");
            this.debugWrite("Login using url " + providerUrl);
            this.redirect(this.processWISPrResponse(providerUrl));
        }
        catch (Exception rte) {
            this.debugWrite("Runtime Exception: " + rte.getMessage());
        }
    }

    private String processWISPrResponse(String url) {
        PageResult result = this.getPage(url, cookie);
        if (result.getIsXML() == 0) {
            this.debugWrite("Did not get WISPr XML in: " + result.getContent());
            return badWISPrURL;
        }
        String xml = this.WISPrXML[1] = result.getContent();
        this.debugWrite("Extracted WISPr XML:\n" + xml);
        String xmll = xml.toLowerCase();
        String loginResult = this.getXMLParam(xml, xmll, "responsecode");
        String loginResultsUrl = this.getXMLParam(xml, xmll, "loginresultsurl");
        String replyMessage = this.getXMLParam(xml, xmll, "replymessage");
        this.WISPrLogoff = this.getXMLParam(xml, xmll, "logoffurl");
        if (loginResult == null) {
            this.addItem("Login failed (Bad WISPr XML): " + replyMessage);
            return badWISPrURL;
        }
        if ("50".equals(loginResult)) {
            isOnline = true;
            if (replyMessage == null) {
                this.addItem("Login Successful!");
            } else {
                this.addItem(replyMessage);
            }
            this.debugWrite("Successful login: Redirecting user to " + welcomeURL);
            return welcomeURL;
        }
        if ("201".equals(loginResult)) {
            if (replyMessage == null) {
                this.addItem("Login pending...");
            } else {
                this.addItem(replyMessage);
            }
            this.debugWrite("Login pending: resultsUrl " + loginResultsUrl);
            return this.processWISPrResponse(loginResultsUrl);
        }
        if (replyMessage == null) {
            this.addItem("Login failed!");
        } else {
            this.addItem("Login failed: " + replyMessage);
        }
        return loginURL;
    }

    private void doWISPrLogoff() {
        if (this.WISPrLogoff == null) {
            return;
        }
        this.addItem("Logging out of WiFi Network...");
        PageResult result = this.getPage(this.WISPrLogoff, cookie);
        if (result.getIsXML() == 1) {
            this.debugWrite("WISPr XML:\n" + result.getContent());
        } else {
            this.debugWrite("NO WISPr XML in:\n" + result.getContent());
        }
        this.reset();
    }

    private PageResult getPage(final String urlString, final String cookieString) throws RuntimeException {
        if (this.haveJavaSecurity()) {
            PageResult result = (PageResult)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return JRadiusWiFiClient.doGetPage(urlString, cookieString);
                }
            });
            return result;
        }
        return JRadiusWiFiClient.doGetPage(urlString, cookieString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PageResult doGetPage(String urlString, String cookieString) {
        StringBuffer sb = new StringBuffer();
        HttpURLConnection conn = null;
        String location = null;
        try {
            PageResult pageResult;
            String str;
            URL url = new URL(urlString);
            conn = (HttpURLConnection)url.openConnection();
            if (conn instanceof HttpsURLConnection) {
                HttpsURLConnection sconn = (HttpsURLConnection)conn;
                SSLContext sslContext = SSLContext.getInstance("SSL");
                sslContext.init(null, new X509TrustManager[]{new X509TrustManager(){

                    public void checkClientTrusted(X509Certificate[] chain, String authType) {
                    }

                    public void checkServerTrusted(X509Certificate[] chain, String authType) {
                    }

                    public X509Certificate[] getAcceptedIssuers() {
                        return new X509Certificate[0];
                    }
                }}, null);
                sconn.setSSLSocketFactory(sslContext.getSocketFactory());
                sconn.setHostnameVerifier(new HostnameVerifier(){

                    public boolean verify(String hostname, SSLSession session) {
                        return true;
                    }
                });
            }
            conn.setDoInput(true);
            conn.setDoOutput(true);
            conn.setUseCaches(false);
            conn.setInstanceFollowRedirects(false);
            if (cookieString != null) {
                conn.setRequestProperty("Cookie", cookieString);
            }
            BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            int n = 1;
            boolean done = false;
            while (!done) {
                String headerKey = conn.getHeaderFieldKey(n);
                String headerVal = conn.getHeaderField(n);
                if (headerKey != null || headerVal != null) {
                    if (headerKey.equals("Location")) {
                        location = headerVal;
                    } else if (headerKey.equals("Set-Cookie")) {
                        cookie = headerVal;
                    }
                    System.out.println(headerKey + " = " + headerVal);
                } else {
                    done = true;
                }
                ++n;
            }
            while ((str = in.readLine()) != null) {
                sb.append(str + "\n");
            }
            in.close();
            String wisprXml = JRadiusWiFiClient.getWISPrXML(sb.toString());
            if (wisprXml != null) {
                pageResult = new PageResult(wisprXml, 1);
                return pageResult;
            }
            if (location != null) {
                conn.disconnect();
                pageResult = JRadiusWiFiClient.doGetPage(location, cookie);
                return pageResult;
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            throw new RuntimeException("getPage: " + e.getClass().getName() + ":" + e.getMessage() + "...");
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("getPage: " + e.getClass().getName() + ":" + e.getMessage() + "...");
        }
        catch (Exception e) {
            e.printStackTrace();
            isJavaReady = false;
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        return new PageResult(sb.toString(), 0);
    }

    private static String getWISPrXML(String responseHtml) throws RuntimeException {
        String htmll = responseHtml.toLowerCase();
        int WISPrStartIndex = htmll.indexOf("<wispaccessgatewayparam");
        int WISPrEndIndex = htmll.indexOf("</wispaccessgatewayparam>") + 25;
        if (WISPrStartIndex > 0) {
            return responseHtml.substring(WISPrStartIndex, WISPrEndIndex);
        }
        return null;
    }

    private String getXMLParam(String xml, String xmll, String tag) throws RuntimeException {
        if (xmll == null) {
            xmll = xml.toLowerCase();
        }
        int startIndex = xmll.indexOf("<" + tag + ">");
        int endIndex = xmll.indexOf("</" + tag + ">");
        if (startIndex > 0) {
            String res = this.urlDecode(xml.substring(startIndex += tag.length() + 2, endIndex));
            res = this.stringReplaceAll(res, "&amp;", "&");
            return res;
        }
        return null;
    }

    private String urlEncode(String s) {
        String res = s;
        try {
            res = URLEncoder.encode(s, this.ENCODING);
        }
        catch (NoSuchMethodError e) {
            res = URLEncoder.encode(s);
        }
        catch (Exception e) {
            res = URLEncoder.encode(s);
        }
        return res;
    }

    private String urlDecode(String s) {
        String res = s;
        try {
            res = URLDecoder.decode(s, this.ENCODING);
        }
        catch (NoSuchMethodError e) {
            res = URLDecoder.decode(s);
        }
        catch (Exception e) {
            res = URLDecoder.decode(s);
        }
        return res;
    }

    private String stringReplaceAll(String s, String find, String replace) {
        String result = null;
        try {
            result = s.replaceAll(find, replace);
        }
        catch (NoSuchMethodError e) {
            StringBuffer sb = new StringBuffer(s);
            int index = s.length();
            int offset = find.length();
            while ((index = s.lastIndexOf(find, index - 1)) > -1) {
                sb.replace(index, index + offset, replace);
            }
            result = sb.toString();
        }
        return result;
    }

    private boolean haveJavaSecurity() {
        if (this.haveJavaSecurity == null) {
            this.haveJavaSecurity = Boolean.FALSE;
            try {
                Class<?> t = Class.forName("java.security.PrivilegedAction");
                this.haveJavaSecurity = Boolean.TRUE;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.haveJavaSecurity;
    }

    private boolean isCommunicator() {
        if (isCommunicator == null) {
            isCommunicator = Boolean.FALSE;
            try {
                Class<?> t = Class.forName("netscape.security.UserDialogHelper");
                isCommunicator = Boolean.TRUE;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return isCommunicator;
    }

    public String getPassword() {
        return JRadiusWiFiClient.nonNullString(this.password);
    }

    public void setPassword(String password) {
        this.password = JRadiusWiFiClient.trimString(password);
    }

    public String getUsername() {
        return JRadiusWiFiClient.nonNullString(this.username);
    }

    public void setUsername(String username) {
        this.username = JRadiusWiFiClient.trimString(username);
    }

    public String getRealm() {
        return JRadiusWiFiClient.nonNullString(this.realm);
    }

    public void setRealm(String realm) {
        this.realm = JRadiusWiFiClient.trimString(realm);
    }

    public String getWISPrXML0() {
        return JRadiusWiFiClient.nonNullString(this.WISPrXML[0]);
    }

    public String getWISPrXML1() {
        return JRadiusWiFiClient.nonNullString(this.WISPrXML[1]);
    }

    public String getWISPrLocationName() {
        return JRadiusWiFiClient.nonNullString(this.WISPrLocationName);
    }

    public String getWISPrLogin() {
        return JRadiusWiFiClient.nonNullString(this.WISPrLogin);
    }

    public String getWISPrAbortLogin() {
        return JRadiusWiFiClient.nonNullString(this.WISPrAbortLogin);
    }

    public String getWISPrLogoff() {
        return JRadiusWiFiClient.nonNullString(this.WISPrLogoff);
    }

    public static String getOtpCertChain() {
        return JRadiusWiFiClient.nonNullString(otpCertChain);
    }

    public static void setOtpCertChain(String url) {
        otpCertChain = JRadiusWiFiClient.trimString(url);
    }

    public static boolean getOtpTrustAnyCert() {
        return otpTrustAnyCert;
    }

    public static void setOtpTrustAnyCert(boolean trustAnyCert) {
        otpTrustAnyCert = trustAnyCert;
    }

    public static String getOtpProxyServer() {
        return JRadiusWiFiClient.nonNullString(otpProxyServer);
    }

    public static void setOtpProxyServer(String server) {
        otpProxyServer = JRadiusWiFiClient.trimString(server);
    }

    public static String getOtpProxyPort() {
        return otpProxyPort;
    }

    public static void setOtpProxyPort(String port) {
        String s = JRadiusWiFiClient.trimString(port);
        if (s != null) {
            otpProxyPort = s;
        }
    }

    public static boolean getOtpUseSSL() {
        return otpUseSSL;
    }

    public static void setOtpUseSSL(boolean useSSL) {
        otpUseSSL = useSSL;
    }

    public static boolean getSecureRoaming() {
        return secureRoaming;
    }

    public static void setSecureRoaming(boolean secure) {
        secureRoaming = secure;
    }

    public String getPrefixRealm() {
        return JRadiusWiFiClient.nonNullString(this.prefixRealm);
    }

    public void setPrefixRealm(String prefixRealm) {
        this.prefixRealm = JRadiusWiFiClient.trimString(prefixRealm);
    }

    public static String getBaseURL() {
        return JRadiusWiFiClient.nonNullString(baseURL);
    }

    public static void setBaseURL(String url) {
        baseURL = JRadiusWiFiClient.trimString(url);
    }

    public static String getLoginURL() {
        return JRadiusWiFiClient.nonNullString(loginURL);
    }

    public static void setLoginURL(String url) {
        loginURL = JRadiusWiFiClient.trimString(url);
    }

    public static String getNoWISPrURL() {
        return JRadiusWiFiClient.nonNullString(noWISPrURL);
    }

    public static void setNoWISPrURL(String url) {
        noWISPrURL = JRadiusWiFiClient.trimString(url);
    }

    public static String getOnlineURL() {
        return JRadiusWiFiClient.nonNullString(onlineURL);
    }

    public static void setOnlineURL(String url) {
        onlineURL = JRadiusWiFiClient.trimString(url);
    }

    public static String getPublicURL() {
        return JRadiusWiFiClient.nonNullString(publicURL);
    }

    public static void setPublicURL(String url) {
        publicURL = JRadiusWiFiClient.trimString(url);
    }

    public static String getWelcomeURL() {
        return JRadiusWiFiClient.nonNullString(welcomeURL);
    }

    public static void setWelcomeURL(String url) {
        welcomeURL = JRadiusWiFiClient.trimString(url);
    }

    public static String getDebugString() {
        return debugString.toString();
    }

    public static void clearDebugString() {
        debugString = new StringBuffer();
    }

    private static String nonNullString(String s) {
        if (s == null) {
            return "";
        }
        s = s.trim();
        return s;
    }

    private static String trimString(String s) {
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).length() == 0) {
            return null;
        }
        return s;
    }

    public boolean isOnline() {
        return isOnline;
    }

    public boolean isReady() {
        return isReady;
    }

    public boolean isJavaReady() {
        return isJavaReady;
    }

    public boolean isApplet() {
        return this.isApplet;
    }

    public void isApplet(boolean isApplet) {
        this.isApplet = isApplet;
    }

    public static String getTitleMatch() {
        return titleMatch;
    }

    public static void setTitleMatch(String titleMatch) {
        JRadiusWiFiClient.titleMatch = titleMatch;
    }

    static {
        client = null;
        clientThread = null;
        clientGUI = null;
        runLogout = false;
        copy = "---------------------------------------------------\n Running JRadius WiFi Client\n Copyright (c) 2010 Coova Technologies, LLC <support@coova.com>\n All Rights Reserved.\n--------------------------------------------------\n";
    }

    private class ControlThread
    extends Thread {
        private final Socket socket;
        private final BufferedWriter writer;
        private final BufferedReader reader;
        private String otpUsername;
        private String otpPassword;

        public ControlThread(String username) throws IOException, NoSuchAlgorithmException, KeyManagementException {
            SocketFactory fact = null;
            if (otpUseSSL) {
                SSLContext sslContext = SSLContext.getInstance("SSLv3");
                sslContext.init(null, new X509TrustManager[]{new X509TrustManager(){

                    public void checkClientTrusted(X509Certificate[] chain, String authType) {
                    }

                    public void checkServerTrusted(X509Certificate[] chain, String authType) {
                    }

                    public X509Certificate[] getAcceptedIssuers() {
                        return new X509Certificate[0];
                    }
                }}, null);
                fact = sslContext.getSocketFactory();
            } else {
                fact = SocketFactory.getDefault();
            }
            final SocketFactory factory = fact;
            if (JRadiusWiFiClient.this.haveJavaSecurity()) {
                this.socket = (Socket)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        try {
                            return factory.createSocket(InetAddress.getByName(otpProxyServer), Integer.parseInt(otpProxyPort));
                        }
                        catch (IOException e) {
                            return null;
                        }
                    }
                });
                if (this.socket == null) {
                    throw new IOException("could not connect to host " + otpProxyServer);
                }
            } else {
                this.socket = factory.createSocket(InetAddress.getByName(otpProxyServer), Integer.parseInt(otpProxyPort));
            }
            this.writer = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream()));
            this.writer.write(username);
            this.writer.write("\n");
            this.writer.flush();
            this.reader = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
            this.otpUsername = this.reader.readLine();
            this.otpPassword = this.reader.readLine();
        }

        public String getOtpPassword() {
            return this.otpPassword;
        }

        public String getOtpUsername() {
            return this.otpUsername;
        }

        public void run() {
            try {
                if (JRadiusWiFiClient.this.getUsername().startsWith("error:")) {
                    JRadiusWiFiClient.this.addItem(JRadiusWiFiClient.this.getUsername().replaceFirst("error:", ""));
                } else {
                    this.doEAP(this.socket, this.reader, this.writer);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private void doEAP(Socket socket, BufferedReader reader, BufferedWriter writer) throws Exception {
            this.writeBytes(writer, this.eapResponse(1, (byte)0, JRadiusWiFiClient.this.getUsername().getBytes()));
            byte[] reply = this.readBytes(reader);
            while (reply != null) {
                byte[] send = this.doEAP(reply);
                this.writeBytes(writer, send);
                reply = this.readBytes(reader);
            }
        }

        private byte[] doEAP(byte[] d) throws Exception {
            ByteBuffer bb = ByteBuffer.wrap(d);
            byte rtype = bb.get();
            byte id = bb.get();
            short dlen = bb.getShort();
            if (rtype != 1) {
                throw new Exception("Expecting an EAP-Request.. got code: " + rtype);
            }
            byte eapcode = 0;
            byte[] data = null;
            if (dlen > 4) {
                eapcode = bb.get();
                if ((dlen = (short)(dlen - 4 - 1)) > 0) {
                    data = new byte[dlen];
                    bb.get(data);
                }
            }
            if (eapcode == 1) {
                return this.eapResponse(1, id, JRadiusWiFiClient.this.getUsername().getBytes());
            }
            if (eapcode != 4) {
                return this.eapResponse(3, id, new byte[]{4});
            }
            return this.eapResponse(4, id, this.doEAPMD5(id, data));
        }

        public byte[] doEAPMD5(byte id, byte[] data) throws Exception {
            byte md5len = data[0];
            byte[] md5data = new byte[md5len];
            System.arraycopy(data, 1, md5data, 0, md5len);
            byte[] Response = new byte[17];
            Response[0] = 16;
            System.arraycopy(this.chapMD5(id, JRadiusWiFiClient.this.getPassword().getBytes(), md5data), 0, Response, 1, 16);
            return Response;
        }

        protected byte[] eapResponse(int type, byte id, byte[] data) {
            int length = 5;
            if (data != null) {
                length = (short)(length + data.length);
            }
            byte[] Response = new byte[length];
            Response[0] = 2;
            Response[1] = id;
            Response[2] = (byte)(length >> 8 & 0xFF);
            Response[3] = (byte)(length & 0xFF);
            Response[4] = (byte)(type & 0xFF);
            if (data != null) {
                System.arraycopy(data, 0, Response, 5, data.length);
            }
            return Response;
        }

        private void writeBytes(BufferedWriter writer, byte[] d) throws IOException {
            String s = Base64.encodeBytes(d, 8);
            JRadiusWiFiClient.this.debugWrite("Sending: " + s);
            writer.write("eap:");
            writer.write(s);
            writer.write("\n");
            writer.flush();
        }

        private byte[] readBytes(BufferedReader reader) throws IOException {
            String line = reader.readLine();
            if (line.startsWith("error:")) {
                JRadiusWiFiClient.this.addItem(line.substring(6));
                return null;
            }
            if (line.startsWith("eap:")) {
                String s = line.substring(4);
                JRadiusWiFiClient.this.debugWrite("Recv: " + s);
                return Base64.decode(s);
            }
            return null;
        }

        public byte[] chapMD5(byte id, byte[] Password, byte[] Challenge) throws Exception {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(id);
            md.update(Password, 0, Password.length);
            md.update(Challenge, 0, Challenge.length);
            return md.digest();
        }
    }
}

