/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.MulticastSocket;
import java.net.Socket;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.KeyManagementException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.security.cert.X509Certificate;
import javax.net.SocketFactory;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.X509TrustManager;

public class WISPrClient {
    private String DEFAULT_USER_AGENT = "WISPrClient [jradius.net] (" + System.getProperty("java.verrsion") + ")";
    private String userAgent;
    private String prefixRealm = null;
    private String username = null;
    private String realm = null;
    private String password = null;
    private String WISPrLogin = null;
    private String WISPrAbortLogin = null;
    private String WISPrLogoff = null;
    private String WISPrLocationName = null;
    private String[] WISPrXML = new String[2];
    private String cookie = null;
    private String loginResult;
    private String loginResultsUrl;
    private String replyMessage;
    private boolean secureRoaming = false;
    private String otpProxyServer = "ap.coova.org";
    private String otpProxyPort = "1810";
    private boolean otpUseSSL = true;
    private boolean otpTrustAnyCert = true;
    private String otpCertChain = null;
    private boolean isJavaReady = true;
    private boolean isReady = false;
    private boolean isOnline = false;
    public String publicURL = "http://www.microsoft.com/en/us/default.aspx";
    public String titleMatch = "Microsoft Corporation";
    public String welcomeURL = "Success!";
    public String onlineURL = "Online";
    public String loginURL = "";
    public String noWISPrURL = "";
    public String badWISPrURL = "";
    private StringBuffer debugString = new StringBuffer();
    private Boolean isCommunicator;
    private Boolean haveJavaSecurity = null;
    private SecurityManager securityManager;
    private String ENCODING = "utf-8";
    private String status = "Loading...";
    private Thread messageThread;
    MulticastSocket socket;
    InetAddress group;
    private String copy = " Running JRadius WiFi Client\n Copyright (c) 2007-2008 David Bird <david@coova.com>\n Copyright (c) 2005-2006 PicoPoint B.V.\n All Rights Reserved.\n";
    private StringBuffer sb;
    public static final int EAP_HEADERLEN = 4;
    public static final int EAP_REQUEST = 1;
    public static final int EAP_RESPONSE = 2;
    public static final int EAP_SUCCESS = 3;
    public static final int EAP_FAILURE = 4;
    public static final int EAP_IDENTITY = 1;
    public static final int EAP_NOTIFICATION = 2;
    public static final int EAP_NAK = 3;
    public static final int EAP_MD5 = 4;
    public static final int EAP_OTP = 5;
    public static final int EAP_GTC = 6;
    public static final int EAP_TLS = 13;
    public static final int EAP_LEAP = 17;
    public static final int EAP_SIM = 18;
    public static final int EAP_TTLS = 21;
    public static final int EAP_PEAP = 25;
    public static final int EAP_MSCHAPV2 = 26;
    public static final int EAP_CISCO_MSCHAPV2 = 29;
    public static final int EAP_TLV = 33;

    public void login(String username, String password) {
        if (username != null) {
            this.setUsername(username);
        }
        if (password != null) {
            this.setPassword(password);
        }
        this.doWISPrLogin();
    }

    public void logoff() {
        this.doWISPrLogoff();
    }

    public void init() {
        this.securityManager = System.getSecurityManager();
        if (this.isCommunicator()) {
            try {
                Class<?> privilegeManager = Class.forName("netscape.security.PrivilegeManager");
                Method enablePrivilege = privilegeManager.getMethod("enablePrivilege", String.class);
                enablePrivilege.invoke(null, "UniversalXPConnect");
                enablePrivilege.invoke(null, "UniversalConnect");
            }
            catch (Throwable privilegeManager) {}
        } else {
            try {
                Class<?> policyEngine = Class.forName("com.ms.security.PolicyEngine");
                Class<?> permissionID = Class.forName("com.ms.security.PermissionID");
                Method assertPermission = policyEngine.getMethod("assertPermission", permissionID);
                Field permId = permissionID.getField("NETIO");
                assertPermission.invoke(null, permId.get(null));
            }
            catch (Throwable policyEngine) {
                // empty catch block
            }
        }
        this.debugWrite("Version Info:\n" + System.getProperty("java.vendor") + " " + System.getProperty("java.version") + " running on " + System.getProperty("os.name") + " " + System.getProperty("os.version") + " " + System.getProperty("os.arch"));
        try {
            this.group = InetAddress.getByName("224.0.0.1");
            this.socket = new MulticastSocket(40401);
            this.socket.joinGroup(this.group);
            this.messageThread = new Thread(new Runnable(){
                boolean running = true;

                public void run() {
                    while (this.running) {
                        byte[] buf = new byte[256];
                        DatagramPacket packet = new DatagramPacket(buf, buf.length);
                        try {
                            WISPrClient.this.socket.receive(packet);
                            String received = new String(packet.getData());
                            WISPrClient.this.debugWrite("recieved: " + received);
                        }
                        catch (Exception e) {
                            WISPrClient.this.debugWrite("recieved: " + e.getMessage());
                            this.running = false;
                        }
                    }
                }
            });
            this.messageThread.start();
        }
        catch (Exception e) {
            this.debugWrite(e.getMessage());
        }
        this.findWISPrLogin(this.publicURL);
    }

    public void shutdown() {
        try {
            this.socket.leaveGroup(this.group);
            this.socket.close();
            this.messageThread.interrupt();
        }
        catch (Exception e) {
            this.debugWrite(e.getMessage());
        }
    }

    public void broadcastMessage(String message) {
        try {
            DatagramSocket socket = new DatagramSocket();
            InetAddress group = InetAddress.getByName("224.0.0.1");
            DatagramPacket packet = new DatagramPacket(message.getBytes(), message.length(), group, 40401);
            socket.send(packet);
            socket.close();
        }
        catch (Exception e) {
            this.debugWrite(e.getMessage());
        }
    }

    private void debugWrite(String msg) {
        if (this.sb == null) {
            this.sb = new StringBuffer();
        }
        this.sb.append(msg);
    }

    public String getDebug() {
        String s = this.sb.toString();
        this.sb = null;
        return s;
    }

    private void redirect(String page) {
        this.status = page;
    }

    private void setStatus(String s) {
        this.status = s;
    }

    public void checkStatus() {
        this.findWISPrLogin(this.publicURL);
    }

    public void findWISPrLogin(String url) {
        PageResult result = this.getPage(url, this.cookie);
        if (result == null) {
            return;
        }
        if (result.getIsXML() == 0) {
            String title = this.getXMLParam(result.getContent(), null, "title");
            if (title != null && this.titleMatch.equals(title)) {
                this.isOnline = true;
                this.redirect(this.onlineURL);
            }
        } else {
            String xml = this.WISPrXML[0] = result.getContent();
            this.debugWrite("Extracted WISPr XML:\n" + xml);
            String xmll = xml.toLowerCase();
            String responseCode = this.getXMLParam(xml, xmll, "responsecode");
            if (responseCode == null) {
                this.redirect(this.badWISPrURL);
                return;
            }
            if ("200".equals(responseCode)) {
                String nextUrl = this.getXMLParam(xml, xmll, "nexturl");
                if (nextUrl != null && !"".equals(nextUrl)) {
                    this.findWISPrLogin(nextUrl);
                } else {
                    this.redirect(this.badWISPrURL);
                }
            } else if ("201".equals(responseCode)) {
                String loginResultsURL = this.getXMLParam(xml, xmll, "loginresultsurl");
                if (loginResultsURL != null && !"".equals(loginResultsURL)) {
                    this.findWISPrLogin(loginResultsURL);
                } else {
                    this.redirect(this.badWISPrURL);
                }
            } else {
                this.WISPrLogin = this.getXMLParam(xml, xmll, "loginurl");
                this.WISPrAbortLogin = this.getXMLParam(xml, xmll, "abortloginurl");
                this.WISPrLocationName = this.getXMLParam(xml, xmll, "locationname");
                this.debugWrite("Extracted login URL from WISPr XML:\n" + this.WISPrLogin);
                this.debugWrite("Extracted abort URL from WISPr XML:\n" + this.WISPrAbortLogin);
                String msg = "Found WiFi Network";
                if (this.WISPrLogin != null) {
                    this.isReady = true;
                }
                this.status = this.WISPrLocationName != null ? this.WISPrLocationName.replaceAll("_", " ") : msg;
            }
        }
    }

    private void doWISPrLogin() {
        try {
            if (this.WISPrLogin == null) {
                return;
            }
            if (this.username.length() < 1) {
                throw new RuntimeException("Please enter username");
            }
            if (this.password.length() < 1) {
                throw new RuntimeException("Please enter username");
            }
            String wisprUsername = this.username;
            String wisprPassword = this.password;
            if (this.secureRoaming) {
                try {
                    ControlThread control = new ControlThread(this.username);
                    wisprUsername = control.getOtpUsername();
                    wisprPassword = control.getOtpPassword();
                    control.start();
                    System.out.println("Using OTP " + wisprUsername + "/" + wisprPassword);
                }
                catch (IOException ioe) {
                    System.err.println("Unable to secure username and password!");
                }
            }
            StringBuffer loginUrl = new StringBuffer(this.WISPrLogin);
            if (this.WISPrLogin.indexOf("?") > 0) {
                loginUrl.append("&");
            } else {
                loginUrl.append("?");
            }
            if (this.prefixRealm != null && this.prefixRealm.length() > 0) {
                wisprUsername = this.prefixRealm + "/" + wisprUsername;
            }
            loginUrl.append("UserName=").append(this.urlEncode(wisprUsername));
            loginUrl.append("&Password=").append(this.urlEncode(wisprPassword));
            String providerUrl = loginUrl.toString();
            this.debugWrite("Login using url " + providerUrl);
            this.redirect(this.processWISPrResponse(providerUrl));
        }
        catch (Exception rte) {
            this.debugWrite("Runtime Exception: " + rte.getMessage());
        }
    }

    private String processWISPrResponse(String url) {
        PageResult result = this.getPage(url, this.cookie);
        if (result.getIsXML() == 0) {
            this.debugWrite("Did not get WISPr XML in: " + result.getContent());
            return this.badWISPrURL;
        }
        String xml = this.WISPrXML[1] = result.getContent();
        this.debugWrite("Extracted WISPr XML:\n" + xml);
        String xmll = xml.toLowerCase();
        this.loginResult = this.getXMLParam(xml, xmll, "responsecode");
        this.loginResultsUrl = this.getXMLParam(xml, xmll, "loginresultsurl");
        this.replyMessage = this.getXMLParam(xml, xmll, "replymessage");
        this.WISPrLogoff = this.getXMLParam(xml, xmll, "logoffurl");
        if (this.loginResult == null) {
            return this.badWISPrURL;
        }
        if ("50".equals(this.loginResult)) {
            this.isOnline = true;
            this.status = this.replyMessage == null ? "Logged in" : this.replyMessage;
            this.debugWrite("Successful login: Redirecting user to " + this.welcomeURL);
            return this.welcomeURL;
        }
        if ("201".equals(this.loginResult)) {
            this.status = this.replyMessage == null ? "Logging in..." : this.replyMessage;
            this.debugWrite("Login pending: resultsUrl " + this.loginResultsUrl);
            return this.processWISPrResponse(this.loginResultsUrl);
        }
        this.status = this.replyMessage == null ? "Login failed" : this.replyMessage;
        return this.loginURL;
    }

    private void doWISPrLogoff() {
        if (this.WISPrLogoff == null || this.WISPrLogoff.trim().length() == 0) {
            return;
        }
        PageResult result = this.getPage(this.WISPrLogoff, this.cookie);
        if (result.getIsXML() == 1) {
            this.debugWrite("WISPr XML:\n" + result.getContent());
        } else {
            this.debugWrite("NO WISPr XML in:\n" + result.getContent());
        }
        this.checkStatus();
    }

    private PageResult getPage(final String urlString, final String cookieString) throws RuntimeException {
        if (this.haveJavaSecurity()) {
            PageResult result = (PageResult)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return WISPrClient.this.doGetPage(urlString, cookieString);
                }
            });
            return result;
        }
        return this.doGetPage(urlString, cookieString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PageResult doGetPage(String urlString, String cookieString) {
        StringBuffer sb = new StringBuffer();
        HttpURLConnection conn = null;
        String location = null;
        try {
            PageResult pageResult;
            String str;
            URL url = new URL(urlString);
            conn = (HttpURLConnection)url.openConnection();
            if (conn instanceof HttpsURLConnection) {
                HttpsURLConnection sconn = (HttpsURLConnection)conn;
                SSLContext sslContext = SSLContext.getInstance("SSL");
                sslContext.init(null, new X509TrustManager[]{new X509TrustManager(){

                    public void checkClientTrusted(X509Certificate[] chain, String authType) {
                    }

                    public void checkServerTrusted(X509Certificate[] chain, String authType) {
                    }

                    public X509Certificate[] getAcceptedIssuers() {
                        return new X509Certificate[0];
                    }
                }}, null);
                sconn.setSSLSocketFactory(sslContext.getSocketFactory());
                sconn.setHostnameVerifier(new HostnameVerifier(){

                    public boolean verify(String hostname, SSLSession session) {
                        return true;
                    }
                });
            }
            conn.setRequestProperty("User-Agent", this.getUserAgent());
            conn.setDoInput(true);
            conn.setDoOutput(true);
            conn.setUseCaches(false);
            conn.setInstanceFollowRedirects(false);
            conn.setReadTimeout(5000);
            conn.setConnectTimeout(7000);
            if (cookieString != null) {
                conn.setRequestProperty("Cookie", cookieString);
            }
            BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            int n = 1;
            boolean done = false;
            while (!done) {
                String headerKey = conn.getHeaderFieldKey(n);
                String headerVal = conn.getHeaderField(n);
                if (headerKey != null || headerVal != null) {
                    if (headerKey.equals("Location")) {
                        location = headerVal;
                    } else if (headerKey.equals("Set-Cookie")) {
                        this.cookie = headerVal;
                    }
                    System.out.println(headerKey + " = " + headerVal);
                } else {
                    done = true;
                }
                ++n;
            }
            while ((str = in.readLine()) != null) {
                sb.append(str + "\n");
            }
            in.close();
            String wisprXml = WISPrClient.getWISPrXML(sb.toString());
            if (wisprXml != null) {
                pageResult = new PageResult(wisprXml, 1);
                return pageResult;
            }
            if (location != null) {
                conn.disconnect();
                pageResult = this.doGetPage(location, this.cookie);
                return pageResult;
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            throw new RuntimeException("getPage: " + e.getClass().getName() + ":" + e.getMessage() + "...");
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("getPage: " + e.getClass().getName() + ":" + e.getMessage() + "...");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.isJavaReady = false;
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        return new PageResult(sb.toString(), 0);
    }

    private static String getWISPrXML(String responseHtml) throws RuntimeException {
        String htmll = responseHtml.toLowerCase();
        int WISPrStartIndex = htmll.indexOf("<wispaccessgatewayparam");
        int WISPrEndIndex = htmll.indexOf("</wispaccessgatewayparam>") + 25;
        if (WISPrStartIndex > 0) {
            return responseHtml.substring(WISPrStartIndex, WISPrEndIndex);
        }
        return null;
    }

    private String getXMLParam(String xml, String xmll, String tag) throws RuntimeException {
        if (xmll == null) {
            xmll = xml.toLowerCase();
        }
        int startIndex = xmll.indexOf("<" + tag + ">");
        int endIndex = xmll.indexOf("</" + tag + ">");
        if (startIndex > 0) {
            String res = this.urlDecode(xml.substring(startIndex += tag.length() + 2, endIndex));
            res = this.stringReplaceAll(res, "&amp;", "&");
            return res;
        }
        return null;
    }

    private String urlEncode(String s) {
        String res = s;
        try {
            res = URLEncoder.encode(s, this.ENCODING);
        }
        catch (NoSuchMethodError e) {
            res = URLEncoder.encode(s);
        }
        catch (Exception e) {
            res = URLEncoder.encode(s);
        }
        return res;
    }

    private String urlDecode(String s) {
        String res = s;
        try {
            res = URLDecoder.decode(s, this.ENCODING);
        }
        catch (NoSuchMethodError e) {
            res = URLDecoder.decode(s);
        }
        catch (Exception e) {
            res = URLDecoder.decode(s);
        }
        return res;
    }

    private String stringReplaceAll(String s, String find, String replace) {
        String result = null;
        try {
            result = s.replaceAll(find, replace);
        }
        catch (NoSuchMethodError e) {
            StringBuffer sb = new StringBuffer(s);
            int index = s.length();
            int offset = find.length();
            while ((index = s.lastIndexOf(find, index - 1)) > -1) {
                sb.replace(index, index + offset, replace);
            }
            result = sb.toString();
        }
        return result;
    }

    private boolean haveJavaSecurity() {
        if (this.haveJavaSecurity == null) {
            this.haveJavaSecurity = Boolean.FALSE;
            try {
                Class<?> t = Class.forName("java.security.PrivilegedAction");
                this.haveJavaSecurity = Boolean.TRUE;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.haveJavaSecurity;
    }

    private boolean isCommunicator() {
        if (this.isCommunicator == null) {
            this.isCommunicator = Boolean.FALSE;
            try {
                Class<?> t = Class.forName("netscape.security.UserDialogHelper");
                this.isCommunicator = Boolean.TRUE;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.isCommunicator;
    }

    public String getPassword() {
        return WISPrClient.nonNullString(this.password);
    }

    public void setPassword(String password) {
        this.password = WISPrClient.trimString(password);
    }

    public String getUsername() {
        return WISPrClient.nonNullString(this.username);
    }

    public void setUsername(String username) {
        this.username = WISPrClient.trimString(username);
    }

    public String getRealm() {
        return WISPrClient.nonNullString(this.realm);
    }

    public void setRealm(String realm) {
        this.realm = WISPrClient.trimString(realm);
    }

    public String getWISPrXML0() {
        return WISPrClient.nonNullString(this.WISPrXML[0]);
    }

    public String getWISPrXML1() {
        return WISPrClient.nonNullString(this.WISPrXML[1]);
    }

    public String getWISPrLocationName() {
        return WISPrClient.nonNullString(this.WISPrLocationName);
    }

    public String getWISPrLogin() {
        return WISPrClient.nonNullString(this.WISPrLogin);
    }

    public String getWISPrAbortLogin() {
        return WISPrClient.nonNullString(this.WISPrAbortLogin);
    }

    public String getWISPrLogoff() {
        return WISPrClient.nonNullString(this.WISPrLogoff);
    }

    public String getOtpCertChain() {
        return WISPrClient.nonNullString(this.otpCertChain);
    }

    public void setOtpCertChain(String url) {
        this.otpCertChain = WISPrClient.trimString(url);
    }

    public boolean getOtpTrustAnyCert() {
        return this.otpTrustAnyCert;
    }

    public void setOtpTrustAnyCert(boolean trustAnyCert) {
        this.otpTrustAnyCert = trustAnyCert;
    }

    public String getOtpProxyServer() {
        return WISPrClient.nonNullString(this.otpProxyServer);
    }

    public void setOtpProxyServer(String server) {
        this.otpProxyServer = WISPrClient.trimString(server);
    }

    public String getOtpProxyPort() {
        return this.otpProxyPort;
    }

    public void setOtpProxyPort(String port) {
        String s = WISPrClient.trimString(port);
        if (s != null) {
            this.otpProxyPort = s;
        }
    }

    public boolean getOtpUseSSL() {
        return this.otpUseSSL;
    }

    public void setOtpUseSSL(boolean useSSL) {
        this.otpUseSSL = useSSL;
    }

    public boolean getSecureRoaming() {
        return this.secureRoaming;
    }

    public void setSecureRoaming(boolean secure) {
        this.secureRoaming = secure;
    }

    public String getPrefixRealm() {
        return WISPrClient.nonNullString(this.prefixRealm);
    }

    public void setPrefixRealm(String prefixRealm) {
        this.prefixRealm = WISPrClient.trimString(prefixRealm);
    }

    public String getLoginURL() {
        return WISPrClient.nonNullString(this.loginURL);
    }

    public void setLoginURL(String url) {
        this.loginURL = WISPrClient.trimString(url);
    }

    public String getNoWISPrURL() {
        return WISPrClient.nonNullString(this.noWISPrURL);
    }

    public void setNoWISPrURL(String url) {
        this.noWISPrURL = WISPrClient.trimString(url);
    }

    public String getOnlineURL() {
        return WISPrClient.nonNullString(this.onlineURL);
    }

    public void setOnlineURL(String url) {
        this.onlineURL = WISPrClient.trimString(url);
    }

    public String getPublicURL() {
        return WISPrClient.nonNullString(this.publicURL);
    }

    public void setPublicURL(String url) {
        this.publicURL = WISPrClient.trimString(url);
    }

    public String getWelcomeURL() {
        return WISPrClient.nonNullString(this.welcomeURL);
    }

    public void setWelcomeURL(String url) {
        this.welcomeURL = WISPrClient.trimString(url);
    }

    public String getDebugString() {
        return this.debugString.toString();
    }

    public void clearDebugString() {
        this.debugString = new StringBuffer();
    }

    private static String nonNullString(String s) {
        if (s == null) {
            return "";
        }
        s = s.trim();
        return s;
    }

    private static String trimString(String s) {
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).length() == 0) {
            return null;
        }
        return s;
    }

    public boolean isOnline() {
        return this.isOnline;
    }

    public boolean isReady() {
        return this.isReady;
    }

    public boolean isJavaReady() {
        return this.isJavaReady;
    }

    public String getTitleMatch() {
        return this.titleMatch;
    }

    public void setTitleMatch(String titleMatch) {
        this.titleMatch = titleMatch;
    }

    public String getCopyright() {
        return this.copy;
    }

    public String getStatus() {
        return this.status;
    }

    public String getLoginResult() {
        return this.loginResult;
    }

    public String getLoginResultsUrl() {
        return this.loginResultsUrl;
    }

    public String getReplyMessage() {
        return this.replyMessage;
    }

    public String getUserAgent() {
        if (this.userAgent != null && this.userAgent.trim().length() > 0) {
            return this.userAgent;
        }
        return this.DEFAULT_USER_AGENT;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    private class ControlThread
    extends Thread {
        private final Socket socket;
        private final BufferedWriter writer;
        private final BufferedReader reader;
        private String otpUsername;
        private String otpPassword;

        public ControlThread(String username) throws IOException, NoSuchAlgorithmException, KeyManagementException {
            SocketFactory fact = null;
            if (WISPrClient.this.otpUseSSL) {
                SSLContext sslContext = SSLContext.getInstance("SSLv3");
                sslContext.init(null, new X509TrustManager[]{new X509TrustManager(){

                    public void checkClientTrusted(X509Certificate[] chain, String authType) {
                    }

                    public void checkServerTrusted(X509Certificate[] chain, String authType) {
                    }

                    public X509Certificate[] getAcceptedIssuers() {
                        return new X509Certificate[0];
                    }
                }}, null);
                fact = sslContext.getSocketFactory();
            } else {
                fact = SocketFactory.getDefault();
            }
            final SocketFactory factory = fact;
            if (WISPrClient.this.haveJavaSecurity()) {
                this.socket = (Socket)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        try {
                            return factory.createSocket(InetAddress.getByName(WISPrClient.this.otpProxyServer), Integer.parseInt(WISPrClient.this.otpProxyPort));
                        }
                        catch (IOException e) {
                            return null;
                        }
                    }
                });
                if (this.socket == null) {
                    throw new IOException("could not connect to host " + WISPrClient.this.otpProxyServer);
                }
            } else {
                this.socket = factory.createSocket(InetAddress.getByName(WISPrClient.this.otpProxyServer), Integer.parseInt(WISPrClient.this.otpProxyPort));
            }
            this.writer = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream()));
            this.writer.write(username);
            this.writer.write("\n");
            this.writer.flush();
            this.reader = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
            this.otpUsername = this.reader.readLine();
            this.otpPassword = this.reader.readLine();
        }

        public String getOtpPassword() {
            return this.otpPassword;
        }

        public String getOtpUsername() {
            return this.otpUsername;
        }

        public void run() {
            try {
                if (WISPrClient.this.getUsername().startsWith("error:")) {
                    WISPrClient.this.status = WISPrClient.this.getUsername().replaceFirst("error:", "");
                } else {
                    this.doEAP(this.socket, this.reader, this.writer);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private void doEAP(Socket socket, BufferedReader reader, BufferedWriter writer) throws Exception {
            this.writeBytes(writer, this.eapResponse(1, (byte)0, WISPrClient.this.getUsername().getBytes()));
            byte[] reply = this.readBytes(reader);
            while (reply != null) {
                byte[] send = this.doEAP(reply);
                this.writeBytes(writer, send);
                reply = this.readBytes(reader);
            }
        }

        private byte[] doEAP(byte[] d) throws Exception {
            ByteBuffer bb = ByteBuffer.wrap(d);
            byte rtype = bb.get();
            byte id = bb.get();
            short dlen = bb.getShort();
            if (rtype != 1) {
                throw new Exception("Expecting an EAP-Request.. got code: " + rtype);
            }
            byte eapcode = 0;
            byte[] data = null;
            if (dlen > 4) {
                eapcode = bb.get();
                if ((dlen = (short)(dlen - 4 - 1)) > 0) {
                    data = new byte[dlen];
                    bb.get(data);
                }
            }
            if (eapcode == 1) {
                return this.eapResponse(1, id, WISPrClient.this.getUsername().getBytes());
            }
            if (eapcode != 4) {
                return this.eapResponse(3, id, new byte[]{4});
            }
            return this.eapResponse(4, id, this.doEAPMD5(id, data));
        }

        public byte[] doEAPMD5(byte id, byte[] data) throws Exception {
            byte md5len = data[0];
            byte[] md5data = new byte[md5len];
            System.arraycopy(data, 1, md5data, 0, md5len);
            byte[] Response = new byte[17];
            Response[0] = 16;
            System.arraycopy(this.chapMD5(id, WISPrClient.this.getPassword().getBytes(), md5data), 0, Response, 1, 16);
            return Response;
        }

        protected byte[] eapResponse(int type, byte id, byte[] data) {
            int length = 5;
            if (data != null) {
                length = (short)(length + data.length);
            }
            byte[] Response = new byte[length];
            Response[0] = 2;
            Response[1] = id;
            Response[2] = (byte)(length >> 8 & 0xFF);
            Response[3] = (byte)(length & 0xFF);
            Response[4] = (byte)(type & 0xFF);
            if (data != null) {
                System.arraycopy(data, 0, Response, 5, data.length);
            }
            return Response;
        }

        private void writeBytes(BufferedWriter writer, byte[] d) throws IOException {
            String s = Base64.encodeBytes(d, 8);
            WISPrClient.this.debugWrite("Sending: " + s);
            writer.write("eap:");
            writer.write(s);
            writer.write("\n");
            writer.flush();
        }

        private byte[] readBytes(BufferedReader reader) throws IOException {
            String line = reader.readLine();
            if (line.startsWith("error:")) {
                WISPrClient.this.status = line.substring(6);
                return null;
            }
            if (line.startsWith("eap:")) {
                String s = line.substring(4);
                WISPrClient.this.debugWrite("Recv: " + s);
                return Base64.decode(s);
            }
            return null;
        }

        public byte[] chapMD5(byte id, byte[] Password, byte[] Challenge) throws Exception {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(id);
            md.update(Password, 0, Password.length);
            md.update(Challenge, 0, Challenge.length);
            return md.digest();
        }
    }
}

