/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.tls;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import net.jradius.tls.TlsUtils;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;

public class TlsMac {
    private long seqNo;
    private HMac mac;

    protected TlsMac(Digest digest, byte[] key_block, int offset, int len) {
        this.mac = new HMac(digest);
        KeyParameter param = new KeyParameter(key_block, offset, len);
        this.mac.init((CipherParameters)param);
        this.seqNo = 0L;
    }

    protected int getSize() {
        return this.mac.getMacSize();
    }

    protected byte[] calculateMac(short type, byte[] message, int offset, int len) {
        ByteArrayOutputStream bosMac = new ByteArrayOutputStream(13);
        try {
            TlsUtils.writeUint64(this.seqNo++, bosMac);
            TlsUtils.writeUint8(type, bosMac);
            TlsUtils.writeVersion(bosMac);
            TlsUtils.writeUint16(len, bosMac);
        }
        catch (IOException e) {
            throw new IllegalStateException("Internal error during mac calculation");
        }
        byte[] macHeader = bosMac.toByteArray();
        this.mac.update(macHeader, 0, macHeader.length);
        this.mac.update(message, offset, len);
        byte[] result = new byte[this.mac.getMacSize()];
        this.mac.doFinal(result, 0);
        return result;
    }
}

