/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.webservice;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import net.jradius.exception.RadiusException;
import net.jradius.handler.chain.JRCommand;
import net.jradius.log.RadiusLog;
import net.jradius.server.JRadiusEvent;
import net.jradius.server.ListenerRequest;
import net.jradius.server.Processor;
import net.jradius.server.TCPListenerRequest;
import net.jradius.webservice.WebServiceException;
import net.jradius.webservice.WebServiceRequest;
import net.jradius.webservice.WebServiceResponse;
import org.apache.commons.chain.Context;

public class WebServiceProcessor
extends Processor {
    protected static final byte[] newline = WebServiceProcessor.toHTTPBytes("\r\n");
    protected static final byte[] ctype = WebServiceProcessor.toHTTPBytes("Content-Type: text/xml\r\n");
    protected static final byte[] clength = WebServiceProcessor.toHTTPBytes("Content-Length: ");
    protected static final byte[] server = WebServiceProcessor.toHTTPBytes("Server: JRadius\r\n");
    protected static final byte[] conclose = WebServiceProcessor.toHTTPBytes("Connection: close\r\n");
    protected static final byte[] ok = WebServiceProcessor.toHTTPBytes(" 200 OK\r\n");
    protected static final byte[] found = WebServiceProcessor.toHTTPBytes(" 302 Found\r\n");
    protected static final byte[] unauthorized = WebServiceProcessor.toHTTPBytes(" 401 Unauthorized\r\n");
    private boolean wantClientCertificates = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processRequest(ListenerRequest listenerRequest) throws Exception {
        TCPListenerRequest tcpListenerRequest = (TCPListenerRequest)listenerRequest;
        Socket socket = tcpListenerRequest.getSocket();
        socket.setSoTimeout(15000);
        X509Certificate x509 = null;
        if (socket instanceof SSLSocket && this.wantClientCertificates) {
            SSLSocket sslSocket = (SSLSocket)socket;
            sslSocket.setWantClientAuth(true);
            try {
                Certificate cert;
                SSLSession sslSession = sslSocket.getSession();
                Certificate[] certs = sslSession.getPeerCertificates();
                if (certs != null && (cert = certs[0]) instanceof X509Certificate) {
                    x509 = (X509Certificate)cert;
                }
            }
            catch (Throwable sslSession) {
                // empty catch block
            }
        }
        WebServiceRequest request = null;
        OutputStream os = null;
        try {
            request = (WebServiceRequest)listenerRequest.getRequestEvent();
            request.setServerVariableMap(listenerRequest.getServerVariables());
            request.setCertificate(x509);
            request.setApplicationContext(this.getApplicationContext());
            this.processRequest(request);
            os = socket.getOutputStream();
            this.sendResponse(request, os);
        }
        finally {
            if (os != null) {
                try {
                    os.flush();
                }
                catch (Exception exception) {}
            }
            if (!tcpListenerRequest.isKeepAlive()) {
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (Exception exception) {}
                }
                socket.close();
            }
        }
    }

    protected void runHandlers(WebServiceRequest request) {
        RadiusLog.debug((String)("Processing WebServiceRequest: " + request.toString()));
        List handlers = this.getRequestHandlers();
        if (handlers == null) {
            return;
        }
        for (JRCommand handler : handlers) {
            boolean stop = false;
            try {
                if (!handler.doesHandle((JRadiusEvent)request) || !(stop = handler.execute((Context)request))) continue;
            }
            catch (WebServiceException e) {
                RadiusLog.error((String)e.getMessage(), (Throwable)((Object)e));
            }
            catch (RadiusException e) {
                RadiusLog.error((String)e.getMessage(), (Throwable)e);
            }
            catch (Throwable e) {
                RadiusLog.error((String)e.getMessage(), (Throwable)e);
            }
            break;
        }
    }

    protected void processRequest(WebServiceRequest request) {
        this.runHandlers(request);
    }

    private void sendResponse(WebServiceRequest request, OutputStream out) throws IOException {
        WebServiceResponse response = request.getResponse();
        if (response == null) {
            RadiusLog.error((String)("No response found for WebServiceRequest: " + request.toString()));
            this.writeBadRequest(out, request.getHttpVersion());
            return;
        }
        this.writeResponse(out, request.getHttpVersion(), response.getHeaders(), response.getContent(), response.getSendFile());
    }

    private void writeResponse(OutputStream writer, String httpVersion, Map headers, byte[] payload, File sendFile) throws IOException {
        boolean wroteCT = false;
        boolean wroteCL = false;
        writer.write(WebServiceProcessor.toHTTPBytes(httpVersion));
        if (headers.get("Location") != null) {
            writer.write(found);
        } else if (headers.get("WWW-Authenticate") != null) {
            writer.write(unauthorized);
        } else {
            writer.write(ok);
        }
        writer.write(server);
        writer.write(conclose);
        for (Map.Entry entry : headers.entrySet()) {
            String key = (String)entry.getKey();
            writer.write(WebServiceProcessor.toHTTPBytes(key));
            writer.write(WebServiceProcessor.toHTTPBytes(": "));
            writer.write(WebServiceProcessor.toHTTPBytes((String)entry.getValue()));
            writer.write(newline);
            if (key.equalsIgnoreCase("content-type")) {
                wroteCT = true;
                continue;
            }
            if (!key.equalsIgnoreCase("content-length")) continue;
            wroteCL = true;
        }
        if (!wroteCT) {
            writer.write(ctype);
        }
        if (!wroteCL) {
            long totalLength = payload == null ? 0L : (long)payload.length;
            long l = sendFile == null ? 0L : sendFile.length();
            writer.write(clength);
            writer.write(WebServiceProcessor.toHTTPBytes(Long.toString(totalLength += l)));
            writer.write(newline);
        }
        writer.write(newline);
        if (payload != null) {
            writer.write(payload);
        }
        if (sendFile != null) {
            int len;
            byte[] data = new byte[512];
            FileInputStream in = new FileInputStream(sendFile);
            do {
                if ((len = ((InputStream)in).read(data)) <= 0) continue;
                writer.write(data, 0, len);
            } while (len > 0);
            ((InputStream)in).close();
        }
    }

    private void writeBadRequest(OutputStream writer, String httpVersion) throws IOException {
        writer.write(WebServiceProcessor.toHTTPBytes(httpVersion));
        writer.write(WebServiceProcessor.toHTTPBytes(" 400 Bad Request"));
        writer.write(newline);
        writer.write(server);
        writer.write(newline);
        writer.write(WebServiceProcessor.toHTTPBytes("Invalid request"));
    }

    protected static byte[] toHTTPBytes(String text) {
        if (text == null) {
            text = "";
        }
        try {
            return text.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e.getMessage());
        }
    }
}

