/*
 * Decompiled with CFR 0.152.
 */
package com.pdfjet;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

class BMPImage {
    int w = 0;
    int h = 0;
    byte[] image;
    byte[] deflated;
    private int bpp;
    private byte[][] palette = null;
    private boolean r5g6b5;
    private static final int m10000000 = 128;
    private static final int m01000000 = 64;
    private static final int m00100000 = 32;
    private static final int m00010000 = 16;
    private static final int m00001000 = 8;
    private static final int m00000100 = 4;
    private static final int m00000010 = 2;
    private static final int m00000001 = 1;
    private static final int m11110000 = 240;
    private static final int m00001111 = 15;

    public BMPImage(InputStream inputStream) throws Exception {
        byte[] byArray = this.getBytes(inputStream, 2);
        if (byArray[0] == 66 && byArray[1] == 77 || byArray[0] == 66 && byArray[1] == 65 || byArray[0] == 67 && byArray[1] == 73 || byArray[0] == 67 && byArray[1] == 80 || byArray[0] == 73 && byArray[1] == 67 || byArray[0] == 80 && byArray[1] == 84) {
            this.skipNBytes(inputStream, 8);
            int n = this.readSignedInt(inputStream);
            int n2 = this.readSignedInt(inputStream);
            this.w = this.readSignedInt(inputStream);
            this.h = this.readSignedInt(inputStream);
            this.skipNBytes(inputStream, 2);
            this.bpp = this.read2BytesLE(inputStream);
            int n3 = this.readSignedInt(inputStream);
            if (this.bpp > 8) {
                this.r5g6b5 = n3 == 3;
                this.skipNBytes(inputStream, 20);
                if (n > 54) {
                    this.skipNBytes(inputStream, n - 54);
                }
            } else {
                this.skipNBytes(inputStream, 12);
                int n4 = this.readSignedInt(inputStream);
                if (n4 == 0) {
                    n4 = (int)Math.pow(2.0, this.bpp);
                }
                this.skipNBytes(inputStream, 4);
                this.parsePalette(inputStream, n4);
            }
        } else {
            throw new Exception("BMP data could not be parsed!");
        }
        this.parseData(inputStream);
    }

    /*
     * Unable to fully structure code
     */
    private void parseData(InputStream var1_1) throws Exception {
        this.image = new byte[this.w * this.h * 3];
        var2_2 = 4 * (int)Math.ceil((double)(this.bpp * this.w) / 32.0);
lbl3:
        // 3 sources

        try {
            for (var5_3 = 0; var5_3 < this.h; ++var5_3) {
                block14: {
                    var3_6 = this.getBytes(var1_1, var2_2);
                    switch (this.bpp) {
                        case 1: {
                            var3_6 = BMPImage.bit1to8(var3_6, this.w);
                            break;
                        }
                        case 4: {
                            var3_6 = BMPImage.bit4to8(var3_6, this.w);
                            break;
                        }
                        case 8: {
                            break;
                        }
                        case 16: {
                            if (this.r5g6b5) {
                                var3_6 = BMPImage.bit16to24(var3_6, this.w);
                                break;
                            }
                            var3_6 = BMPImage.bit16to24b(var3_6, this.w);
                            break;
                        }
                        case 24: {
                            break;
                        }
                        case 32: {
                            var3_6 = BMPImage.bit32to24(var3_6, this.w);
                            break;
                        }
                        default: {
                            throw new Exception("Can only parse 1 bit, 4bit, 8bit, 16bit, 24bit and 32bit images");
                        }
                    }
                    var4_7 = this.w * (this.h - var5_3 - 1) * 3;
                    if (this.palette == null) break block14;
                    for (var6_8 = 0; var6_8 < this.w; ++var6_8) {
                        this.image[var4_7++] = this.palette[var3_6[var6_8] < 0 ? var3_6[var6_8] + 256 : var3_6[var6_8]][2];
                        this.image[var4_7++] = this.palette[var3_6[var6_8] < 0 ? var3_6[var6_8] + 256 : var3_6[var6_8]][1];
                        this.image[var4_7++] = this.palette[var3_6[var6_8] < 0 ? var3_6[var6_8] + 256 : var3_6[var6_8]][0];
                    }
                    ** GOTO lbl3
                }
                for (var6_8 = 0; var6_8 < this.w * 3; var6_8 += 3) {
                    this.image[var4_7++] = var3_6[var6_8 + 2];
                    this.image[var4_7++] = var3_6[var6_8 + 1];
                    this.image[var4_7++] = var3_6[var6_8];
                }
                ** GOTO lbl3
            }
        }
        catch (ArrayIndexOutOfBoundsException var5_4) {
            throw new Exception("BMP parse error: imagedata not correct");
        }
        var5_5 = new ByteArrayOutputStream(32768);
        var6_9 = new DeflaterOutputStream((OutputStream)var5_5, new Deflater());
        var6_9.write(this.image, 0, this.image.length);
        var6_9.finish();
        this.deflated = var5_5.toByteArray();
    }

    private static byte[] bit16to24(byte[] byArray, int n) {
        byte[] byArray2 = new byte[n * 3];
        int n2 = 0;
        for (int i = 0; i < n * 2; i += 2) {
            byArray2[n2++] = (byte)((byArray[i] & 0x1F) << 3);
            byArray2[n2++] = (byte)(((byArray[i + 1] & 7) << 5) + ((byArray[i] & 0xE0) >> 3));
            byArray2[n2++] = (byte)(byArray[i + 1] & 0xF8);
        }
        return byArray2;
    }

    private static byte[] bit16to24b(byte[] byArray, int n) {
        byte[] byArray2 = new byte[n * 3];
        int n2 = 0;
        for (int i = 0; i < n * 2; i += 2) {
            byArray2[n2++] = (byte)((byArray[i] & 0x1F) << 3);
            byArray2[n2++] = (byte)(((byArray[i + 1] & 3) << 6) + ((byArray[i] & 0xE0) >> 2));
            byArray2[n2++] = (byte)((byArray[i + 1] & 0x7C) << 1);
        }
        return byArray2;
    }

    private static byte[] bit32to24(byte[] byArray, int n) {
        byte[] byArray2 = new byte[n * 3];
        int n2 = 0;
        for (int i = 0; i < n * 4; i += 4) {
            byArray2[n2++] = byArray[i + 1];
            byArray2[n2++] = byArray[i + 2];
            byArray2[n2++] = byArray[i + 3];
        }
        return byArray2;
    }

    private static byte[] bit4to8(byte[] byArray, int n) {
        byte[] byArray2 = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray2[i] = i % 2 == 0 ? (byte)((byArray[i / 2] & 0xF0) >> 4) : (byte)(byArray[i / 2] & 0xF);
        }
        return byArray2;
    }

    private static byte[] bit1to8(byte[] byArray, int n) {
        byte[] byArray2 = new byte[n];
        block10: for (int i = 0; i < n; ++i) {
            switch (i % 8) {
                case 0: {
                    byArray2[i] = (byte)((byArray[i / 8] & 0x80) >> 7);
                    continue block10;
                }
                case 1: {
                    byArray2[i] = (byte)((byArray[i / 8] & 0x40) >> 6);
                    continue block10;
                }
                case 2: {
                    byArray2[i] = (byte)((byArray[i / 8] & 0x20) >> 5);
                    continue block10;
                }
                case 3: {
                    byArray2[i] = (byte)((byArray[i / 8] & 0x10) >> 4);
                    continue block10;
                }
                case 4: {
                    byArray2[i] = (byte)((byArray[i / 8] & 8) >> 3);
                    continue block10;
                }
                case 5: {
                    byArray2[i] = (byte)((byArray[i / 8] & 4) >> 2);
                    continue block10;
                }
                case 6: {
                    byArray2[i] = (byte)((byArray[i / 8] & 2) >> 1);
                    continue block10;
                }
                case 7: {
                    byArray2[i] = (byte)(byArray[i / 8] & 1);
                }
            }
        }
        return byArray2;
    }

    private void parsePalette(InputStream inputStream, int n) throws Exception {
        this.palette = new byte[n][];
        for (int i = 0; i < n; ++i) {
            this.palette[i] = this.getBytes(inputStream, 4);
        }
    }

    private void skipNBytes(InputStream inputStream, int n) {
        try {
            this.getBytes(inputStream, n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private byte[] getBytes(InputStream inputStream, int n) throws Exception {
        byte[] byArray = new byte[n];
        inputStream.read(byArray, 0, byArray.length);
        return byArray;
    }

    private int read2BytesLE(InputStream inputStream) throws Exception {
        byte[] byArray = this.getBytes(inputStream, 2);
        int n = 0;
        n |= byArray[1] & 0xFF;
        n <<= 8;
        return n |= byArray[0] & 0xFF;
    }

    private int readSignedInt(InputStream inputStream) throws Exception {
        byte[] byArray = this.getBytes(inputStream, 4);
        long l = 0L;
        l |= (long)(byArray[3] & 0xFF);
        l <<= 8;
        l |= (long)(byArray[2] & 0xFF);
        l <<= 8;
        l |= (long)(byArray[1] & 0xFF);
        l <<= 8;
        return (int)(l |= (long)(byArray[0] & 0xFF));
    }

    public int getWidth() {
        return this.w;
    }

    public int getHeight() {
        return this.h;
    }

    public byte[] getData() {
        return this.deflated;
    }
}

