/*
 * Decompiled with CFR 0.152.
 */
package com.pdfjet;

import com.pdfjet.Destination;
import com.pdfjet.PDF;
import com.pdfjet.Page;
import com.pdfjet.TextLine;
import com.pdfjet.Title;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Bookmark {
    private int destNumber = 0;
    private Page page = null;
    private float y = 0.0f;
    private String key = null;
    private String title = null;
    private Bookmark parent = null;
    private Bookmark prev = null;
    private Bookmark next = null;
    private List<Bookmark> children = null;
    private Destination dest = null;
    protected int objNumber = 0;
    protected String prefix = null;

    public Bookmark(PDF pDF) {
        pDF.toc = this;
    }

    private Bookmark(Page page, float f, String string, String string2) {
        this.page = page;
        this.y = f;
        this.key = string;
        this.title = string2;
    }

    public Bookmark addBookmark(Page page, Title title) {
        return this.addBookmark(page, title.text.getY(), title.text.getText());
    }

    public Bookmark addBookmark(Page page, float f, String string) {
        Bookmark bookmark = this;
        while (bookmark.parent != null) {
            bookmark = bookmark.getParent();
        }
        String string2 = bookmark.next();
        Bookmark bookmark2 = new Bookmark(page, f, string2, string.replaceAll("\\s+", " "));
        bookmark2.parent = this;
        bookmark2.dest = page.addDestination(string2, f);
        if (this.children == null) {
            this.children = new ArrayList<Bookmark>();
        } else {
            bookmark2.prev = this.children.get(this.children.size() - 1);
            this.children.get((int)(this.children.size() - 1)).next = bookmark2;
        }
        this.children.add(bookmark2);
        return bookmark2;
    }

    public String getDestKey() {
        return this.key;
    }

    public String getTitle() {
        return this.title;
    }

    public Bookmark getParent() {
        return this.parent;
    }

    public Bookmark autoNumber(TextLine textLine) {
        Bookmark bookmark = this.getPrevBookmark();
        if (bookmark == null) {
            bookmark = this.getParent();
            this.prefix = bookmark.prefix == null ? "1" : bookmark.prefix + ".1";
        } else if (bookmark.prefix == null) {
            this.prefix = bookmark.getParent().prefix == null ? "1" : bookmark.getParent().prefix + ".1";
        } else {
            int n = bookmark.prefix.lastIndexOf(46);
            if (n == -1) {
                this.prefix = String.valueOf(Integer.valueOf(bookmark.prefix) + 1);
            } else {
                this.prefix = bookmark.prefix.substring(0, n) + ".";
                this.prefix = this.prefix + String.valueOf(Integer.valueOf(bookmark.prefix.substring(n + 1)) + 1);
            }
        }
        textLine.setText(this.prefix);
        this.title = this.prefix + " " + this.title;
        return this;
    }

    protected List<Bookmark> toArrayList() {
        int n = 0;
        ArrayList<Bookmark> arrayList = new ArrayList<Bookmark>();
        LinkedList<Bookmark> linkedList = new LinkedList<Bookmark>();
        linkedList.add(this);
        while (!linkedList.isEmpty()) {
            Bookmark bookmark = (Bookmark)linkedList.poll();
            bookmark.objNumber = n++;
            arrayList.add(bookmark);
            if (bookmark.getChildren() == null) continue;
            linkedList.addAll(bookmark.getChildren());
        }
        return arrayList;
    }

    protected List<Bookmark> getChildren() {
        return this.children;
    }

    protected Bookmark getPrevBookmark() {
        return this.prev;
    }

    protected Bookmark getNextBookmark() {
        return this.next;
    }

    protected Bookmark getFirstChild() {
        return this.children.get(0);
    }

    protected Bookmark getLastChild() {
        return this.children.get(this.children.size() - 1);
    }

    protected Destination getDestination() {
        return this.dest;
    }

    private String next() {
        ++this.destNumber;
        return "dest#" + String.valueOf(this.destNumber);
    }
}

