/*
 * Decompiled with CFR 0.152.
 */
package com.pdfjet;

import com.pdfjet.Annotation;
import com.pdfjet.CompositeTextLine;
import com.pdfjet.Font;
import com.pdfjet.Image;
import com.pdfjet.Page;
import com.pdfjet.Point;

public class Cell {
    protected Font font;
    protected Font fallbackFont;
    protected String text;
    protected Image image;
    protected Point point;
    protected CompositeTextLine compositeTextLine;
    protected float width = 70.0f;
    protected float top_padding = 2.0f;
    protected float bottom_padding = 2.0f;
    protected float left_padding = 2.0f;
    protected float right_padding = 2.0f;
    protected float lineWidth = 0.2f;
    private int background = -1;
    private int pen = 0;
    private int brush = 0;
    private int properties = 983041;
    private String uri;
    private int valign = 0x400000;

    public Cell(Font font) {
        this.font = font;
    }

    public Cell(Font font, String string) {
        this.font = font;
        this.text = string;
    }

    public Cell(Font font, Font font2, String string) {
        this.font = font;
        this.fallbackFont = font2;
        this.text = string;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public void setFallbackFont(Font font) {
        this.fallbackFont = font;
    }

    public Font getFont() {
        return this.font;
    }

    public Font getFallbackFont() {
        return this.fallbackFont;
    }

    public void setText(String string) {
        this.text = string;
    }

    public String getText() {
        return this.text;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public Image getImage() {
        return this.image;
    }

    public void setPoint(Point point) {
        this.point = point;
    }

    public Point getPoint() {
        return this.point;
    }

    public void setCompositeTextLine(CompositeTextLine compositeTextLine) {
        this.compositeTextLine = compositeTextLine;
    }

    public CompositeTextLine getCompositeTextLine() {
        return this.compositeTextLine;
    }

    public void setWidth(float f) {
        this.width = f;
    }

    public float getWidth() {
        return this.width;
    }

    public void setTopPadding(float f) {
        this.top_padding = f;
    }

    public void setBottomPadding(float f) {
        this.bottom_padding = f;
    }

    public void setLeftPadding(float f) {
        this.left_padding = f;
    }

    public void setRightPadding(float f) {
        this.right_padding = f;
    }

    public void setPadding(float f) {
        this.top_padding = f;
        this.bottom_padding = f;
        this.left_padding = f;
        this.right_padding = f;
    }

    public float getHeight() {
        if (this.image != null) {
            return this.image.getHeight() + this.top_padding + this.bottom_padding;
        }
        return this.font.body_height + this.top_padding + this.bottom_padding;
    }

    public void setLineWidth(float f) {
        this.lineWidth = f;
    }

    public float getLineWidth() {
        return this.lineWidth;
    }

    public void setBgColor(int n) {
        this.background = n;
    }

    public int getBgColor() {
        return this.background;
    }

    public void setPenColor(int n) {
        this.pen = n;
    }

    public int getPenColor() {
        return this.pen;
    }

    public void setBrushColor(int n) {
        this.brush = n;
    }

    public int getBrushColor() {
        return this.brush;
    }

    public void setFgColor(int n) {
        this.pen = n;
        this.brush = n;
    }

    protected void setProperties(int n) {
        this.properties = n;
    }

    protected int getProperties() {
        return this.properties;
    }

    public void setColSpan(int n) {
        this.properties &= 0xFF0000;
        this.properties |= n & 0xFFFF;
    }

    public int getColSpan() {
        return this.properties & 0xFFFF;
    }

    public void setBorder(int n, boolean bl) {
        this.properties = bl ? (this.properties |= n) : (this.properties &= ~n & 0xFFFFFF);
    }

    public boolean getBorder(int n) {
        return (this.properties & n) != 0;
    }

    public void setNoBorders() {
        this.properties &= 0xF0FFFF;
    }

    public void setTextAlignment(int n) {
        this.properties &= 0xCFFFFF;
        this.properties |= n & 0x300000;
    }

    public int getTextAlignment() {
        return this.properties & 0x300000;
    }

    public void setVerTextAlignment(int n) {
        this.valign = n;
    }

    public int getVerTextAlignment() {
        return this.valign;
    }

    public void setUnderline(boolean bl) {
        this.properties = bl ? (this.properties |= 0x400000) : (this.properties &= 0xBFFFFF);
    }

    public boolean getUnderline() {
        return (this.properties & 0x400000) != 0;
    }

    public void setStrikeout(boolean bl) {
        this.properties = bl ? (this.properties |= 0x800000) : (this.properties &= 0x7FFFFF);
    }

    public boolean getStrikeout() {
        return (this.properties & 0x800000) != 0;
    }

    public void setURIAction(String string) {
        this.uri = string;
    }

    protected void paint(Page page, float f, float f2, float f3, float f4) throws Exception {
        if (this.background != -1) {
            this.drawBackground(page, f, f2, f3, f4);
        }
        if (this.image != null) {
            this.image.setLocation(f + this.left_padding, f2 + this.top_padding);
            this.image.drawOn(page);
        }
        this.drawBorders(page, f, f2, f3, f4);
        if (this.text != null) {
            this.drawText(page, f, f2, f3, f4);
        }
        if (this.point != null) {
            if (this.point.align == 0) {
                this.point.x = f + 2.0f * this.point.r;
            } else if (this.point.align == 0x200000) {
                this.point.x = f + f3 - this.right_padding / 2.0f;
            }
            this.point.y = f2 + f4 / 2.0f;
            page.setBrushColor(this.point.getColor());
            if (this.point.getURIAction() != null) {
                page.addAnnotation(new Annotation(this.point.getURIAction(), null, this.point.x - this.point.r, page.height - (this.point.y - this.point.r), this.point.x + this.point.r, page.height - (this.point.y + this.point.r), null, null, null));
            }
            page.drawPoint(this.point);
        }
    }

    private void drawBackground(Page page, float f, float f2, float f3, float f4) throws Exception {
        page.setBrushColor(this.background);
        page.fillRect(f, f2, f3, f4);
    }

    private void drawBorders(Page page, float f, float f2, float f3, float f4) throws Exception {
        page.setPenColor(this.pen);
        page.setPenWidth(this.lineWidth);
        if (this.getBorder(65536) && this.getBorder(131072) && this.getBorder(262144) && this.getBorder(524288)) {
            page.addBMC("Span", " ", " ");
            page.drawRect(f, f2, f3, f4);
            page.addEMC();
        } else {
            if (this.getBorder(65536)) {
                page.addBMC("Span", " ", " ");
                page.moveTo(f, f2);
                page.lineTo(f + f3, f2);
                page.strokePath();
                page.addEMC();
            }
            if (this.getBorder(131072)) {
                page.addBMC("Span", " ", " ");
                page.moveTo(f, f2 + f4);
                page.lineTo(f + f3, f2 + f4);
                page.strokePath();
                page.addEMC();
            }
            if (this.getBorder(262144)) {
                page.addBMC("Span", " ", " ");
                page.moveTo(f, f2);
                page.lineTo(f, f2 + f4);
                page.strokePath();
                page.addEMC();
            }
            if (this.getBorder(524288)) {
                page.addBMC("Span", " ", " ");
                page.moveTo(f + f3, f2);
                page.lineTo(f + f3, f2 + f4);
                page.strokePath();
                page.addEMC();
            }
        }
    }

    private void drawText(Page page, float f, float f2, float f3, float f4) throws Exception {
        float f5;
        float f6;
        if (this.valign == 0x400000) {
            f6 = f2 + this.font.ascent + this.top_padding;
        } else if (this.valign == 0x100000) {
            f6 = f2 + f4 / 2.0f + this.font.ascent / 2.0f;
        } else if (this.valign == 0x500000) {
            f6 = f2 + f4 - this.bottom_padding;
        } else {
            throw new Exception("Invalid vertical text alignment option.");
        }
        page.setPenColor(this.pen);
        page.setBrushColor(this.brush);
        if (this.getTextAlignment() == 0x200000) {
            if (this.compositeTextLine == null) {
                f5 = f + f3 - (this.font.stringWidth(this.text) + this.right_padding);
                page.addBMC("Span", this.text, this.text);
                page.drawString(this.font, this.fallbackFont, this.text, f5, f6);
                page.addEMC();
                if (this.getUnderline()) {
                    this.underlineText(page, this.font, this.text, f5, f6);
                }
                if (this.getStrikeout()) {
                    this.strikeoutText(page, this.font, this.text, f5, f6);
                }
            } else {
                f5 = f + f3 - (this.compositeTextLine.getWidth() + this.right_padding);
                this.compositeTextLine.setPosition(f5, f6);
                page.addBMC("Span", this.text, this.text);
                this.compositeTextLine.drawOn(page);
                page.addEMC();
            }
        } else if (this.getTextAlignment() == 0x100000) {
            if (this.compositeTextLine == null) {
                f5 = f + this.left_padding + (f3 - (this.left_padding + this.right_padding) - this.font.stringWidth(this.text)) / 2.0f;
                page.addBMC("Span", this.text, this.text);
                page.drawString(this.font, this.fallbackFont, this.text, f5, f6);
                page.addEMC();
                if (this.getUnderline()) {
                    this.underlineText(page, this.font, this.text, f5, f6);
                }
                if (this.getStrikeout()) {
                    this.strikeoutText(page, this.font, this.text, f5, f6);
                }
            } else {
                f5 = f + this.left_padding + (f3 - (this.left_padding + this.right_padding) - this.compositeTextLine.getWidth()) / 2.0f;
                this.compositeTextLine.setPosition(f5, f6);
                page.addBMC("Span", this.text, this.text);
                this.compositeTextLine.drawOn(page);
                page.addEMC();
            }
        } else if (this.getTextAlignment() == 0) {
            f5 = f + this.left_padding;
            if (this.compositeTextLine == null) {
                page.addBMC("Span", this.text, this.text);
                page.drawString(this.font, this.fallbackFont, this.text, f5, f6);
                page.addEMC();
                if (this.getUnderline()) {
                    this.underlineText(page, this.font, this.text, f5, f6);
                }
                if (this.getStrikeout()) {
                    this.strikeoutText(page, this.font, this.text, f5, f6);
                }
            } else {
                this.compositeTextLine.setPosition(f5, f6);
                page.addBMC("Span", this.text, this.text);
                this.compositeTextLine.drawOn(page);
                page.addEMC();
            }
        } else {
            throw new Exception("Invalid Text Alignment!");
        }
        if (this.uri != null) {
            float f7 = this.compositeTextLine != null ? this.compositeTextLine.getWidth() : this.font.stringWidth(this.text);
            page.addAnnotation(new Annotation(this.uri, null, f5, page.height - f6 + this.font.descent, f5 + f7, page.height - f6 + this.font.ascent, null, null, null));
        }
    }

    private void underlineText(Page page, Font font, String string, float f, float f2) throws Exception {
        page.addBMC("Span", "underline", "underline");
        float f3 = font.getDescent();
        page.setPenWidth(font.underlineThickness);
        page.moveTo(f, f2 + f3);
        page.lineTo(f + font.stringWidth(string), f2 + f3);
        page.strokePath();
        page.addEMC();
    }

    private void strikeoutText(Page page, Font font, String string, float f, float f2) throws Exception {
        page.addBMC("Span", "strike out", "strike out");
        page.setPenWidth(font.underlineThickness);
        page.moveTo(f, f2 - font.getAscent() / 3.0f);
        page.lineTo(f + font.stringWidth(string), f2 - font.getAscent() / 3.0f);
        page.strokePath();
        page.addEMC();
    }

    public int getNumVerCells() {
        int n = 1;
        if (this.getText() == null) {
            return n;
        }
        String[] stringArray = this.getText().split("\\r?\\n");
        if (stringArray.length == 0) {
            return n;
        }
        n = 0;
        for (String string : stringArray) {
            String[] stringArray2 = string.split("\\s+");
            StringBuilder stringBuilder = new StringBuilder();
            if (stringArray2.length > 1) {
                for (int i = 0; i < stringArray2.length; ++i) {
                    String string2 = stringArray2[i];
                    StringBuilder stringBuilder2 = new StringBuilder();
                    if (this.font.stringWidth(stringBuilder2.append(stringBuilder.toString()).append(" ").append(string2).toString()) > this.getWidth() - (this.left_padding + this.right_padding)) {
                        stringBuilder = new StringBuilder(string2);
                        ++n;
                        continue;
                    }
                    if (i > 0) {
                        stringBuilder.append(" ");
                    }
                    stringBuilder.append(string2);
                }
            }
            ++n;
        }
        return n;
    }

    public int getNumVerCells2() {
        int n = 1;
        if (this.getText() == null) {
            return n;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.text.length(); ++i) {
            String string = new String(new char[]{this.text.charAt(i)});
            StringBuilder stringBuilder2 = new StringBuilder();
            if (this.font.stringWidth(stringBuilder2.append(stringBuilder.toString()).append(string).toString()) > this.getWidth() - (this.left_padding + this.right_padding)) {
                ++n;
                stringBuilder.setLength(0);
            }
            stringBuilder.append(string);
        }
        return n;
    }
}

