/*
 * Decompiled with CFR 0.152.
 */
package com.pdfjet;

import com.pdfjet.Annotation;
import com.pdfjet.Drawable;
import com.pdfjet.Font;
import com.pdfjet.Page;

public class CheckBox
implements Drawable {
    private float x;
    private float y;
    private float w;
    private float h;
    private int boxColor = 0;
    private int checkColor = 0;
    private float penWidth;
    private float checkWidth;
    private int mark = 0;
    private Font font = null;
    private String label = "";
    private String uri = null;
    private String language = null;
    private String altDescription = " ";
    private String actualText = " ";

    public CheckBox(Font font, String string) {
        this.font = font;
        this.label = string;
    }

    public CheckBox setFontSize(float f) {
        this.font.setSize(f);
        return this;
    }

    public CheckBox setBoxColor(int n) {
        this.boxColor = n;
        return this;
    }

    public CheckBox setCheckmark(int n) {
        this.checkColor = n;
        return this;
    }

    public CheckBox setPosition(float f, float f2) {
        return this.setLocation(f, f2);
    }

    public CheckBox setLocation(float f, float f2) {
        this.x = f;
        this.y = f2;
        return this;
    }

    public float getHeight() {
        return this.h;
    }

    public float getWidth() {
        return this.w;
    }

    public CheckBox check(int n) {
        this.mark = n;
        return this;
    }

    public CheckBox setURIAction(String string) {
        this.uri = string;
        return this;
    }

    public CheckBox setAltDescription(String string) {
        this.altDescription = string;
        return this;
    }

    public CheckBox setActualText(String string) {
        this.actualText = string;
        return this;
    }

    public float[] drawOn(Page page) throws Exception {
        page.addBMC("Span", this.language, this.altDescription, this.actualText);
        this.h = this.w = this.font.getAscent();
        this.penWidth = this.w / 15.0f;
        this.checkWidth = this.w / 5.0f;
        float f = this.y - this.font.getAscent();
        page.setPenWidth(this.penWidth);
        page.setPenColor(this.boxColor);
        page.setLinePattern("[] 0");
        page.drawRect(this.x, f, this.w, this.h);
        if (this.mark == 1 || this.mark == 2) {
            page.setPenWidth(this.checkWidth);
            page.setPenColor(this.checkColor);
            if (this.mark == 1) {
                page.moveTo(this.x + this.checkWidth, f + this.h / 2.0f);
                page.lineTo(this.x + this.w / 6.0f + this.checkWidth, f + this.h - 4.0f * this.checkWidth / 3.0f);
                page.lineTo(this.x + this.w - this.checkWidth, f + this.checkWidth);
                page.strokePath();
            } else if (this.mark == 2) {
                page.moveTo(this.x + this.checkWidth, f + this.checkWidth);
                page.lineTo(this.x + this.w - this.checkWidth, f + this.h - this.checkWidth);
                page.moveTo(this.x + this.w - this.checkWidth, f + this.checkWidth);
                page.lineTo(this.x + this.checkWidth, f + this.h - this.checkWidth);
                page.strokePath();
            }
        }
        if (this.uri != null) {
            page.setBrushColor(255);
        }
        page.drawString(this.font, this.label, this.x + 3.0f * this.w / 2.0f, this.y);
        page.setPenWidth(0.0f);
        page.setPenColor(0);
        page.setBrushColor(0);
        page.addEMC();
        if (this.uri != null) {
            page.addAnnotation(new Annotation(this.uri, null, this.x + 3.0f * this.w / 2.0f, page.height - this.y, this.x + 3.0f * this.w / 2.0f + this.font.stringWidth(this.label), page.height - (this.y - this.font.getAscent()), this.language, this.altDescription, this.actualText));
        }
        return new float[]{this.x + 3.0f * this.w + this.font.stringWidth(this.label), this.y + this.font.getDescent()};
    }
}

