/*
 * Decompiled with CFR 0.152.
 */
package com.pdfjet;

import com.pdfjet.Drawable;
import com.pdfjet.Page;
import com.pdfjet.TextLine;
import java.util.ArrayList;
import java.util.List;

public class CompositeTextLine
implements Drawable {
    private static final int X = 0;
    private static final int Y = 1;
    private List<TextLine> textLines = new ArrayList<TextLine>();
    private float[] position = new float[2];
    private float[] current = new float[2];
    private float subscript_size_factor = 0.583f;
    private float superscript_size_factor = 0.583f;
    private float superscript_position = 0.35f;
    private float subscript_position = 0.141f;
    private float fontSize = 12.0f;

    public CompositeTextLine(float f, float f2) {
        this.position[0] = f;
        this.position[1] = f2;
        this.current[0] = f;
        this.current[1] = f2;
    }

    public void setFontSize(float f) {
        this.fontSize = f;
    }

    public float getFontSize() {
        return this.fontSize;
    }

    public void setSuperscriptFactor(float f) {
        this.superscript_size_factor = f;
    }

    public float getSuperscriptFactor() {
        return this.superscript_size_factor;
    }

    public void setSubscriptFactor(float f) {
        this.subscript_size_factor = f;
    }

    public float getSubscriptFactor() {
        return this.subscript_size_factor;
    }

    public void setSuperscriptPosition(float f) {
        this.superscript_position = f;
    }

    public float getSuperscriptPosition() {
        return this.superscript_position;
    }

    public void setSubscriptPosition(float f) {
        this.subscript_position = f;
    }

    public float getSubscriptPosition() {
        return this.subscript_position;
    }

    public void addComponent(TextLine textLine) {
        if (textLine.getTextEffect() == 2) {
            textLine.getFont().setSize(this.fontSize * this.superscript_size_factor);
            textLine.setPosition(this.current[0], this.current[1] - this.fontSize * this.superscript_position);
        } else if (textLine.getTextEffect() == 1) {
            textLine.getFont().setSize(this.fontSize * this.subscript_size_factor);
            textLine.setPosition(this.current[0], this.current[1] + this.fontSize * this.subscript_position);
        } else {
            textLine.getFont().setSize(this.fontSize);
            textLine.setPosition(this.current[0], this.current[1]);
        }
        this.current[0] = this.current[0] + textLine.getWidth();
        this.textLines.add(textLine);
    }

    public void setPosition(double d, double d2) {
        this.setPosition((float)d, (float)d2);
    }

    public void setPosition(float f, float f2) {
        this.setLocation(f, f2);
    }

    public void setLocation(float f, float f2) {
        this.position[0] = f;
        this.position[1] = f2;
        this.current[0] = f;
        this.current[1] = f2;
        if (this.textLines == null) {
            return;
        }
        int n = this.textLines.size();
        if (n == 0) {
            return;
        }
        for (TextLine textLine : this.textLines) {
            if (textLine.getTextEffect() == 2) {
                textLine.setPosition(this.current[0], this.current[1] - this.fontSize * this.superscript_position);
            } else if (textLine.getTextEffect() == 1) {
                textLine.setPosition(this.current[0], this.current[1] + this.fontSize * this.subscript_position);
            } else {
                textLine.setPosition(this.current[0], this.current[1]);
            }
            this.current[0] = this.current[0] + textLine.getWidth();
        }
    }

    public float[] getPosition() {
        return this.position;
    }

    public TextLine getTextLine(int n) {
        if (this.textLines == null) {
            return null;
        }
        int n2 = this.textLines.size();
        if (n2 == 0) {
            return null;
        }
        if (n < 0 || n > n2 - 1) {
            return null;
        }
        return this.textLines.get(n);
    }

    public int getNumberOfTextLines() {
        return this.textLines.size();
    }

    public float[] getMinMax() {
        float f = this.position[1];
        float f2 = this.position[1];
        for (TextLine textLine : this.textLines) {
            float f3;
            if (textLine.getTextEffect() == 2) {
                f3 = this.position[1] - textLine.getFont().ascent - this.fontSize * this.superscript_position;
                if (!(f3 < f)) continue;
                f = f3;
                continue;
            }
            if (textLine.getTextEffect() == 1) {
                f3 = this.position[1] - textLine.getFont().descent + this.fontSize * this.subscript_position;
                if (!(f3 > f2)) continue;
                f2 = f3;
                continue;
            }
            f3 = this.position[1] - textLine.getFont().ascent;
            if (f3 < f) {
                f = f3;
            }
            if (!((f3 = this.position[1] - textLine.getFont().descent) > f2)) continue;
            f2 = f3;
        }
        return new float[]{f, f2};
    }

    public float getHeight() {
        float[] fArray = this.getMinMax();
        return fArray[1] - fArray[0];
    }

    public float getWidth() {
        return this.current[0] - this.position[0];
    }

    public float[] drawOn(Page page) throws Exception {
        float f = 0.0f;
        float f2 = 0.0f;
        for (TextLine textLine : this.textLines) {
            float[] fArray = textLine.drawOn(page);
            f = Math.max(f, fArray[0]);
            f2 = Math.max(f2, fArray[1]);
        }
        return new float[]{f, f2};
    }
}

