/*
 * Decompiled with CFR 0.152.
 */
package com.pdfjet;

import com.pdfjet.Box;
import com.pdfjet.Drawable;
import com.pdfjet.Field;
import com.pdfjet.Font;
import com.pdfjet.Line;
import com.pdfjet.Page;
import com.pdfjet.TextLine;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Form
implements Drawable {
    private List<Field> fields;
    private float x;
    private float y;
    private Font f1;
    private float labelFontSize = 8.0f;
    private Font f2;
    private float valueFontSize = 10.0f;
    private int numberOfRows;
    private float rowLength = 500.0f;
    private float rowHeight = 12.0f;
    private int labelColor = 0;
    private int valueColor = 255;
    private List<float[]> endOfLinePoints;

    public Form(List<Field> list) {
        this.fields = list;
        this.endOfLinePoints = new ArrayList<float[]>();
    }

    public Form setLocation(float f, float f2) {
        this.x = f;
        this.y = f2;
        return this;
    }

    public Form setRowLength(float f) {
        this.rowLength = f;
        return this;
    }

    public Form setRowHeight(float f) {
        this.rowHeight = f;
        return this;
    }

    public Form setLabelFont(Font font) {
        this.f1 = font;
        return this;
    }

    public Form setLabelFontSize(float f) {
        this.labelFontSize = f;
        return this;
    }

    public Form setValueFont(Font font) {
        this.f2 = font;
        return this;
    }

    public Form setValueFontSize(float f) {
        this.valueFontSize = f;
        return this;
    }

    public Form setLabelColor(int n) {
        this.labelColor = n;
        return this;
    }

    public Form setValueColor(int n) {
        this.valueColor = n;
        return this;
    }

    public List<float[]> getEndOfLinePoints() {
        return this.endOfLinePoints;
    }

    @Override
    public float[] drawOn(Page page) throws Exception {
        for (Field object2 : this.fields) {
            if (object2.format) {
                object2.values = Form.format(object2.values[0], object2.values[1], this.f2, this.rowLength);
                object2.altDescription = new String[object2.values.length];
                object2.actualText = new String[object2.values.length];
                for (int f2 = 0; f2 < object2.values.length; ++f2) {
                    object2.altDescription[f2] = object2.values[f2];
                    object2.actualText[f2] = object2.values[f2];
                }
            }
            if (object2.x != 0.0f) continue;
            this.numberOfRows += object2.values.length;
        }
        if (this.numberOfRows == 0) {
            return new float[]{this.x, this.y};
        }
        float f = this.rowHeight * (float)this.numberOfRows;
        Box box = new Box();
        box.setLocation(this.x, this.y);
        box.setSize(this.rowLength, f);
        box.drawOn(page);
        float f2 = 0.0f;
        int n = 1;
        float f3 = 0.0f;
        for (Field field : this.fields) {
            if (field.x == 0.0f) {
                f3 += (float)n * this.rowHeight;
                n = field.values.length;
            }
            f2 = f3;
            for (int i = 0; i < field.values.length; ++i) {
                Font font = i == 0 ? this.f1 : this.f2;
                float f4 = i == 0 ? this.labelFontSize : this.valueFontSize;
                int n2 = i == 0 ? this.labelColor : this.valueColor;
                new TextLine(font, field.values[i]).setFontSize(f4).setColor(n2).placeIn(box, field.x + this.f1.getDescent(), f2 - font.getDescent()).setAltDescription(i == 0 ? field.altDescription[i] : field.altDescription[i] + ",").setActualText(i == 0 ? field.actualText[i] : field.actualText[i] + ",").drawOn(page);
                this.endOfLinePoints.add(new float[]{field.x + this.f1.getDescent() + font.stringWidth(field.values[i]), f2 - font.getDescent()});
                if (i == field.values.length - 1) {
                    new Line(0.0f, 0.0f, this.rowLength, 0.0f).placeIn(box, 0.0f, f2).drawOn(page);
                    if (field.x != 0.0f) {
                        new Line(0.0f, (float)(-(field.values.length - 1)) * this.rowHeight, 0.0f, 0.0f).placeIn(box, field.x, f2).drawOn(page);
                    }
                }
                f2 += this.rowHeight;
            }
        }
        return new float[]{this.x + this.rowLength, this.y + f};
    }

    public static String[] format(String string, String string2, Font font, float f) {
        int n;
        Object object;
        int n2;
        String[] stringArray = string2.split("\\r?\\n");
        ArrayList<Object> arrayList = new ArrayList<Object>();
        StringBuilder stringBuilder = new StringBuilder();
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            object = stringArray[n2];
            if (font.stringWidth((String)object) < f) {
                arrayList.add(object);
                continue;
            }
            stringBuilder.setLength(0);
            for (n = 0; n < object.length(); ++n) {
                stringBuilder.append(object.charAt(n));
                if (!(font.stringWidth(stringBuilder.toString()) > f - font.stringWidth("   "))) continue;
                while (n > 0 && object.charAt(n) != ' ') {
                    --n;
                }
                String string3 = object.substring(0, n).replaceAll("\\s+$", "");
                arrayList.add(string3);
                stringBuilder.setLength(0);
                while (n < object.length() && object.charAt(n) == ' ') {
                    ++n;
                }
                object = object.substring(n);
                n = 0;
            }
            if (object.equals("")) continue;
            arrayList.add(object);
        }
        n2 = arrayList.size();
        object = new String[1 + n2];
        object[0] = string;
        for (n = 0; n < n2; ++n) {
            object[n + 1] = (String)arrayList.get(n);
        }
        return object;
    }
}

