/*
 * Decompiled with CFR 0.152.
 */
package com.pdfjet;

import com.pdfjet.Box;
import com.pdfjet.Drawable;
import com.pdfjet.Page;
import com.pdfjet.Point;

public class Line
implements Drawable {
    private float x1;
    private float y1;
    private float x2;
    private float y2;
    private float box_x;
    private float box_y;
    private int color = 0;
    private float width = 0.3f;
    private String pattern = "[] 0";
    private int capStyle = 0;
    private String language = null;
    private String altDescription = " ";
    private String actualText = " ";

    public Line() {
    }

    public Line(double d, double d2, double d3, double d4) {
        this.x1 = (float)d;
        this.y1 = (float)d2;
        this.x2 = (float)d3;
        this.y2 = (float)d4;
    }

    public Line(float f, float f2, float f3, float f4) {
        this.x1 = f;
        this.y1 = f2;
        this.x2 = f3;
        this.y2 = f4;
    }

    public Line setPattern(String string) {
        this.pattern = string;
        return this;
    }

    public Line setStartPoint(double d, double d2) {
        this.x1 = (float)d;
        this.y1 = (float)d2;
        return this;
    }

    public Line setStartPoint(float f, float f2) {
        this.x1 = f;
        this.y1 = f2;
        return this;
    }

    public Line setPointA(float f, float f2) {
        this.x1 = f;
        this.y1 = f2;
        return this;
    }

    public Point getStartPoint() {
        return new Point(this.x1, this.y1);
    }

    public Line setEndPoint(double d, double d2) {
        this.x2 = (float)d;
        this.y2 = (float)d2;
        return this;
    }

    public Line setEndPoint(float f, float f2) {
        this.x2 = f;
        this.y2 = f2;
        return this;
    }

    public Line setPointB(float f, float f2) {
        this.x2 = f;
        this.y2 = f2;
        return this;
    }

    public Point getEndPoint() {
        return new Point(this.x2, this.y2);
    }

    public Line setWidth(double d) {
        this.width = (float)d;
        return this;
    }

    public Line setWidth(float f) {
        this.width = f;
        return this;
    }

    public Line setColor(int n) {
        this.color = n;
        return this;
    }

    public Line setCapStyle(int n) {
        this.capStyle = n;
        return this;
    }

    public int getCapStyle() {
        return this.capStyle;
    }

    public Line setAltDescription(String string) {
        this.altDescription = string;
        return this;
    }

    public Line setActualText(String string) {
        this.actualText = string;
        return this;
    }

    public Line placeIn(Box box) throws Exception {
        return this.placeIn(box, 0.0f, 0.0f);
    }

    public Line placeIn(Box box, double d, double d2) throws Exception {
        this.placeIn(box, (float)d, (float)d2);
        return this;
    }

    public Line placeIn(Box box, float f, float f2) throws Exception {
        this.box_x = box.x + f;
        this.box_y = box.y + f2;
        return this;
    }

    public Line scaleBy(double d) throws Exception {
        return this.scaleBy((float)d);
    }

    public Line scaleBy(float f) throws Exception {
        this.x1 *= f;
        this.x2 *= f;
        this.y1 *= f;
        this.y2 *= f;
        return this;
    }

    public float[] drawOn(Page page) throws Exception {
        page.setPenColor(this.color);
        page.setPenWidth(this.width);
        page.setLineCapStyle(this.capStyle);
        page.setLinePattern(this.pattern);
        page.addBMC("Span", this.language, this.altDescription, this.actualText);
        page.drawLine(this.x1 + this.box_x, this.y1 + this.box_y, this.x2 + this.box_x, this.y2 + this.box_y);
        page.addEMC();
        float f = Math.max(this.x1 + this.box_x, this.x2 + this.box_x);
        float f2 = Math.max(this.y1 + this.box_y, this.y2 + this.box_y);
        return new float[]{f, f2};
    }
}

