/*
 * Decompiled with CFR 0.152.
 */
package com.pdfjet;

import com.pdfjet.CoreFont;
import com.pdfjet.Font;
import com.pdfjet.Letter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDFobj {
    protected int number;
    protected int offset;
    protected List<String> dict;
    protected int stream_offset;
    protected byte[] stream;
    protected byte[] data;

    public PDFobj(int n) {
        this.offset = n;
        this.dict = new ArrayList<String>();
    }

    protected PDFobj() {
        this.dict = new ArrayList<String>();
    }

    public int getNumber() {
        return this.number;
    }

    public List<String> getDict() {
        return this.dict;
    }

    public byte[] getData() {
        return this.data;
    }

    protected void setStream(byte[] byArray, int n) {
        this.stream = new byte[n];
        System.arraycopy(byArray, this.stream_offset, this.stream, 0, n);
    }

    protected void setStream(byte[] byArray) {
        this.stream = byArray;
    }

    protected void setNumber(int n) {
        this.number = n;
    }

    public String getValue(String string) {
        for (int i = 0; i < this.dict.size(); ++i) {
            String string2 = this.dict.get(i);
            if (!string2.equals(string)) continue;
            return this.dict.get(i + 1);
        }
        return "";
    }

    protected List<Integer> getObjectNumbers(String string) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < this.dict.size(); ++i) {
            String string2;
            String string3 = this.dict.get(i);
            if (!string3.equals(string)) continue;
            if ((string2 = this.dict.get(++i)).equals("[")) {
                while (!(string2 = this.dict.get(++i)).equals("]")) {
                    arrayList.add(Integer.valueOf(string2));
                    ++i;
                    ++i;
                }
                break;
            }
            arrayList.add(Integer.valueOf(string2));
            break;
        }
        return arrayList;
    }

    public void addContent(byte[] byArray, Map<Integer, PDFobj> map) {
        PDFobj pDFobj = new PDFobj();
        pDFobj.setNumber(Collections.max(map.keySet()) + 1);
        pDFobj.setStream(byArray);
        map.put(pDFobj.getNumber(), pDFobj);
        int n = -1;
        boolean bl = false;
        block0: for (int i = 0; i < this.dict.size(); ++i) {
            String string;
            if (!this.dict.get(i).equals("/Contents")) continue;
            if ((string = this.dict.get(++i)).equals("[")) {
                while (true) {
                    if ((string = this.dict.get(++i)).equals("]")) {
                        n = i;
                        break block0;
                    }
                    ++i;
                    ++i;
                }
            }
            n = i;
            bl = true;
            break;
        }
        if (bl) {
            this.dict.add(n, "[");
            this.dict.add(n + 4, "]");
            this.dict.add(n + 4, "R");
            this.dict.add(n + 4, "0");
            this.dict.add(n + 4, String.valueOf(pDFobj.number));
        } else {
            this.dict.add(n, "R");
            this.dict.add(n, "0");
            this.dict.add(n, String.valueOf(pDFobj.number));
        }
    }

    public float[] getPageSize() {
        for (int i = 0; i < this.dict.size(); ++i) {
            if (!this.dict.get(i).equals("/MediaBox")) continue;
            return new float[]{Float.valueOf(this.dict.get(i + 4)).floatValue(), Float.valueOf(this.dict.get(i + 5)).floatValue()};
        }
        return Letter.PORTRAIT;
    }

    protected int getLength(List<PDFobj> list) {
        for (int i = 0; i < this.dict.size(); ++i) {
            String string = this.dict.get(i);
            if (!string.equals("/Length")) continue;
            int n = Integer.valueOf(this.dict.get(i + 1));
            if (this.dict.get(i + 2).equals("0") && this.dict.get(i + 3).equals("R")) {
                return this.getLength(list, n);
            }
            return n;
        }
        return 0;
    }

    protected int getLength(List<PDFobj> list, int n) {
        for (PDFobj pDFobj : list) {
            if (pDFobj.number != n) continue;
            return Integer.valueOf(pDFobj.dict.get(3));
        }
        return 0;
    }

    public Font addFontResource(CoreFont coreFont, Map<Integer, PDFobj> map) {
        Font font = new Font(coreFont);
        font.fontID = font.name.replace('-', '_').toUpperCase();
        PDFobj pDFobj = new PDFobj();
        pDFobj.number = Collections.max(map.keySet()) + 1;
        pDFobj.dict.add("<<");
        pDFobj.dict.add("/Type");
        pDFobj.dict.add("/Font");
        pDFobj.dict.add("/Subtype");
        pDFobj.dict.add("/Type1");
        pDFobj.dict.add("/BaseFont");
        pDFobj.dict.add("/" + font.name);
        if (!font.name.equals("Symbol") && !font.name.equals("ZapfDingbats")) {
            pDFobj.dict.add("/Encoding");
            pDFobj.dict.add("/WinAnsiEncoding");
        }
        pDFobj.dict.add(">>");
        map.put(pDFobj.number, pDFobj);
        for (int i = 0; i < this.dict.size(); ++i) {
            String string;
            if (!this.dict.get(i).equals("/Resources")) continue;
            if ((string = this.dict.get(++i)).equals("<<")) {
                this.addFontResource(this, map, font.fontID, pDFobj.number);
                continue;
            }
            if (!Character.isDigit(string.charAt(0))) continue;
            this.addFontResource(map.get(Integer.valueOf(string)), map, font.fontID, pDFobj.number);
        }
        return font;
    }

    private void addFontResource(PDFobj pDFobj, Map<Integer, PDFobj> map, String string, int n) {
        block0: for (int i = 0; i < pDFobj.dict.size(); ++i) {
            String string2 = null;
            if (!pDFobj.dict.get(i).equals("/Font")) continue;
            if ((string2 = pDFobj.dict.get(++i)).equals("<<")) {
                pDFobj.dict.add(++i, "/" + string);
                pDFobj.dict.add(++i, String.valueOf(n));
                pDFobj.dict.add(++i, "0");
                pDFobj.dict.add(++i, "R");
                break;
            }
            if (!Character.isDigit(string2.charAt(0))) continue;
            PDFobj pDFobj2 = map.get(Integer.valueOf(string2));
            for (int j = 0; j < pDFobj2.dict.size(); ++j) {
                string2 = pDFobj2.dict.get(j);
                if (!string2.equals("<<")) continue;
                pDFobj2.dict.add(++j, "/" + string);
                pDFobj2.dict.add(++j, String.valueOf(n));
                pDFobj2.dict.add(++j, "0");
                pDFobj2.dict.add(++j, "R");
                continue block0;
            }
        }
    }
}

