/*
 * Decompiled with CFR 0.152.
 */
package com.pdfjet;

import com.pdfjet.BitBuffer;
import com.pdfjet.Drawable;
import com.pdfjet.Page;
import com.pdfjet.Polynomial;
import com.pdfjet.QRUtil;
import com.pdfjet.RSBlock;
import java.io.UnsupportedEncodingException;

public class QRCode
implements Drawable {
    private static final int PAD0 = 236;
    private static final int PAD1 = 17;
    private Boolean[][] modules;
    private int moduleCount = 33;
    private int errorCorrectLevel = 0;
    private float x;
    private float y;
    private byte[] qrData;
    private float m1 = 2.0f;

    public QRCode(String string, int n) throws UnsupportedEncodingException {
        this.qrData = string.getBytes("UTF-8");
        this.errorCorrectLevel = n;
        this.make(false, this.getBestMaskPattern());
    }

    public void setPosition(double d, double d2) {
        this.setPosition((float)d, (float)d2);
    }

    public void setPosition(float f, float f2) {
        this.setLocation(f, f2);
    }

    public void setLocation(float f, float f2) {
        this.x = f;
        this.y = f2;
    }

    public void setModuleLength(double d) {
        this.m1 = (float)d;
    }

    public void setModuleLength(float f) {
        this.m1 = f;
    }

    public float[] drawOn(Page page) throws Exception {
        for (int i = 0; i < this.modules.length; ++i) {
            for (int j = 0; j < this.modules.length; ++j) {
                if (!this.isDark(i, j)) continue;
                page.fillRect(this.x + (float)j * this.m1, this.y + (float)i * this.m1, this.m1, this.m1);
            }
        }
        float f = this.m1 * (float)this.modules.length;
        float f2 = this.m1 * (float)this.modules.length;
        return new float[]{this.x + f, this.y + f2};
    }

    public Boolean[][] getData() {
        return this.modules;
    }

    protected boolean isDark(int n, int n2) {
        if (this.modules[n][n2] != null) {
            return this.modules[n][n2];
        }
        return false;
    }

    protected int getModuleCount() {
        return this.moduleCount;
    }

    protected int getBestMaskPattern() {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < 8; ++i) {
            this.make(true, i);
            int n3 = QRUtil.getLostPoint(this);
            if (i != 0 && n <= n3) continue;
            n = n3;
            n2 = i;
        }
        return n2;
    }

    protected void make(boolean bl, int n) {
        this.modules = new Boolean[this.moduleCount][this.moduleCount];
        this.setupPositionProbePattern(0, 0);
        this.setupPositionProbePattern(this.moduleCount - 7, 0);
        this.setupPositionProbePattern(0, this.moduleCount - 7);
        this.setupPositionAdjustPattern();
        this.setupTimingPattern();
        this.setupTypeInfo(bl, n);
        this.mapData(this.createData(this.errorCorrectLevel), n);
    }

    private void mapData(byte[] byArray, int n) {
        int n2 = -1;
        int n3 = this.moduleCount - 1;
        int n4 = 7;
        int n5 = 0;
        for (int i = this.moduleCount - 1; i > 0; i -= 2) {
            if (i == 6) {
                --i;
            }
            do {
                for (int j = 0; j < 2; ++j) {
                    boolean bl;
                    if (this.modules[n3][i - j] != null) continue;
                    boolean bl2 = false;
                    if (n5 < byArray.length) {
                        boolean bl3 = bl2 = (byArray[n5] >>> n4 & 1) == 1;
                    }
                    if (bl = QRUtil.getMask(n, n3, i - j)) {
                        bl2 = !bl2;
                    }
                    this.modules[n3][i - j] = bl2;
                    if (--n4 != -1) continue;
                    ++n5;
                    n4 = 7;
                }
            } while ((n3 += n2) >= 0 && this.moduleCount > n3);
            n3 -= n2;
            n2 = -n2;
        }
    }

    private void setupPositionAdjustPattern() {
        int[] nArray = new int[]{6, 26};
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray.length; ++j) {
                int n = nArray[i];
                int n2 = nArray[j];
                if (this.modules[n][n2] != null) continue;
                for (int k = -2; k <= 2; ++k) {
                    for (int i2 = -2; i2 <= 2; ++i2) {
                        this.modules[n + k][n2 + i2] = k == -2 || k == 2 || i2 == -2 || i2 == 2 || k == 0 && i2 == 0;
                    }
                }
            }
        }
    }

    private void setupPositionProbePattern(int n, int n2) {
        for (int i = -1; i <= 7; ++i) {
            for (int j = -1; j <= 7; ++j) {
                if (n + i <= -1 || this.moduleCount <= n + i || n2 + j <= -1 || this.moduleCount <= n2 + j) continue;
                this.modules[n + i][n2 + j] = 0 <= i && i <= 6 && (j == 0 || j == 6) || 0 <= j && j <= 6 && (i == 0 || i == 6) || 2 <= i && i <= 4 && 2 <= j && j <= 4;
            }
        }
    }

    private void setupTimingPattern() {
        int n;
        for (n = 8; n < this.moduleCount - 8; ++n) {
            if (this.modules[n][6] != null) continue;
            this.modules[n][6] = n % 2 == 0;
        }
        for (n = 8; n < this.moduleCount - 8; ++n) {
            if (this.modules[6][n] != null) continue;
            this.modules[6][n] = n % 2 == 0;
        }
    }

    private void setupTypeInfo(boolean bl, int n) {
        Boolean bl2;
        int n2;
        int n3 = this.errorCorrectLevel << 3 | n;
        int n4 = QRUtil.getBCHTypeInfo(n3);
        for (n2 = 0; n2 < 15; ++n2) {
            bl2 = !bl && (n4 >> n2 & 1) == 1;
            if (n2 < 6) {
                this.modules[n2][8] = bl2;
                continue;
            }
            if (n2 < 8) {
                this.modules[n2 + 1][8] = bl2;
                continue;
            }
            this.modules[this.moduleCount - 15 + n2][8] = bl2;
        }
        for (n2 = 0; n2 < 15; ++n2) {
            bl2 = !bl && (n4 >> n2 & 1) == 1;
            if (n2 < 8) {
                this.modules[8][this.moduleCount - n2 - 1] = bl2;
                continue;
            }
            if (n2 < 9) {
                this.modules[8][15 - n2 - 1 + 1] = bl2;
                continue;
            }
            this.modules[8][15 - n2 - 1] = bl2;
        }
        this.modules[this.moduleCount - 8][8] = !bl;
    }

    private byte[] createData(int n) {
        int n2;
        RSBlock[] rSBlockArray = RSBlock.getRSBlocks(n);
        BitBuffer bitBuffer = new BitBuffer();
        bitBuffer.put(4, 4);
        bitBuffer.put(this.qrData.length, 8);
        for (n2 = 0; n2 < this.qrData.length; ++n2) {
            bitBuffer.put(this.qrData[n2], 8);
        }
        n2 = 0;
        for (int i = 0; i < rSBlockArray.length; ++i) {
            n2 += rSBlockArray[i].getDataCount();
        }
        if (bitBuffer.getLengthInBits() > n2 * 8) {
            throw new IllegalArgumentException("String length overflow. (" + bitBuffer.getLengthInBits() + ">" + n2 * 8 + ")");
        }
        if (bitBuffer.getLengthInBits() + 4 <= n2 * 8) {
            bitBuffer.put(0, 4);
        }
        while (bitBuffer.getLengthInBits() % 8 != 0) {
            bitBuffer.put(false);
        }
        while (bitBuffer.getLengthInBits() < n2 * 8) {
            bitBuffer.put(236, 8);
            if (bitBuffer.getLengthInBits() >= n2 * 8) break;
            bitBuffer.put(17, 8);
        }
        return this.createBytes(bitBuffer, rSBlockArray);
    }

    private byte[] createBytes(BitBuffer bitBuffer, RSBlock[] rSBlockArray) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int[][] nArrayArray = new int[rSBlockArray.length][];
        int[][] nArrayArray2 = new int[rSBlockArray.length][];
        for (n4 = 0; n4 < rSBlockArray.length; ++n4) {
            n3 = rSBlockArray[n4].getDataCount();
            n2 = rSBlockArray[n4].getTotalCount() - n3;
            n6 = Math.max(n6, n3);
            n7 = Math.max(n7, n2);
            nArrayArray[n4] = new int[n3];
            for (int i = 0; i < nArrayArray[n4].length; ++i) {
                nArrayArray[n4][i] = 0xFF & bitBuffer.getBuffer()[i + n5];
            }
            n5 += n3;
            Polynomial polynomial = QRUtil.getErrorCorrectPolynomial(n2);
            Polynomial polynomial2 = new Polynomial(nArrayArray[n4], polynomial.getLength() - 1);
            Polynomial polynomial3 = polynomial2.mod(polynomial);
            nArrayArray2[n4] = new int[polynomial.getLength() - 1];
            for (int i = 0; i < nArrayArray2[n4].length; ++i) {
                int n8 = i + polynomial3.getLength() - nArrayArray2[n4].length;
                nArrayArray2[n4][i] = n8 >= 0 ? polynomial3.get(n8) : 0;
            }
        }
        n4 = 0;
        for (n3 = 0; n3 < rSBlockArray.length; ++n3) {
            n4 += rSBlockArray[n3].getTotalCount();
        }
        byte[] byArray = new byte[n4];
        n2 = 0;
        for (n = 0; n < n6; ++n) {
            for (int i = 0; i < rSBlockArray.length; ++i) {
                if (n >= nArrayArray[i].length) continue;
                byArray[n2++] = (byte)nArrayArray[i][n];
            }
        }
        for (n = 0; n < n7; ++n) {
            for (int i = 0; i < rSBlockArray.length; ++i) {
                if (n >= nArrayArray2[i].length) continue;
                byArray[n2++] = (byte)nArrayArray2[i][n];
            }
        }
        return byArray;
    }
}

