/*
 * Decompiled with CFR 0.152.
 */
package com.pdfjet;

class QRMath {
    private static final int[] EXP_TABLE;
    private static final int[] LOG_TABLE;

    QRMath() {
    }

    public static int glog(int n) {
        if (n < 1) {
            throw new ArithmeticException("log(" + n + ")");
        }
        return LOG_TABLE[n];
    }

    public static int gexp(int n) {
        while (n < 0) {
            n += 255;
        }
        while (n >= 256) {
            n -= 255;
        }
        return EXP_TABLE[n];
    }

    static {
        int n;
        EXP_TABLE = new int[256];
        LOG_TABLE = new int[256];
        for (n = 0; n < 8; ++n) {
            QRMath.EXP_TABLE[n] = 1 << n;
        }
        for (n = 8; n < 256; ++n) {
            QRMath.EXP_TABLE[n] = EXP_TABLE[n - 4] ^ EXP_TABLE[n - 5] ^ EXP_TABLE[n - 6] ^ EXP_TABLE[n - 8];
        }
        for (n = 0; n < 255; ++n) {
            QRMath.LOG_TABLE[QRMath.EXP_TABLE[n]] = n;
        }
    }
}

