/*
 * Decompiled with CFR 0.152.
 */
package com.pdfjet;

import com.pdfjet.Annotation;
import com.pdfjet.Drawable;
import com.pdfjet.Font;
import com.pdfjet.Operation;
import com.pdfjet.Page;

public class RadioButton
implements Drawable {
    private boolean selected = false;
    private float x;
    private float y;
    private float r1;
    private float r2;
    private float penWidth;
    private Font font = null;
    private String label = "";
    private String uri = null;
    private String language = null;
    private String altDescription = " ";
    private String actualText = " ";

    public RadioButton(Font font, String string) {
        this.font = font;
        this.label = string;
    }

    public RadioButton setFontSize(float f) {
        this.font.setSize(f);
        return this;
    }

    public RadioButton setPosition(float f, float f2) {
        return this.setLocation(f, f2);
    }

    public RadioButton setLocation(float f, float f2) {
        this.x = f;
        this.y = f2;
        return this;
    }

    public RadioButton setURIAction(String string) {
        this.uri = string;
        return this;
    }

    public RadioButton select(boolean bl) {
        this.selected = bl;
        return this;
    }

    public RadioButton setAltDescription(String string) {
        this.altDescription = string;
        return this;
    }

    public RadioButton setActualText(String string) {
        this.actualText = string;
        return this;
    }

    public float[] drawOn(Page page) throws Exception {
        page.addBMC("Span", this.language, this.altDescription, this.actualText);
        this.r1 = this.font.getAscent() / 2.0f;
        this.r2 = this.r1 / 2.0f;
        this.penWidth = this.r1 / 10.0f;
        float f = this.y - this.font.getAscent();
        page.setPenWidth(1.0f);
        page.setPenColor(0);
        page.setLinePattern("[] 0");
        page.setBrushColor(0);
        page.drawCircle(this.x + this.r1, f + this.r1, this.r1);
        if (this.selected) {
            page.drawCircle(this.x + this.r1, f + this.r1, this.r2, Operation.FILL);
        }
        if (this.uri != null) {
            page.setBrushColor(255);
        }
        page.drawString(this.font, this.label, this.x + 3.0f * this.r1, this.y);
        page.setPenWidth(0.0f);
        page.setBrushColor(0);
        page.addEMC();
        if (this.uri != null) {
            page.addAnnotation(new Annotation(this.uri, null, this.x + 3.0f * this.r1, page.height - this.y, this.x + 3.0f * this.r1 + this.font.stringWidth(this.label), page.height - (this.y - this.font.getAscent()), this.language, this.altDescription, this.actualText));
        }
        return new float[]{this.x + 6.0f * this.r1 + this.font.stringWidth(this.label), this.y + this.font.getDescent()};
    }
}

