/*
 * Decompiled with CFR 0.152.
 */
package com.pdfjet;

import com.pdfjet.Cell;
import com.pdfjet.Font;
import com.pdfjet.Page;
import com.pdfjet.Point;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Table {
    public static final int DATA_HAS_0_HEADER_ROWS = 0;
    public static final int DATA_HAS_1_HEADER_ROWS = 1;
    public static final int DATA_HAS_2_HEADER_ROWS = 2;
    public static final int DATA_HAS_3_HEADER_ROWS = 3;
    public static final int DATA_HAS_4_HEADER_ROWS = 4;
    public static final int DATA_HAS_5_HEADER_ROWS = 5;
    public static final int DATA_HAS_6_HEADER_ROWS = 6;
    public static final int DATA_HAS_7_HEADER_ROWS = 7;
    public static final int DATA_HAS_8_HEADER_ROWS = 8;
    public static final int DATA_HAS_9_HEADER_ROWS = 9;
    private int rendered = 0;
    private int numOfPages;
    private List<List<Cell>> tableData = new ArrayList<List<Cell>>();
    private int numOfHeaderRows = 0;
    private float x1;
    private float y1;
    private float bottom_margin = 30.0f;

    public void setPosition(double d, double d2) {
        this.x1 = (float)d;
        this.y1 = (float)d2;
    }

    public void setPosition(float f, float f2) {
        this.setLocation(f, f2);
    }

    public void setLocation(float f, float f2) {
        this.x1 = f;
        this.y1 = f2;
    }

    public void setBottomMargin(double d) {
        this.bottom_margin = (float)d;
    }

    public void setBottomMargin(float f) {
        this.bottom_margin = f;
    }

    public void setData(List<List<Cell>> list) throws Exception {
        this.tableData = list;
        this.rendered = this.numOfHeaderRows = 0;
    }

    public void setData(List<List<Cell>> list, int n) throws Exception {
        this.tableData = list;
        this.numOfHeaderRows = n;
        this.rendered = n;
    }

    public void autoAdjustColumnWidths() {
        Cell cell;
        int n;
        List<Cell> list;
        int n2;
        float[] fArray = new float[this.tableData.get(0).size()];
        for (n2 = 0; n2 < this.tableData.size(); ++n2) {
            list = this.tableData.get(n2);
            for (n = 0; n < list.size(); ++n) {
                cell = list.get(n);
                if (cell.getColSpan() != 1) continue;
                float f = 0.0f;
                if (cell.image != null) {
                    f = cell.image.getWidth();
                }
                if (cell.text != null && cell.font.stringWidth(cell.fallbackFont, cell.text) > f) {
                    f = cell.font.stringWidth(cell.fallbackFont, cell.text);
                }
                cell.setWidth(f + cell.left_padding + cell.right_padding);
                if (fArray[n] != 0.0f && !(cell.getWidth() > fArray[n])) continue;
                fArray[n] = cell.getWidth();
            }
        }
        for (n2 = 0; n2 < this.tableData.size(); ++n2) {
            list = this.tableData.get(n2);
            for (n = 0; n < list.size(); ++n) {
                cell = list.get(n);
                cell.setWidth(fArray[n]);
            }
        }
    }

    public void rightAlignNumbers() {
        for (int i = this.numOfHeaderRows; i < this.tableData.size(); ++i) {
            List<Cell> list = this.tableData.get(i);
            for (int j = 0; j < list.size(); ++j) {
                Cell cell = list.get(j);
                if (cell.text == null) continue;
                String string = cell.text;
                int n = string.length();
                boolean bl = true;
                int n2 = 0;
                while (n2 < n) {
                    char c;
                    if (Character.isDigit(c = string.charAt(n2++)) || c == '(' || c == ')' || c == '-' || c == '.' || c == ',' || c == '\'') continue;
                    bl = false;
                }
                if (!bl) continue;
                cell.setTextAlignment(0x200000);
            }
        }
    }

    public void removeLineBetweenRows(int n, int n2) throws Exception {
        for (int i = n; i < n2; ++i) {
            Cell cell;
            int n3;
            List<Cell> list = this.tableData.get(i);
            for (n3 = 0; n3 < list.size(); ++n3) {
                cell = list.get(n3);
                cell.setBorder(131072, false);
            }
            list = this.tableData.get(i + 1);
            for (n3 = 0; n3 < list.size(); ++n3) {
                cell = list.get(n3);
                cell.setBorder(65536, false);
            }
        }
    }

    public void setTextAlignInColumn(int n, int n2) throws Exception {
        for (int i = 0; i < this.tableData.size(); ++i) {
            List<Cell> list = this.tableData.get(i);
            if (n >= list.size()) continue;
            list.get(n).setTextAlignment(n2);
        }
    }

    public void setTextColorInColumn(int n, int n2) throws Exception {
        for (int i = 0; i < this.tableData.size(); ++i) {
            List<Cell> list = this.tableData.get(i);
            if (n >= list.size()) continue;
            list.get(n).setBrushColor(n2);
        }
    }

    public void setFontInColumn(int n, Font font) throws Exception {
        for (int i = 0; i < this.tableData.size(); ++i) {
            List<Cell> list = this.tableData.get(i);
            if (n >= list.size()) continue;
            list.get((int)n).font = font;
        }
    }

    public void setTextColorInRow(int n, int n2) throws Exception {
        List<Cell> list = this.tableData.get(n);
        for (int i = 0; i < list.size(); ++i) {
            list.get(i).setBrushColor(n2);
        }
    }

    public void setFontInRow(int n, Font font) throws Exception {
        List<Cell> list = this.tableData.get(n);
        for (int i = 0; i < list.size(); ++i) {
            list.get((int)i).font = font;
        }
    }

    public void setColumnWidth(int n, float f) throws Exception {
        for (int i = 0; i < this.tableData.size(); ++i) {
            List<Cell> list = this.tableData.get(i);
            if (n >= list.size()) continue;
            list.get(n).setWidth(f);
        }
    }

    public float getColumnWidth(int n) throws Exception {
        return this.getCellAtRowColumn(0, n).getWidth();
    }

    public Cell getCellAt(int n, int n2) throws Exception {
        if (n >= 0) {
            return this.tableData.get(n).get(n2);
        }
        return this.tableData.get(this.tableData.size() + n).get(n2);
    }

    public Cell getCellAtRowColumn(int n, int n2) throws Exception {
        return this.getCellAt(n, n2);
    }

    public List<Cell> getRow(int n) throws Exception {
        return this.tableData.get(n);
    }

    public List<Cell> getRowAtIndex(int n) throws Exception {
        return this.getRow(n);
    }

    public List<Cell> getColumn(int n) throws Exception {
        ArrayList<Cell> arrayList = new ArrayList<Cell>();
        for (int i = 0; i < this.tableData.size(); ++i) {
            List<Cell> list = this.tableData.get(i);
            if (n >= list.size()) continue;
            arrayList.add(list.get(n));
        }
        return arrayList;
    }

    public List<Cell> getColumnAtIndex(int n) throws Exception {
        return this.getColumn(n);
    }

    public int getNumberOfPages(Page page) throws Exception {
        this.numOfPages = 1;
        while (this.hasMoreData()) {
            this.drawOn(page, false);
        }
        this.resetRenderedPagesCount();
        return this.numOfPages;
    }

    public Point drawOn(Page page) throws Exception {
        return this.drawOn(page, true);
    }

    private Point drawOn(Page page, boolean bl) throws Exception {
        return this.drawTableRows(page, bl, this.drawHeaderRows(page, bl));
    }

    private float[] drawHeaderRows(Page page, boolean bl) throws Exception {
        float f = this.x1;
        float f2 = this.y1;
        float f3 = 0.0f;
        float f4 = 0.0f;
        for (int i = 0; i < this.numOfHeaderRows; ++i) {
            List<Cell> list = this.tableData.get(i);
            f4 = this.getMaxCellHeight(list);
            for (int j = 0; j < list.size(); ++j) {
                Cell cell = list.get(j);
                f3 = cell.getWidth();
                int n = cell.getColSpan();
                for (int k = 1; k < n; ++k) {
                    f3 += list.get((int)(++j)).width;
                }
                if (bl) {
                    page.setBrushColor(cell.getBrushColor());
                    cell.paint(page, f, f2, f3, f4);
                }
                f += f3;
            }
            f = this.x1;
            f2 += f4;
        }
        return new float[]{f, f2, f3, f4};
    }

    private Point drawTableRows(Page page, boolean bl, float[] fArray) throws Exception {
        float f = fArray[0];
        float f2 = fArray[1];
        float f3 = fArray[2];
        float f4 = fArray[3];
        for (int i = this.rendered; i < this.tableData.size(); ++i) {
            List<Cell> list = this.tableData.get(i);
            f4 = this.getMaxCellHeight(list);
            for (int j = 0; j < list.size(); ++j) {
                Cell cell = list.get(j);
                f3 = cell.getWidth();
                int n = cell.getColSpan();
                for (int k = 1; k < n; ++k) {
                    f3 += list.get(++j).getWidth();
                }
                if (bl) {
                    page.setBrushColor(cell.getBrushColor());
                    cell.paint(page, f, f2, f3, f4);
                }
                f += f3;
            }
            f = this.x1;
            f2 += f4;
            if (i < this.tableData.size() - 1) {
                List<Cell> list2 = this.tableData.get(i + 1);
                for (int j = 0; j < list2.size(); ++j) {
                    Cell cell = list2.get(j);
                    float f5 = cell.getHeight();
                    if (!(f5 > f4)) continue;
                    f4 = f5;
                }
            }
            if (!(f2 + f4 > page.height - this.bottom_margin)) continue;
            if (i == this.tableData.size() - 1) {
                this.rendered = -1;
            } else {
                this.rendered = i + 1;
                ++this.numOfPages;
            }
            return new Point(f, f2);
        }
        this.rendered = -1;
        return new Point(f, f2);
    }

    private float getMaxCellHeight(List<Cell> list) {
        float f = 0.0f;
        for (int i = 0; i < list.size(); ++i) {
            Cell cell = list.get(i);
            if (!(cell.getHeight() > f)) continue;
            f = cell.getHeight();
        }
        return f;
    }

    public boolean hasMoreData() {
        return this.rendered != -1;
    }

    public float getWidth() {
        float f = 0.0f;
        List<Cell> list = this.tableData.get(0);
        for (int i = 0; i < list.size(); ++i) {
            f += list.get(i).getWidth();
        }
        return f;
    }

    public int getRowsRendered() {
        return this.rendered == -1 ? this.rendered : this.rendered - this.numOfHeaderRows;
    }

    public void wrapAroundCellText() {
        int n;
        List list;
        int n2;
        ArrayList<List<Cell>> arrayList = new ArrayList<List<Cell>>();
        for (n2 = 0; n2 < this.tableData.size(); ++n2) {
            Cell cell;
            int n3;
            Object object;
            int n4;
            list = this.tableData.get(n2);
            n = 1;
            for (n4 = 0; n4 < list.size(); ++n4) {
                int n5;
                object = (Cell)list.get(n4);
                n3 = ((Cell)object).getColSpan();
                for (n5 = 1; n5 < n3; ++n5) {
                    cell = (Cell)list.get(n4 + n5);
                    ((Cell)object).setWidth(((Cell)object).getWidth() + cell.getWidth());
                    cell.setWidth(0.0f);
                }
                n5 = ((Cell)object).getNumVerCells();
                if (n5 <= n) continue;
                n = n5;
            }
            for (n4 = 0; n4 < n; ++n4) {
                object = new ArrayList();
                for (n3 = 0; n3 < list.size(); ++n3) {
                    Cell cell2 = (Cell)list.get(n3);
                    cell = new Cell(cell2.getFont(), "");
                    cell.setFallbackFont(cell2.getFallbackFont());
                    cell.setPoint(cell2.getPoint());
                    cell.setWidth(cell2.getWidth());
                    if (n4 == 0) {
                        cell.setTopPadding(cell2.top_padding);
                    }
                    if (n4 == n - 1) {
                        cell.setBottomPadding(cell2.bottom_padding);
                    }
                    cell.setLeftPadding(cell2.left_padding);
                    cell.setRightPadding(cell2.right_padding);
                    cell.setLineWidth(cell2.lineWidth);
                    cell.setBgColor(cell2.getBgColor());
                    cell.setPenColor(cell2.getPenColor());
                    cell.setBrushColor(cell2.getBrushColor());
                    cell.setProperties(cell2.getProperties());
                    cell.setVerTextAlignment(cell2.getVerTextAlignment());
                    if (n4 == 0) {
                        cell.setImage(cell2.getImage());
                        if (cell2.getCompositeTextLine() != null) {
                            cell.setCompositeTextLine(cell2.getCompositeTextLine());
                        } else {
                            cell.setText(cell2.getText());
                        }
                        if (n > 1) {
                            cell.setBorder(131072, false);
                        }
                    } else {
                        cell.setBorder(65536, false);
                        if (n4 < n - 1) {
                            cell.setBorder(131072, false);
                        }
                    }
                    object.add(cell);
                }
                arrayList.add((List<Cell>)object);
            }
        }
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            list = (List)arrayList.get(n2);
            for (n = 0; n < list.size(); ++n) {
                Cell cell = (Cell)list.get(n);
                if (cell.text != null) {
                    String[] stringArray;
                    int n6 = 0;
                    for (String string : stringArray = cell.getText().split("\\r?\\n")) {
                        StringBuilder stringBuilder = new StringBuilder();
                        String[] stringArray2 = string.split("\\s+");
                        if (stringArray2.length == 1) {
                            stringBuilder.append(stringArray2[0]);
                        } else {
                            for (int i = 0; i < stringArray2.length; ++i) {
                                String string2 = stringArray2[i];
                                StringBuilder stringBuilder2 = new StringBuilder();
                                if (cell.font.stringWidth(cell.fallbackFont, stringBuilder2.append(stringBuilder.toString()).append(" ").append(string2).toString()) > cell.getWidth() - (cell.left_padding + cell.right_padding)) {
                                    ((Cell)((List)arrayList.get(n2 + n6)).get(n)).setText(stringBuilder.toString());
                                    stringBuilder = new StringBuilder(string2);
                                    ++n6;
                                    continue;
                                }
                                if (i > 0) {
                                    stringBuilder.append(" ");
                                }
                                stringBuilder.append(string2);
                            }
                        }
                        ((Cell)((List)arrayList.get(n2 + n6)).get(n)).setText(stringBuilder.toString());
                        ++n6;
                    }
                    continue;
                }
                ((Cell)((List)arrayList.get(n2)).get(n)).setCompositeTextLine(cell.getCompositeTextLine());
            }
        }
        this.tableData = arrayList;
    }

    public void setNoCellBorders() {
        for (int i = 0; i < this.tableData.size(); ++i) {
            List<Cell> list = this.tableData.get(i);
            for (int j = 0; j < list.size(); ++j) {
                this.tableData.get(i).get(j).setNoBorders();
            }
        }
    }

    public void setCellBordersColor(int n) {
        for (int i = 0; i < this.tableData.size(); ++i) {
            List<Cell> list = this.tableData.get(i);
            for (int j = 0; j < list.size(); ++j) {
                this.tableData.get(i).get(j).setPenColor(n);
            }
        }
    }

    public void setCellBordersWidth(float f) {
        for (int i = 0; i < this.tableData.size(); ++i) {
            List<Cell> list = this.tableData.get(i);
            for (int j = 0; j < list.size(); ++j) {
                this.tableData.get(i).get(j).setLineWidth(f);
            }
        }
    }

    public void resetRenderedPagesCount() {
        this.rendered = this.numOfHeaderRows;
    }

    public void wrapAroundCellText2() {
        int n;
        Object object;
        int n2;
        List list;
        int n3;
        ArrayList<List<Cell>> arrayList = new ArrayList<List<Cell>>();
        for (n3 = 0; n3 < this.tableData.size(); ++n3) {
            Cell cell;
            int n4;
            list = this.tableData.get(n3);
            n2 = 1;
            for (n4 = 0; n4 < list.size(); ++n4) {
                int n5;
                object = (Cell)list.get(n4);
                n = ((Cell)object).getColSpan();
                for (n5 = 1; n5 < n; ++n5) {
                    cell = (Cell)list.get(n4 + n5);
                    ((Cell)object).setWidth(((Cell)object).getWidth() + cell.getWidth());
                    cell.setWidth(0.0f);
                }
                n5 = ((Cell)object).getNumVerCells2();
                if (n5 <= n2) continue;
                n2 = n5;
            }
            for (n4 = 0; n4 < n2; ++n4) {
                object = new ArrayList();
                for (n = 0; n < list.size(); ++n) {
                    Cell cell2 = (Cell)list.get(n);
                    cell = new Cell(cell2.getFont(), "");
                    cell.setFallbackFont(cell2.getFallbackFont());
                    cell.setPoint(cell2.getPoint());
                    cell.setWidth(cell2.getWidth());
                    if (n4 == 0) {
                        cell.setTopPadding(cell2.top_padding);
                    }
                    if (n4 == n2 - 1) {
                        cell.setBottomPadding(cell2.bottom_padding);
                    }
                    cell.setLeftPadding(cell2.left_padding);
                    cell.setRightPadding(cell2.right_padding);
                    cell.setLineWidth(cell2.lineWidth);
                    cell.setBgColor(cell2.getBgColor());
                    cell.setPenColor(cell2.getPenColor());
                    cell.setBrushColor(cell2.getBrushColor());
                    cell.setProperties(cell2.getProperties());
                    cell.setVerTextAlignment(cell2.getVerTextAlignment());
                    if (n4 == 0) {
                        cell.setImage(cell2.getImage());
                        if (cell2.getCompositeTextLine() != null) {
                            cell.setCompositeTextLine(cell2.getCompositeTextLine());
                        } else {
                            cell.setText(cell2.getText());
                        }
                        if (n2 > 1) {
                            cell.setBorder(131072, false);
                        }
                    } else {
                        cell.setBorder(65536, false);
                        if (n4 < n2 - 1) {
                            cell.setBorder(131072, false);
                        }
                    }
                    object.add(cell);
                }
                arrayList.add((List<Cell>)object);
            }
        }
        for (n3 = 0; n3 < arrayList.size(); ++n3) {
            list = (List)arrayList.get(n3);
            for (n2 = 0; n2 < list.size(); ++n2) {
                Cell cell = (Cell)list.get(n2);
                if (cell.text != null) {
                    object = cell.text;
                    n = 0;
                    StringBuilder stringBuilder = new StringBuilder();
                    for (int i = 0; i < ((String)object).length(); ++i) {
                        String string = new String(new char[]{((String)object).charAt(i)});
                        StringBuilder stringBuilder2 = new StringBuilder();
                        if (cell.font.stringWidth(cell.fallbackFont, stringBuilder2.append(stringBuilder.toString()).append(string).toString()) > cell.getWidth() - (cell.left_padding + cell.right_padding)) {
                            ((Cell)((List)arrayList.get(n3 + n)).get(n2)).setText(stringBuilder.toString());
                            ++n;
                            stringBuilder.setLength(0);
                        }
                        stringBuilder.append(string);
                    }
                    ((Cell)((List)arrayList.get(n3 + n)).get(n2)).setText(stringBuilder.toString());
                    continue;
                }
                ((Cell)((List)arrayList.get(n3)).get(n2)).setCompositeTextLine(cell.getCompositeTextLine());
            }
        }
        this.tableData = arrayList;
    }
}

