/*
 * Decompiled with CFR 0.152.
 */
package com.pdfjet;

import com.pdfjet.Font;
import com.pdfjet.Page;
import java.util.ArrayList;

public class TextBlock {
    private Font font = null;
    private Font fallbackFont = null;
    private String text = null;
    private float space = 0.0f;
    private int textAlign = 0;
    private float x;
    private float y;
    private float w = 300.0f;
    private float h = 200.0f;
    private int background = 0xFFFFFF;
    private int brush = 0;

    public TextBlock(Font font) {
        this.font = font;
        this.space = this.font.getDescent();
    }

    public TextBlock setFallbackFont(Font font) {
        this.fallbackFont = font;
        return this;
    }

    public TextBlock setText(String string) {
        this.text = string;
        return this;
    }

    public TextBlock setLocation(float f, float f2) {
        this.x = f;
        this.y = f2;
        return this;
    }

    public TextBlock setWidth(float f) {
        this.w = f;
        return this;
    }

    public float getWidth() {
        return this.w;
    }

    public TextBlock setHeight(float f) {
        this.h = f;
        return this;
    }

    public float getHeight() throws Exception {
        return this.drawOn(null).h;
    }

    public TextBlock setSpaceBetweenLines(float f) {
        this.space = f;
        return this;
    }

    public float getSpaceBetweenLines() {
        return this.space;
    }

    public TextBlock setTextAlignment(int n) {
        this.textAlign = n;
        return this;
    }

    public int getTextAlignment() {
        return this.textAlign;
    }

    public TextBlock setBgColor(int n) {
        this.background = n;
        return this;
    }

    public int getBgColor() {
        return this.background;
    }

    public TextBlock setBrushColor(int n) {
        this.brush = n;
        return this;
    }

    public int getBrushColor() {
        return this.brush;
    }

    public TextBlock drawOn(Page page) throws Exception {
        if (page != null) {
            if (this.getBgColor() != 0xFFFFFF) {
                page.setBrushColor(this.background);
                page.fillRect(this.x, this.y, this.w, this.h);
            }
            page.setBrushColor(this.brush);
        }
        return this.drawText(page);
    }

    private TextBlock drawText(Page page) throws Exception {
        int n;
        String[] stringArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        String[] stringArray2 = stringArray = this.text.split("\\r?\\n");
        int n2 = stringArray2.length;
        for (n = 0; n < n2; ++n) {
            String[] stringArray3;
            String string = stringArray2[n];
            if (this.font.stringWidth(string) < this.w) {
                arrayList.add(string);
                continue;
            }
            stringBuilder.setLength(0);
            for (String string2 : stringArray3 = string.split("\\s+")) {
                StringBuilder stringBuilder2 = new StringBuilder();
                if (this.font.stringWidth(stringBuilder2.append(stringBuilder.toString()).append(" ").append(string2).toString()) < this.w) {
                    stringBuilder.append(" " + string2);
                    continue;
                }
                arrayList.add(stringBuilder.toString().trim());
                stringBuilder.setLength(0);
                stringBuilder.append(string2);
            }
            if (stringBuilder.toString().trim().equals("")) continue;
            arrayList.add(stringBuilder.toString().trim());
        }
        stringArray = arrayList.toArray(new String[0]);
        float f = this.y + this.font.getAscent();
        for (n = 0; n < stringArray.length; ++n) {
            float f2;
            if (this.textAlign == 0) {
                f2 = this.x;
            } else if (this.textAlign == 0x200000) {
                f2 = this.x + this.w - this.font.stringWidth(stringArray[n]);
            } else if (this.textAlign == 0x100000) {
                f2 = this.x + (this.w - this.font.stringWidth(stringArray[n])) / 2.0f;
            } else {
                throw new Exception("Invalid text alignment option.");
            }
            if (page != null) {
                page.drawString(this.font, this.fallbackFont, stringArray[n], f2, f);
            }
            if (n < stringArray.length - 1) {
                f += this.font.getBodyHeight() + this.space;
                continue;
            }
            f += this.font.getDescent() + this.space;
        }
        this.h = f - this.y;
        return this;
    }
}

