/*
 * Decompiled with CFR 0.152.
 */
package com.pdfjet;

import com.pdfjet.Drawable;
import com.pdfjet.Font;
import com.pdfjet.Page;
import java.util.ArrayList;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextBox
implements Drawable {
    protected Font font;
    protected String text;
    protected float x;
    protected float y;
    protected float width = 300.0f;
    protected float height = 0.0f;
    protected float spacing = 3.0f;
    protected float margin = 1.0f;
    private float lineWidth = 0.0f;
    private int background = 0xFFFFFF;
    private int pen = 0;
    private int brush = 0;
    private int valign = 0;
    private Font fallbackFont;
    private Map<String, Integer> colors = null;
    private int properties = 983041;

    public TextBox(Font font) {
        this.font = font;
    }

    public TextBox(Font font, String string) {
        this.font = font;
        this.text = string;
    }

    public TextBox(Font font, String string, double d, double d2) {
        this(font, string, (float)d, (float)d2);
    }

    public TextBox(Font font, String string, float f, float f2) {
        this.font = font;
        this.text = string;
        this.width = f;
        this.height = f2;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public Font getFont() {
        return this.font;
    }

    public void setText(String string) {
        this.text = string;
    }

    public String getText() {
        return this.text;
    }

    public void setPosition(double d, double d2) {
        this.setPosition((float)d, (float)d2);
    }

    public void setPosition(float f, float f2) {
        this.setLocation(f, f2);
    }

    public void setLocation(float f, float f2) {
        this.x = f;
        this.y = f2;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public void setWidth(double d) {
        this.width = (float)d;
    }

    public void setWidth(float f) {
        this.width = f;
    }

    public float getWidth() {
        return this.width;
    }

    public void setHeight(double d) {
        this.height = (float)d;
    }

    public void setHeight(float f) {
        this.height = f;
    }

    public float getHeight() {
        return this.height;
    }

    public void setMargin(double d) {
        this.margin = (float)d;
    }

    public void setMargin(float f) {
        this.margin = f;
    }

    public float getMargin() {
        return this.margin;
    }

    public void setLineWidth(double d) {
        this.lineWidth = (float)d;
    }

    public void setLineWidth(float f) {
        this.lineWidth = f;
    }

    public float getLineWidth() {
        return this.lineWidth;
    }

    public void setSpacing(double d) {
        this.spacing = (float)d;
    }

    public void setSpacing(float f) {
        this.spacing = f;
    }

    public float getSpacing() {
        return this.spacing;
    }

    public void setBgColor(int n) {
        this.background = n;
    }

    public void setBgColor(int[] nArray) {
        this.background = nArray[0] << 16 | nArray[1] << 8 | nArray[2];
    }

    public void setBgColor(double[] dArray) {
        this.setBgColor(new int[]{(int)dArray[0], (int)dArray[1], (int)dArray[2]});
    }

    public int getBgColor() {
        return this.background;
    }

    public void setFgColor(int n) {
        this.pen = n;
        this.brush = n;
    }

    public void setFgColor(int[] nArray) {
        this.brush = this.pen = nArray[0] << 16 | nArray[1] << 8 | nArray[2];
    }

    public void setFgColor(double[] dArray) {
        this.setPenColor(new int[]{(int)dArray[0], (int)dArray[1], (int)dArray[2]});
        this.setBrushColor(this.pen);
    }

    public void setPenColor(int n) {
        this.pen = n;
    }

    public void setPenColor(int[] nArray) {
        this.pen = nArray[0] << 16 | nArray[1] << 8 | nArray[2];
    }

    public void setPenColor(double[] dArray) {
        this.setPenColor(new int[]{(int)dArray[0], (int)dArray[1], (int)dArray[2]});
    }

    public int getPenColor() {
        return this.pen;
    }

    public void setBrushColor(int n) {
        this.brush = n;
    }

    public void setBrushColor(int[] nArray) {
        this.brush = nArray[0] << 16 | nArray[1] << 8 | nArray[2];
    }

    public void setBrushColor(double[] dArray) {
        this.setBrushColor(new int[]{(int)dArray[0], (int)dArray[1], (int)dArray[2]});
    }

    public int getBrushColor() {
        return this.brush;
    }

    public void setBorder(int n, boolean bl) {
        this.properties = bl ? (this.properties |= n) : (this.properties &= ~n & 0xFFFFFF);
    }

    public boolean getBorder(int n) {
        return (this.properties & n) != 0;
    }

    public void setNoBorders() {
        this.properties &= 0xF0FFFF;
    }

    public void setTextAlignment(int n) {
        this.properties &= 0xCFFFFF;
        this.properties |= n & 0x300000;
    }

    public int getTextAlignment() {
        return this.properties & 0x300000;
    }

    public void setUnderline(boolean bl) {
        this.properties = bl ? (this.properties |= 0x400000) : (this.properties &= 0xBFFFFF);
    }

    public boolean getUnderline() {
        return (this.properties & 0x400000) != 0;
    }

    public void setStrikeout(boolean bl) {
        this.properties = bl ? (this.properties |= 0x800000) : (this.properties &= 0x7FFFFF);
    }

    public boolean getStrikeout() {
        return (this.properties & 0x800000) != 0;
    }

    public void setFallbackFont(Font font) {
        this.fallbackFont = font;
    }

    public Font getFallbackFont() {
        return this.fallbackFont;
    }

    public void setVerticalAlignment(int n) {
        this.valign = n;
    }

    public int getVerticalAlignment() {
        return this.valign;
    }

    public void setTextColors(Map<String, Integer> map) {
        this.colors = map;
    }

    public Map<String, Integer> getTextColors() {
        return this.colors;
    }

    @Override
    public float[] drawOn(Page page) throws Exception {
        return this.drawOn(page, true);
    }

    public float[] drawOn(Page page, boolean bl) throws Exception {
        return this.drawTextAndBorders(page, bl);
    }

    private void drawBackground(Page page) throws Exception {
        page.setBrushColor(this.background);
        page.fillRect(this.x, this.y, this.width, this.height);
    }

    private void drawBorders(Page page) throws Exception {
        page.setPenColor(this.pen);
        page.setPenWidth(this.lineWidth);
        if (this.getBorder(65536) && this.getBorder(131072) && this.getBorder(262144) && this.getBorder(524288)) {
            page.drawRect(this.x, this.y, this.width, this.height);
        } else {
            if (this.getBorder(65536)) {
                page.moveTo(this.x, this.y);
                page.lineTo(this.x + this.width, this.y);
                page.strokePath();
            }
            if (this.getBorder(131072)) {
                page.moveTo(this.x, this.y + this.height);
                page.lineTo(this.x + this.width, this.y + this.height);
                page.strokePath();
            }
            if (this.getBorder(262144)) {
                page.moveTo(this.x, this.y);
                page.lineTo(this.x, this.y + this.height);
                page.strokePath();
            }
            if (this.getBorder(524288)) {
                page.moveTo(this.x + this.width, this.y);
                page.lineTo(this.x + this.width, this.y + this.height);
                page.strokePath();
            }
        }
    }

    private float[] drawTextAndBorders(Page page, boolean bl) throws Exception {
        String string;
        int n;
        if (bl) {
            if (this.getBgColor() != 0xFFFFFF) {
                this.drawBackground(page);
            }
            page.setPenColor(this.pen);
            page.setBrushColor(this.brush);
            page.setPenWidth(this.font.underlineThickness);
        }
        float f = this.width - 2.0f * this.margin;
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        String[] stringArray = this.text.split("\\r?\\n");
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            String string3 = "  ";
            if (this.font.stringWidth(string2) < f - this.font.stringWidth(string3)) {
                arrayList.add(string2);
                continue;
            }
            stringBuilder.setLength(0);
            for (n = 0; n < string2.length(); ++n) {
                stringBuilder.append(string2.charAt(n));
                if (!(this.font.stringWidth(stringBuilder.toString()) >= f - this.font.stringWidth(string3))) continue;
                while (n > 0 && string2.charAt(n) != ' ') {
                    --n;
                }
                string = string2.substring(0, n).replaceAll("\\s+$", "");
                arrayList.add(string);
                stringBuilder.setLength(0);
                while (n < string2.length() && string2.charAt(n) == ' ') {
                    ++n;
                }
                string2 = string2.substring(n);
                n = 0;
            }
            if (string2.equals("")) continue;
            arrayList.add(string2);
        }
        stringArray = arrayList.toArray(new String[0]);
        float f2 = this.font.getBodyHeight() + this.spacing;
        float f3 = this.y + this.font.ascent + this.margin;
        if (this.height > 0.0f) {
            if (this.valign == 0x500000) {
                f3 += this.height - (float)stringArray.length * f2;
            } else if (this.valign == 0x100000) {
                f3 += (this.height - (float)stringArray.length * f2) / 2.0f;
            }
            for (n = 0; n < stringArray.length; ++n) {
                float f4 = this.getTextAlignment() == 0x200000 ? this.x + this.width - (this.font.stringWidth(stringArray[n]) + this.margin) : (this.getTextAlignment() == 0x100000 ? this.x + (this.width - this.font.stringWidth(stringArray[n])) / 2.0f : this.x + this.margin);
                if (f3 + this.font.getBodyHeight() + this.spacing + this.font.getDescent() >= this.y + this.height && n < stringArray.length - 1) {
                    string = stringArray[n];
                    int n2 = string.lastIndexOf(32);
                    stringArray[n] = n2 != -1 ? string.substring(0, n2) + " ..." : string + " ...";
                }
                if (!(f3 + this.font.getDescent() < this.y + this.height)) continue;
                if (bl) {
                    this.drawText(page, this.font, this.fallbackFont, stringArray[n], f4, f3, this.colors);
                }
                f3 += this.font.getBodyHeight() + this.spacing;
            }
        } else {
            for (n = 0; n < stringArray.length; ++n) {
                float f5 = this.getTextAlignment() == 0x200000 ? this.x + this.width - (this.font.stringWidth(stringArray[n]) + this.margin) : (this.getTextAlignment() == 0x100000 ? this.x + (this.width - this.font.stringWidth(stringArray[n])) / 2.0f : this.x + this.margin);
                if (bl) {
                    this.drawText(page, this.font, this.fallbackFont, stringArray[n], f5, f3, this.colors);
                }
                f3 += this.font.getBodyHeight() + this.spacing;
            }
            this.height = f3 - (this.y + this.font.ascent + this.margin);
        }
        if (bl) {
            this.drawBorders(page);
        }
        return new float[]{this.x + this.width, this.y + this.height};
    }

    private void drawText(Page page, Font font, Font font2, String string, float f, float f2, Map<String, Integer> map) throws Exception {
        float f3;
        if (font2 == null) {
            if (map == null) {
                page.drawString(font, string, f, f2);
            } else {
                page.drawString(font, string, f, f2, map);
            }
        } else {
            page.drawString(font, font2, string, f, f2);
        }
        float f4 = font.stringWidth(string);
        if (this.getUnderline()) {
            f3 = font.underlinePosition;
            page.moveTo(f, f2 + f3);
            page.lineTo(f + f4, f2 + f3);
            page.strokePath();
        }
        if (this.getStrikeout()) {
            f3 = font.body_height / 4.0f;
            page.moveTo(f, f2 - f3);
            page.lineTo(f + f4, f2 - f3);
            page.strokePath();
        }
    }
}

