/*
 * Decompiled with CFR 0.152.
 */
package com.pdfjet;

import com.pdfjet.Font;
import com.pdfjet.Page;
import com.pdfjet.Paragraph;
import com.pdfjet.TextLine;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextFrame {
    private List<Paragraph> paragraphs;
    private Font font;
    private Font fallbackFont;
    private float x;
    private float y;
    private float w;
    private float h;
    private float x_text;
    private float y_text;
    private float leading;
    private float paragraphLeading;
    private List<float[]> beginParagraphPoints;
    private List<float[]> endParagraphPoints;
    private float spaceBetweenTextLines;

    public TextFrame(List<Paragraph> list) throws Exception {
        if (list != null) {
            this.paragraphs = list;
            this.font = list.get((int)0).list.get(0).getFont();
            this.fallbackFont = list.get((int)0).list.get(0).getFallbackFont();
            this.leading = this.font.getBodyHeight();
            this.paragraphLeading = 2.0f * this.leading;
            this.beginParagraphPoints = new ArrayList<float[]>();
            this.endParagraphPoints = new ArrayList<float[]>();
            this.spaceBetweenTextLines = this.font.stringWidth(this.fallbackFont, " ");
        }
    }

    public TextFrame setLocation(float f, float f2) {
        this.x = f;
        this.y = f2;
        return this;
    }

    public TextFrame setWidth(float f) {
        this.w = f;
        return this;
    }

    public TextFrame setHeight(float f) {
        this.h = f;
        return this;
    }

    public TextFrame setLeading(float f) {
        this.leading = f;
        return this;
    }

    public TextFrame setParagraphLeading(float f) {
        this.paragraphLeading = f;
        return this;
    }

    public List<float[]> getBeginParagraphPoints() {
        return this.beginParagraphPoints;
    }

    public List<float[]> getEndParagraphPoints() {
        return this.endParagraphPoints;
    }

    public TextFrame setSpaceBetweenTextLines(float f) {
        this.spaceBetweenTextLines = f;
        return this;
    }

    public List<Paragraph> getParagraphs() {
        return this.paragraphs;
    }

    public TextFrame drawOn(Page page) throws Exception {
        return this.drawOn(page, true);
    }

    public TextFrame drawOn(Page page, boolean bl) throws Exception {
        this.x_text = this.x;
        this.y_text = this.y + this.font.getAscent();
        Paragraph paragraph = null;
        for (int i = 0; i < this.paragraphs.size(); ++i) {
            paragraph = this.paragraphs.get(i);
            StringBuilder stringBuilder = new StringBuilder();
            for (TextLine textLine : paragraph.list) {
                stringBuilder.append(textLine.getText());
            }
            int n = paragraph.list.size();
            for (int j = 0; j < n; ++j) {
                TextLine textLine = paragraph.list.get(j);
                if (j == 0) {
                    this.beginParagraphPoints.add(new float[]{this.x_text, this.y_text});
                }
                textLine.setAltDescription(j == 0 ? stringBuilder.toString() : " ");
                textLine.setActualText(j == 0 ? stringBuilder.toString() : " ");
                TextLine textLine2 = this.drawTextLine(page, this.x_text, this.y_text, textLine, bl);
                if (textLine2.getText() != null) {
                    ArrayList<Paragraph> arrayList = new ArrayList<Paragraph>();
                    Paragraph paragraph2 = new Paragraph(textLine2);
                    ++j;
                    while (j < n) {
                        paragraph2.add(paragraph.list.get(j));
                        ++j;
                    }
                    arrayList.add(paragraph2);
                    ++i;
                    while (i < this.paragraphs.size()) {
                        arrayList.add(this.paragraphs.get(i));
                        ++i;
                    }
                    return new TextFrame(arrayList);
                }
                if (j == n - 1) {
                    this.endParagraphPoints.add(new float[]{textLine2.x, textLine2.y});
                }
                this.x_text = textLine2.x;
                if (textLine.getTrailingSpace()) {
                    this.x_text += this.spaceBetweenTextLines;
                }
                this.y_text = textLine2.y;
            }
            this.x_text = this.x;
            this.y_text += this.paragraphLeading;
        }
        TextFrame textFrame = new TextFrame(null);
        textFrame.setLocation(this.x_text, this.y_text + this.font.getDescent());
        return textFrame;
    }

    public TextLine drawTextLine(Page page, float f, float f2, TextLine textLine, boolean bl) throws Exception {
        TextLine textLine2 = null;
        Font font = textLine.getFont();
        Font font2 = textLine.getFallbackFont();
        int n = textLine.getColor();
        StringBuilder stringBuilder = new StringBuilder();
        String[] stringArray = textLine.getText().split("\\s+");
        boolean bl2 = true;
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            String string2 = string = i == 0 ? stringArray[i] : " " + stringArray[i];
            if (font.stringWidth(font2, string) < this.w - (f - this.x)) {
                stringBuilder.append(string);
                f += font.stringWidth(font2, string);
                continue;
            }
            if (bl) {
                new TextLine(font, stringBuilder.toString()).setFallbackFont(font2).setLocation(f - font.stringWidth(font2, stringBuilder.toString()), f2 + textLine.getVerticalOffset()).setColor(n).setUnderline(textLine.getUnderline()).setStrikeout(textLine.getStrikeout()).setLanguage(textLine.getLanguage()).setAltDescription(bl2 ? textLine.getAltDescription() : " ").setActualText(bl2 ? textLine.getActualText() : " ").drawOn(page);
                bl2 = false;
            }
            f = this.x + font.stringWidth(font2, stringArray[i]);
            f2 += this.leading;
            stringBuilder.setLength(0);
            stringBuilder.append(stringArray[i]);
            if (!(f2 + font.getDescent() > this.y + this.h)) continue;
            ++i;
            while (i < stringArray.length) {
                stringBuilder.append(" ");
                stringBuilder.append(stringArray[i]);
                ++i;
            }
            textLine2 = new TextLine(font, stringBuilder.toString());
            textLine2.setLocation(this.x, f2);
            return textLine2;
        }
        if (bl) {
            new TextLine(font, stringBuilder.toString()).setFallbackFont(font2).setLocation(f - font.stringWidth(font2, stringBuilder.toString()), f2 + textLine.getVerticalOffset()).setColor(n).setUnderline(textLine.getUnderline()).setStrikeout(textLine.getStrikeout()).setLanguage(textLine.getLanguage()).setAltDescription(bl2 ? textLine.getAltDescription() : " ").setActualText(bl2 ? textLine.getActualText() : " ").drawOn(page);
            bl2 = false;
        }
        textLine2 = new TextLine(font, null);
        textLine2.setLocation(f, f2);
        return textLine2;
    }
}

