/*
 * Decompiled with CFR 0.152.
 */
package com.pdfjet;

import com.pdfjet.Annotation;
import com.pdfjet.Box;
import com.pdfjet.Drawable;
import com.pdfjet.Font;
import com.pdfjet.Page;

public class TextLine
implements Drawable {
    protected float x;
    protected float y;
    protected Font font;
    protected Font fallbackFont;
    protected String str;
    protected boolean trailingSpace = true;
    private String uri;
    private String key;
    private boolean underline = false;
    private boolean strikeout = false;
    private String underlineTTS = "underline";
    private String strikeoutTTS = "strikeout";
    private int degrees = 0;
    private int color = 0;
    private float box_x;
    private float box_y;
    private int textEffect = 0;
    private float verticalOffset = 0.0f;
    private String language = null;
    private String altDescription = null;
    private String actualText = null;
    private String uriLanguage = null;
    private String uriAltDescription = null;
    private String uriActualText = null;

    public TextLine(Font font) {
        this.font = font;
    }

    public TextLine(Font font, String string) {
        this.font = font;
        this.str = string;
        if (this.altDescription == null) {
            this.altDescription = string;
        }
        if (this.actualText == null) {
            this.actualText = string;
        }
    }

    public TextLine setText(String string) {
        this.str = string;
        if (this.altDescription == null) {
            this.altDescription = string;
        }
        if (this.actualText == null) {
            this.actualText = string;
        }
        return this;
    }

    public String getText() {
        return this.str;
    }

    public TextLine setPosition(double d, double d2) {
        return this.setLocation((float)d, (float)d2);
    }

    public TextLine setPosition(float f, float f2) {
        return this.setLocation(f, f2);
    }

    public TextLine setLocation(float f, float f2) {
        this.x = f;
        this.y = f2;
        return this;
    }

    public TextLine setFont(Font font) {
        this.font = font;
        return this;
    }

    public Font getFont() {
        return this.font;
    }

    public TextLine setFontSize(float f) {
        this.font.setSize(f);
        return this;
    }

    public TextLine setFallbackFont(Font font) {
        this.fallbackFont = font;
        return this;
    }

    public TextLine setFallbackFontSize(float f) {
        this.fallbackFont.setSize(f);
        return this;
    }

    public Font getFallbackFont() {
        return this.fallbackFont;
    }

    public TextLine setColor(int n) {
        this.color = n;
        return this;
    }

    public TextLine setColor(int[] nArray) {
        this.color = nArray[0] << 16 | nArray[1] << 8 | nArray[2];
        return this;
    }

    public int getColor() {
        return this.color;
    }

    public float getDestinationY() {
        return this.y - this.font.getSize();
    }

    public float getY() {
        return this.getDestinationY();
    }

    public float getWidth() {
        if (this.fallbackFont == null) {
            return this.font.stringWidth(this.str);
        }
        return this.font.stringWidth(this.fallbackFont, this.str);
    }

    public float getHeight() {
        return this.font.getHeight();
    }

    public TextLine setURIAction(String string) {
        this.uri = string;
        return this;
    }

    public String getURIAction() {
        return this.uri;
    }

    public TextLine setGoToAction(String string) {
        this.key = string;
        return this;
    }

    public String getGoToAction() {
        return this.key;
    }

    public TextLine setUnderline(boolean bl) {
        this.underline = bl;
        return this;
    }

    public boolean getUnderline() {
        return this.underline;
    }

    public TextLine setStrikeout(boolean bl) {
        this.strikeout = bl;
        return this;
    }

    public boolean getStrikeout() {
        return this.strikeout;
    }

    public TextLine setTextDirection(int n) {
        this.degrees = n;
        return this;
    }

    public int getTextDirection() {
        return this.degrees;
    }

    public TextLine setTextEffect(int n) {
        this.textEffect = n;
        return this;
    }

    public int getTextEffect() {
        return this.textEffect;
    }

    public TextLine setVerticalOffset(float f) {
        this.verticalOffset = f;
        return this;
    }

    public float getVerticalOffset() {
        return this.verticalOffset;
    }

    public TextLine setTrailingSpace(boolean bl) {
        this.trailingSpace = bl;
        return this;
    }

    public boolean getTrailingSpace() {
        return this.trailingSpace;
    }

    public TextLine setLanguage(String string) {
        this.language = string;
        return this;
    }

    public String getLanguage() {
        return this.language;
    }

    public TextLine setAltDescription(String string) {
        this.altDescription = string;
        return this;
    }

    public String getAltDescription() {
        return this.altDescription;
    }

    public TextLine setActualText(String string) {
        this.actualText = string;
        return this;
    }

    public String getActualText() {
        return this.actualText;
    }

    public TextLine setURILanguage(String string) {
        this.uriLanguage = string;
        return this;
    }

    public TextLine setURIAltDescription(String string) {
        this.uriAltDescription = string;
        return this;
    }

    public TextLine setURIActualText(String string) {
        this.uriActualText = string;
        return this;
    }

    public TextLine placeIn(Box box) throws Exception {
        this.placeIn(box, 0.0f, 0.0f);
        return this;
    }

    public TextLine placeIn(Box box, double d, double d2) throws Exception {
        return this.placeIn(box, (float)d, (float)d2);
    }

    public TextLine placeIn(Box box, float f, float f2) throws Exception {
        this.box_x = box.x + f;
        this.box_y = box.y + f2;
        return this;
    }

    public float[] drawOn(Page page) throws Exception {
        return this.drawOn(page, true);
    }

    protected float[] drawOn(Page page, boolean bl) throws Exception {
        double d;
        double d2;
        double d3;
        double d4;
        float f;
        if (page == null || !bl || this.str == null || this.str.equals("")) {
            return new float[]{this.x, this.y};
        }
        page.setTextDirection(this.degrees);
        this.x += this.box_x;
        this.y += this.box_y;
        page.setBrushColor(this.color);
        page.addBMC("Span", this.language, this.altDescription, this.actualText);
        if (this.fallbackFont == null) {
            page.drawString(this.font, this.str, this.x, this.y);
        } else {
            page.drawString(this.font, this.fallbackFont, this.str, this.x, this.y);
        }
        page.addEMC();
        double d5 = Math.PI * (double)this.degrees / 180.0;
        if (this.underline) {
            page.setPenWidth(this.font.underlineThickness);
            page.setPenColor(this.color);
            f = this.font.stringWidth(this.str);
            d4 = (double)this.font.underlinePosition * Math.sin(d5);
            d3 = (double)this.font.underlinePosition * Math.cos(d5);
            d2 = (double)this.x + (double)f * Math.cos(d5);
            d = (double)this.y - (double)f * Math.sin(d5);
            page.addBMC("Span", this.language, this.underlineTTS, this.underlineTTS);
            page.moveTo((double)this.x + d4, (double)this.y + d3);
            page.lineTo(d2 + d4, d + d3);
            page.strokePath();
            page.addEMC();
        }
        if (this.strikeout) {
            page.setPenWidth(this.font.underlineThickness);
            page.setPenColor(this.color);
            f = this.font.stringWidth(this.str);
            d4 = (double)this.font.body_height / 4.0 * Math.sin(d5);
            d3 = (double)this.font.body_height / 4.0 * Math.cos(d5);
            d2 = (double)this.x + (double)f * Math.cos(d5);
            d = (double)this.y - (double)f * Math.sin(d5);
            page.addBMC("Span", this.language, this.strikeoutTTS, this.strikeoutTTS);
            page.moveTo((double)this.x - d4, (double)this.y - d3);
            page.lineTo(d2 - d4, d - d3);
            page.strokePath();
            page.addEMC();
        }
        if (this.uri != null || this.key != null) {
            page.addAnnotation(new Annotation(this.uri, this.key, this.x, page.height - (this.y - this.font.ascent), this.x + this.font.stringWidth(this.str), page.height - (this.y - this.font.descent), this.uriLanguage, this.uriAltDescription, this.uriActualText));
        }
        page.setTextDirection(0);
        f = this.font.stringWidth(this.str);
        d4 = Math.max((double)this.x, (double)this.x + (double)f * Math.cos(d5));
        d3 = Math.max((double)this.y, (double)this.y - (double)f * Math.sin(d5));
        return new float[]{(float)d4, (float)d3};
    }
}

