/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.event;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.SpringProxy;
import org.springframework.aop.scope.ScopedProxyUtils;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.event.ApplicationListenerMethodAdapter;
import org.springframework.context.event.EventExpressionEvaluator;
import org.springframework.context.event.EventListener;
import org.springframework.context.event.EventListenerFactory;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventListenerMethodProcessor
implements SmartInitializingSingleton,
ApplicationContextAware {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private ConfigurableApplicationContext applicationContext;
    private final EventExpressionEvaluator evaluator = new EventExpressionEvaluator();
    private final Set<Class<?>> nonAnnotatedClasses = Collections.newSetFromMap(new ConcurrentHashMap(64));

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Assert.isTrue((boolean)(applicationContext instanceof ConfigurableApplicationContext), (String)"ApplicationContext does not implement ConfigurableApplicationContext");
        this.applicationContext = (ConfigurableApplicationContext)applicationContext;
    }

    protected List<EventListenerFactory> getEventListenerFactories() {
        Map beans = this.applicationContext.getBeansOfType(EventListenerFactory.class);
        ArrayList<EventListenerFactory> allFactories = new ArrayList<EventListenerFactory>(beans.values());
        AnnotationAwareOrderComparator.sort(allFactories);
        return allFactories;
    }

    public void afterSingletonsInstantiated() {
        String[] allBeanNames;
        List<EventListenerFactory> factories = this.getEventListenerFactories();
        for (String beanName : allBeanNames = this.applicationContext.getBeanNamesForType(Object.class)) {
            if (ScopedProxyUtils.isScopedTarget((String)beanName)) continue;
            Class type = this.applicationContext.getType(beanName);
            try {
                this.processBean(factories, beanName, type);
            }
            catch (RuntimeException e) {
                throw new BeanInitializationException("Failed to process @EventListener annotation on bean with name '" + beanName + "'", (Throwable)e);
            }
        }
    }

    protected void processBean(List<EventListenerFactory> factories, String beanName, Class<?> type) {
        Class<?> targetType = this.getTargetClass(beanName, type);
        if (!this.nonAnnotatedClasses.contains(targetType)) {
            Method[] methods;
            LinkedHashSet<Method> annotatedMethods = new LinkedHashSet<Method>(1);
            block0: for (Method method : methods = ReflectionUtils.getUniqueDeclaredMethods(targetType)) {
                EventListener eventListener = (EventListener)AnnotationUtils.findAnnotation((Method)method, EventListener.class);
                if (eventListener == null) continue;
                for (EventListenerFactory factory : factories) {
                    ApplicationListener<?> applicationListener;
                    if (!factory.supportsMethod(method)) continue;
                    if (!type.equals(targetType)) {
                        method = this.getProxyMethod(type, method);
                    }
                    if ((applicationListener = factory.createApplicationListener(beanName, type, method)) instanceof ApplicationListenerMethodAdapter) {
                        ((ApplicationListenerMethodAdapter)applicationListener).init(this.applicationContext, this.evaluator);
                    }
                    this.applicationContext.addApplicationListener(applicationListener);
                    annotatedMethods.add(method);
                    continue block0;
                }
            }
            if (annotatedMethods.isEmpty()) {
                this.nonAnnotatedClasses.add(type);
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)("No @EventListener annotations found on bean class: " + type));
                }
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)(annotatedMethods.size() + " @EventListener methods processed on bean '" + beanName + "': " + annotatedMethods));
            }
        }
    }

    private Class<?> getTargetClass(String beanName, Class<?> type) {
        if (SpringProxy.class.isAssignableFrom(type)) {
            Object bean = this.applicationContext.getBean(beanName);
            return AopUtils.getTargetClass((Object)bean);
        }
        return type;
    }

    private Method getProxyMethod(Class<?> proxyType, Method method) {
        try {
            return proxyType.getMethod(method.getName(), method.getParameterTypes());
        }
        catch (SecurityException ex) {
            ReflectionUtils.handleReflectionException((Exception)ex);
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalStateException(String.format("@EventListener method '%s' found on bean target class '%s', but not found in any interface(s) for bean JDK proxy. Either pull the method up to an interface or switch to subclass (CGLIB) proxies by setting proxy-target-class/proxyTargetClass attribute to 'true'", method.getName(), method.getDeclaringClass().getSimpleName()));
        }
        return null;
    }
}

