/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.validation;

import org.springframework.beans.ConfigurablePropertyAccessor;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.util.Assert;
import org.springframework.validation.AbstractPropertyBindingResult;

public class DirectFieldBindingResult
extends AbstractPropertyBindingResult {
    private final Object target;
    private final boolean autoGrowNestedPaths;
    private transient ConfigurablePropertyAccessor directFieldAccessor;

    public DirectFieldBindingResult(Object target, String objectName) {
        this(target, objectName, true);
    }

    public DirectFieldBindingResult(Object target, String objectName, boolean autoGrowNestedPaths) {
        super(objectName);
        this.target = target;
        this.autoGrowNestedPaths = autoGrowNestedPaths;
    }

    public final Object getTarget() {
        return this.target;
    }

    public final ConfigurablePropertyAccessor getPropertyAccessor() {
        if (this.directFieldAccessor == null) {
            this.directFieldAccessor = this.createDirectFieldAccessor();
            this.directFieldAccessor.setExtractOldValueForEditor(true);
            this.directFieldAccessor.setAutoGrowNestedPaths(this.autoGrowNestedPaths);
        }
        return this.directFieldAccessor;
    }

    protected ConfigurablePropertyAccessor createDirectFieldAccessor() {
        Assert.state((this.target != null ? 1 : 0) != 0, (String)("Cannot access fields on null target instance '" + this.getObjectName() + "'!"));
        return PropertyAccessorFactory.forDirectFieldAccess((Object)this.target);
    }
}

