/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.core.annotation.AnnotationConfigurationException;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationAttributes
extends LinkedHashMap<String, Object> {
    private final Class<? extends Annotation> annotationType;
    private final String displayName;

    public AnnotationAttributes() {
        this.annotationType = null;
        this.displayName = "unknown";
    }

    public AnnotationAttributes(Class<? extends Annotation> annotationType) {
        Assert.notNull(annotationType, "annotationType must not be null");
        this.annotationType = annotationType;
        this.displayName = annotationType.getName();
    }

    public AnnotationAttributes(int initialCapacity) {
        super(initialCapacity);
        this.annotationType = null;
        this.displayName = "unknown";
    }

    public AnnotationAttributes(Map<String, Object> map) {
        super(map);
        this.annotationType = null;
        this.displayName = "unknown";
    }

    public Class<? extends Annotation> annotationType() {
        return this.annotationType;
    }

    public String getString(String attributeName) {
        return this.getRequiredAttribute(attributeName, String.class);
    }

    public String getAliasedString(String attributeName, Class<? extends Annotation> annotationType, Object annotationSource) {
        return this.getRequiredAttributeWithAlias(attributeName, annotationType, annotationSource, String.class);
    }

    public String[] getStringArray(String attributeName) {
        return this.getRequiredAttribute(attributeName, String[].class);
    }

    public String[] getAliasedStringArray(String attributeName, Class<? extends Annotation> annotationType, Object annotationSource) {
        return this.getRequiredAttributeWithAlias(attributeName, annotationType, annotationSource, String[].class);
    }

    public boolean getBoolean(String attributeName) {
        return this.getRequiredAttribute(attributeName, Boolean.class);
    }

    public <N extends Number> N getNumber(String attributeName) {
        return (N)this.getRequiredAttribute(attributeName, Number.class);
    }

    public <E extends Enum<?>> E getEnum(String attributeName) {
        return (E)this.getRequiredAttribute(attributeName, Enum.class);
    }

    public <T> Class<? extends T> getClass(String attributeName) {
        return this.getRequiredAttribute(attributeName, Class.class);
    }

    public Class<?>[] getClassArray(String attributeName) {
        return this.getRequiredAttribute(attributeName, Class[].class);
    }

    public Class<?>[] getAliasedClassArray(String attributeName, Class<? extends Annotation> annotationType, Object annotationSource) {
        return this.getRequiredAttributeWithAlias(attributeName, annotationType, annotationSource, Class[].class);
    }

    public AnnotationAttributes getAnnotation(String attributeName) {
        return this.getRequiredAttribute(attributeName, AnnotationAttributes.class);
    }

    public <A extends Annotation> A getAnnotation(String attributeName, Class<A> annotationType) {
        return (A)((Annotation)this.getRequiredAttribute(attributeName, annotationType));
    }

    public AnnotationAttributes[] getAnnotationArray(String attributeName) {
        return this.getRequiredAttribute(attributeName, AnnotationAttributes[].class);
    }

    public <A extends Annotation> A[] getAnnotationArray(String attributeName, Class<A> annotationType) {
        Object array = Array.newInstance(annotationType, 0);
        return (Annotation[])this.getRequiredAttribute(attributeName, array.getClass());
    }

    private <T> T getRequiredAttribute(String attributeName, Class<T> expectedType) {
        Assert.hasText(attributeName, "attributeName must not be null or empty");
        Object value = this.get(attributeName);
        this.assertAttributePresence(attributeName, value);
        this.assertNotException(attributeName, value);
        if (!expectedType.isInstance(value) && expectedType.isArray() && expectedType.getComponentType().isInstance(value)) {
            Object array = Array.newInstance(expectedType.getComponentType(), 1);
            Array.set(array, 0, value);
            value = array;
        }
        this.assertAttributeType(attributeName, value, expectedType);
        return (T)value;
    }

    private <T> T getRequiredAttributeWithAlias(String attributeName, Class<? extends Annotation> annotationType, Object annotationSource, Class<T> expectedType) {
        Assert.hasText(attributeName, "attributeName must not be null or empty");
        Assert.notNull(annotationType, "annotationType must not be null");
        Assert.notNull(expectedType, "expectedType must not be null");
        T attributeValue = this.getAttribute(attributeName, expectedType);
        List<String> aliasNames = AnnotationUtils.getAttributeAliasMap(annotationType).get(attributeName);
        if (aliasNames != null) {
            for (String aliasName : aliasNames) {
                T aliasValue = this.getAttribute(aliasName, expectedType);
                boolean attributeEmpty = ObjectUtils.isEmpty(attributeValue);
                boolean aliasEmpty = ObjectUtils.isEmpty(aliasValue);
                if (!(attributeEmpty || aliasEmpty || ObjectUtils.nullSafeEquals(attributeValue, aliasValue))) {
                    String elementName = annotationSource == null ? "unknown element" : annotationSource.toString();
                    String msg = String.format("In annotation [%s] declared on [%s], attribute [%s] and its alias [%s] are present with values of [%s] and [%s], but only one is permitted.", annotationType.getName(), elementName, attributeName, aliasName, ObjectUtils.nullSafeToString(attributeValue), ObjectUtils.nullSafeToString(aliasValue));
                    throw new AnnotationConfigurationException(msg);
                }
                if (expectedType.isArray() && attributeValue == null && aliasValue != null) {
                    attributeValue = aliasValue;
                    continue;
                }
                if (!attributeEmpty || aliasEmpty) continue;
                attributeValue = aliasValue;
            }
            this.assertAttributePresence(attributeName, aliasNames, attributeValue);
        }
        return attributeValue;
    }

    private <T> T getAttribute(String attributeName, Class<T> expectedType) {
        Object value = this.get(attributeName);
        if (value != null) {
            this.assertNotException(attributeName, value);
            this.assertAttributeType(attributeName, value, expectedType);
        }
        return (T)value;
    }

    private void assertAttributePresence(String attributeName, Object attributeValue) {
        if (attributeValue == null) {
            throw new IllegalArgumentException(String.format("Attribute '%s' not found in attributes for annotation [%s]", attributeName, this.displayName));
        }
    }

    private void assertAttributePresence(String attributeName, List<String> aliases, Object attributeValue) {
        if (attributeValue == null) {
            throw new IllegalArgumentException(String.format("Neither attribute '%s' nor one of its aliases %s was found in attributes for annotation [%s]", attributeName, aliases, this.displayName));
        }
    }

    private void assertNotException(String attributeName, Object attributeValue) {
        if (attributeValue instanceof Exception) {
            throw new IllegalArgumentException(String.format("Attribute '%s' for annotation [%s] was not resolvable due to exception [%s]", attributeName, this.displayName, attributeValue), (Exception)attributeValue);
        }
    }

    private void assertAttributeType(String attributeName, Object attributeValue, Class<?> expectedType) {
        if (!expectedType.isInstance(attributeValue)) {
            throw new IllegalArgumentException(String.format("Attribute '%s' is of type [%s], but [%s] was expected in attributes for annotation [%s]", attributeName, attributeValue.getClass().getSimpleName(), expectedType.getSimpleName(), this.displayName));
        }
    }

    @Override
    public Object putIfAbsent(String key, Object value) {
        Object obj = this.get(key);
        if (obj == null) {
            obj = this.put(key, value);
        }
        return obj;
    }

    @Override
    public String toString() {
        Iterator entries = this.entrySet().iterator();
        StringBuilder sb = new StringBuilder("{");
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            sb.append((String)entry.getKey());
            sb.append('=');
            sb.append(this.valueToString(entry.getValue()));
            sb.append(entries.hasNext() ? ", " : "");
        }
        sb.append("}");
        return sb.toString();
    }

    private String valueToString(Object value) {
        if (value == this) {
            return "(this Map)";
        }
        if (value instanceof Object[]) {
            return "[" + StringUtils.arrayToDelimitedString((Object[])value, ", ") + "]";
        }
        return String.valueOf(value);
    }

    public static AnnotationAttributes fromMap(Map<String, Object> map) {
        if (map == null) {
            return null;
        }
        if (map instanceof AnnotationAttributes) {
            return (AnnotationAttributes)map;
        }
        return new AnnotationAttributes(map);
    }
}

