/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.convert.support;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalGenericConverter;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.lang.UsesJava8;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@UsesJava8
public class StreamConverter
implements ConditionalGenericConverter {
    private static final TypeDescriptor STREAM_TYPE = TypeDescriptor.valueOf(Stream.class);
    private static final Set<GenericConverter.ConvertiblePair> CONVERTIBLE_TYPES = StreamConverter.createConvertibleTypes();
    private final ConversionService conversionService;

    public StreamConverter(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    @Override
    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return CONVERTIBLE_TYPES;
    }

    @Override
    public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (sourceType.isAssignableTo(STREAM_TYPE)) {
            return this.matchesFromStream(sourceType.getElementTypeDescriptor(), targetType);
        }
        if (targetType.isAssignableTo(STREAM_TYPE)) {
            return this.matchesToStream(targetType.getElementTypeDescriptor(), sourceType);
        }
        return false;
    }

    public boolean matchesFromStream(TypeDescriptor elementType, TypeDescriptor targetType) {
        TypeDescriptor collectionOfElement = TypeDescriptor.collection(Collection.class, elementType);
        return this.conversionService.canConvert(collectionOfElement, targetType);
    }

    public boolean matchesToStream(TypeDescriptor elementType, TypeDescriptor sourceType) {
        TypeDescriptor collectionOfElement = TypeDescriptor.collection(Collection.class, elementType);
        return this.conversionService.canConvert(sourceType, collectionOfElement);
    }

    @Override
    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (sourceType.isAssignableTo(STREAM_TYPE)) {
            return this.convertFromStream((Stream)source, sourceType, targetType);
        }
        if (targetType.isAssignableTo(STREAM_TYPE)) {
            return this.convertToStream(source, sourceType, targetType);
        }
        throw new IllegalStateException("Unexpected source/target types");
    }

    private Object convertFromStream(Stream<?> source, TypeDescriptor streamType, TypeDescriptor targetType) {
        List content = source.collect(Collectors.toList());
        TypeDescriptor listType = TypeDescriptor.collection(List.class, streamType.getElementTypeDescriptor());
        return this.conversionService.convert(content, listType, targetType);
    }

    private Object convertToStream(Object source, TypeDescriptor sourceType, TypeDescriptor streamType) {
        TypeDescriptor targetCollection = TypeDescriptor.collection(List.class, streamType.getElementTypeDescriptor());
        List target = (List)this.conversionService.convert(source, sourceType, targetCollection);
        return target.stream();
    }

    private static Set<GenericConverter.ConvertiblePair> createConvertibleTypes() {
        HashSet<GenericConverter.ConvertiblePair> convertiblePairs = new HashSet<GenericConverter.ConvertiblePair>();
        convertiblePairs.add(new GenericConverter.ConvertiblePair(Stream.class, Collection.class));
        convertiblePairs.add(new GenericConverter.ConvertiblePair(Stream.class, Object[].class));
        convertiblePairs.add(new GenericConverter.ConvertiblePair(Collection.class, Stream.class));
        convertiblePairs.add(new GenericConverter.ConvertiblePair(Object[].class, Stream.class));
        return convertiblePairs;
    }
}

