/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.WritableResource;
import org.springframework.lang.UsesJava7;
import org.springframework.util.Assert;

@UsesJava7
public class PathResource
extends AbstractResource
implements WritableResource {
    private final Path path;

    public PathResource(Path path) {
        Assert.notNull(path, "Path must not be null");
        this.path = path.normalize();
    }

    public PathResource(String path) {
        Assert.notNull(path, "Path must not be null");
        this.path = Paths.get(path, new String[0]).normalize();
    }

    public PathResource(URI uri) {
        Assert.notNull(uri, "URI must not be null");
        this.path = Paths.get(uri).normalize();
    }

    public final String getPath() {
        return this.path.toString();
    }

    public boolean exists() {
        return Files.exists(this.path, new LinkOption[0]);
    }

    public boolean isReadable() {
        return Files.isReadable(this.path) && !Files.isDirectory(this.path, new LinkOption[0]);
    }

    public InputStream getInputStream() throws IOException {
        if (!this.exists()) {
            throw new FileNotFoundException(this.getPath() + " (no such file or directory)");
        }
        if (Files.isDirectory(this.path, new LinkOption[0])) {
            throw new FileNotFoundException(this.getPath() + " (is a directory)");
        }
        return Files.newInputStream(this.path, new OpenOption[0]);
    }

    public URL getURL() throws IOException {
        return this.path.toUri().toURL();
    }

    public URI getURI() throws IOException {
        return this.path.toUri();
    }

    public File getFile() throws IOException {
        try {
            return this.path.toFile();
        }
        catch (UnsupportedOperationException ex) {
            throw new FileNotFoundException(this.path + " cannot be resolved to " + "absolute file path");
        }
    }

    public long contentLength() throws IOException {
        return Files.size(this.path);
    }

    public long lastModified() throws IOException {
        return Files.getLastModifiedTime(this.path, new LinkOption[0]).toMillis();
    }

    public Resource createRelative(String relativePath) throws IOException {
        return new PathResource(this.path.resolve(relativePath));
    }

    public String getFilename() {
        return this.path.getFileName().toString();
    }

    public String getDescription() {
        return "path [" + this.path.toAbsolutePath() + "]";
    }

    public boolean isWritable() {
        return Files.isWritable(this.path) && !Files.isDirectory(this.path, new LinkOption[0]);
    }

    public OutputStream getOutputStream() throws IOException {
        if (Files.isDirectory(this.path, new LinkOption[0])) {
            throw new FileNotFoundException(this.getPath() + " (is a directory)");
        }
        return Files.newOutputStream(this.path, new OpenOption[0]);
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof PathResource && this.path.equals(((PathResource)obj).path);
    }

    public int hashCode() {
        return this.path.hashCode();
    }
}

