/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.DDC;
import com.microsoft.sqlserver.jdbc.DTV;
import com.microsoft.sqlserver.jdbc.DTVExecuteOp;
import com.microsoft.sqlserver.jdbc.DTVImpl;
import com.microsoft.sqlserver.jdbc.DataTypes;
import com.microsoft.sqlserver.jdbc.InputStreamGetterArgs;
import com.microsoft.sqlserver.jdbc.JDBCType;
import com.microsoft.sqlserver.jdbc.JavaType;
import com.microsoft.sqlserver.jdbc.ParameterUtils;
import com.microsoft.sqlserver.jdbc.ReaderInputStream;
import com.microsoft.sqlserver.jdbc.SQLCollation;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLServerSQLXML;
import com.microsoft.sqlserver.jdbc.StreamSetterArgs;
import com.microsoft.sqlserver.jdbc.StreamType;
import com.microsoft.sqlserver.jdbc.TDSReader;
import com.microsoft.sqlserver.jdbc.TypeInfo;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.Calendar;
import microsoft.sql.DateTimeOffset;

final class AppDTVImpl
extends DTVImpl {
    private JDBCType jdbcType = JDBCType.UNKNOWN;
    private Object value;
    private JavaType javaType;
    private StreamSetterArgs streamSetterArgs;
    private Calendar cal;
    private Integer scale;

    AppDTVImpl() {
    }

    final void skipValue(TypeInfo typeInfo, TDSReader tDSReader, boolean bl) throws SQLServerException {
        assert (false);
    }

    final void initFromCompressedNull() {
        assert (false);
    }

    void setValue(DTV dTV, SQLCollation sQLCollation, JDBCType jDBCType, Object object, JavaType javaType, StreamSetterArgs streamSetterArgs, Calendar calendar, Integer n, SQLServerConnection sQLServerConnection) throws SQLServerException {
        dTV.setValue(object, javaType);
        dTV.setJdbcType(jDBCType);
        dTV.setStreamSetterArgs(streamSetterArgs);
        dTV.setCalendar(calendar);
        dTV.setScale(n);
        dTV.executeOp(new SetValueOp(sQLCollation, sQLServerConnection));
    }

    void setValue(Object object, JavaType javaType) {
        this.value = object;
        this.javaType = javaType;
    }

    void setStreamSetterArgs(StreamSetterArgs streamSetterArgs) {
        this.streamSetterArgs = streamSetterArgs;
    }

    void setCalendar(Calendar calendar) {
        this.cal = calendar;
    }

    void setScale(Integer n) {
        this.scale = n;
    }

    StreamSetterArgs getStreamSetterArgs() {
        return this.streamSetterArgs;
    }

    Calendar getCalendar() {
        return this.cal;
    }

    Integer getScale() {
        return this.scale;
    }

    boolean isNull() {
        return null == this.value;
    }

    void setJdbcType(JDBCType jDBCType) {
        this.jdbcType = jDBCType;
    }

    JDBCType getJdbcType() {
        return this.jdbcType;
    }

    JavaType getJavaType() {
        return this.javaType;
    }

    Object getValue(DTV dTV, JDBCType jDBCType, int n, InputStreamGetterArgs inputStreamGetterArgs, Calendar calendar, TypeInfo typeInfo, TDSReader tDSReader) throws SQLServerException {
        if (this.jdbcType != jDBCType) {
            DataTypes.throwConversionError(this.jdbcType.toString(), jDBCType.toString());
        }
        return this.value;
    }

    Object getSetterValue() {
        return this.value;
    }

    final class SetValueOp
    extends DTVExecuteOp {
        private final SQLCollation collation;
        private final SQLServerConnection con;

        SetValueOp(SQLCollation sQLCollation, SQLServerConnection sQLServerConnection) {
            this.collation = sQLCollation;
            this.con = sQLServerConnection;
        }

        void execute(DTV dTV, String string) throws SQLServerException {
            JDBCType jDBCType = dTV.getJdbcType();
            if (JDBCType.DECIMAL == jDBCType || JDBCType.NUMERIC == jDBCType) {
                assert (null != string);
                try {
                    dTV.setValue(new BigDecimal(string), JavaType.BIGDECIMAL);
                }
                catch (NumberFormatException numberFormatException) {
                    DataTypes.throwConversionError("String", jDBCType.toString());
                }
            } else if (jDBCType.isBinary()) {
                assert (null != string);
                dTV.setValue(ParameterUtils.HexToBin(string), JavaType.BYTEARRAY);
            } else if (null != this.collation && (JDBCType.CHAR == jDBCType || JDBCType.VARCHAR == jDBCType || JDBCType.LONGVARCHAR == jDBCType || JDBCType.CLOB == jDBCType)) {
                byte[] byArray = null;
                if (null != string) {
                    try {
                        byArray = string.getBytes(this.collation.getCharset());
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_encodingErrorWritingTDS"));
                        Object[] objectArray = new Object[]{new String(unsupportedEncodingException.getMessage())};
                        SQLServerException.makeFromDriverError(this.con, null, messageFormat.format(objectArray), null, true);
                    }
                }
                dTV.setValue(byArray, JavaType.BYTEARRAY);
            }
        }

        void execute(DTV dTV, Clob clob) throws SQLServerException {
            assert (null != clob);
            try {
                DataTypes.getCheckedLength(this.con, dTV.getJdbcType(), clob.length(), false);
            }
            catch (SQLException sQLException) {
                SQLServerException.makeFromDriverError(this.con, null, sQLException.getMessage(), null, false);
            }
        }

        void execute(DTV dTV, SQLServerSQLXML sQLServerSQLXML) throws SQLServerException {
        }

        void execute(DTV dTV, Byte by) throws SQLServerException {
        }

        void execute(DTV dTV, Integer n) throws SQLServerException {
        }

        void execute(DTV dTV, Time time) throws SQLServerException {
            if (dTV.getJdbcType().isTextual()) {
                assert (time != null) : "value is null";
                dTV.setValue(time.toString(), JavaType.STRING);
            }
        }

        void execute(DTV dTV, Date date) throws SQLServerException {
            if (dTV.getJdbcType().isTextual()) {
                assert (date != null) : "value is null";
                dTV.setValue(date.toString(), JavaType.STRING);
            }
        }

        void execute(DTV dTV, Timestamp timestamp) throws SQLServerException {
            if (dTV.getJdbcType().isTextual()) {
                assert (timestamp != null) : "value is null";
                dTV.setValue(timestamp.toString(), JavaType.STRING);
            }
        }

        void execute(DTV dTV, DateTimeOffset dateTimeOffset) throws SQLServerException {
        }

        void execute(DTV dTV, Float f) throws SQLServerException {
        }

        void execute(DTV dTV, Double d) throws SQLServerException {
        }

        void execute(DTV dTV, BigDecimal bigDecimal) throws SQLServerException {
            Integer n;
            if (null != bigDecimal && null != (n = dTV.getScale()) && n.intValue() != bigDecimal.scale()) {
                bigDecimal = bigDecimal.setScale((int)n, 1);
            }
            dTV.setValue(bigDecimal, JavaType.BIGDECIMAL);
        }

        void execute(DTV dTV, Long l) throws SQLServerException {
        }

        void execute(DTV dTV, Short s) throws SQLServerException {
        }

        void execute(DTV dTV, Boolean bl) throws SQLServerException {
        }

        void execute(DTV dTV, byte[] byArray) throws SQLServerException {
        }

        void execute(DTV dTV, Blob blob) throws SQLServerException {
            assert (null != blob);
            try {
                DataTypes.getCheckedLength(this.con, dTV.getJdbcType(), blob.length(), false);
            }
            catch (SQLException sQLException) {
                SQLServerException.makeFromDriverError(this.con, null, sQLException.getMessage(), null, false);
            }
        }

        void execute(DTV dTV, InputStream inputStream) throws SQLServerException {
            DataTypes.getCheckedLength(this.con, dTV.getJdbcType(), dTV.getStreamSetterArgs().getLength(), true);
            if (JDBCType.NCHAR == AppDTVImpl.this.jdbcType || JDBCType.NVARCHAR == AppDTVImpl.this.jdbcType || JDBCType.LONGNVARCHAR == AppDTVImpl.this.jdbcType) {
                InputStreamReader inputStreamReader = null;
                try {
                    inputStreamReader = new InputStreamReader(inputStream, "US-ASCII");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new SQLServerException(null, unsupportedEncodingException.getMessage(), null, 0, true);
                }
                dTV.setValue(inputStreamReader, JavaType.READER);
                this.execute(dTV, inputStreamReader);
            }
        }

        void execute(DTV dTV, Reader reader) throws SQLServerException {
            assert (null != reader);
            JDBCType jDBCType = dTV.getJdbcType();
            long l = DataTypes.getCheckedLength(this.con, dTV.getJdbcType(), dTV.getStreamSetterArgs().getLength(), true);
            if (jDBCType.isBinary()) {
                String string = DDC.convertReaderToString(reader, (int)l);
                if (-1L != l && (long)string.length() != l) {
                    MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_mismatchedStreamLength"));
                    Object[] objectArray = new Object[]{l, string.length()};
                    SQLServerException.makeFromDriverError(null, null, messageFormat.format(objectArray), "", true);
                }
                dTV.setValue(string, JavaType.STRING);
                this.execute(dTV, string);
            } else if (null != this.collation && (JDBCType.CHAR == jDBCType || JDBCType.VARCHAR == jDBCType || JDBCType.LONGVARCHAR == jDBCType || JDBCType.CLOB == jDBCType)) {
                ReaderInputStream readerInputStream = null;
                try {
                    readerInputStream = new ReaderInputStream(reader, this.collation.getCharset(), l);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_encodingErrorWritingTDS"));
                    Object[] objectArray = new Object[]{new String(unsupportedEncodingException.getMessage())};
                    SQLServerException.makeFromDriverError(this.con, null, messageFormat.format(objectArray), null, true);
                }
                dTV.setValue(readerInputStream, JavaType.INPUTSTREAM);
                dTV.setStreamSetterArgs(new StreamSetterArgs(StreamType.CHARACTER, -1L));
                this.execute(dTV, readerInputStream);
            }
        }
    }
}

