/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerDataSource;
import com.microsoft.sqlserver.jdbc.SQLServerDriverBooleanProperty;
import com.microsoft.sqlserver.jdbc.SQLServerDriverStringProperty;
import com.microsoft.sqlserver.jdbc.SQLServerPooledConnection;
import com.microsoft.sqlserver.jdbc.SQLServerXADataSource;
import com.microsoft.sqlserver.jdbc.SQLServerXAResource;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;

public final class SQLServerXAConnection
extends SQLServerPooledConnection
implements XAConnection {
    private SQLServerXAResource XAResource;
    private SQLServerConnection physicalControlConnection;
    private Logger xaLogger = SQLServerXADataSource.xaLogger;

    SQLServerXAConnection(SQLServerDataSource sQLServerDataSource, String string, String string2) throws SQLException {
        super(sQLServerDataSource, string, string2);
        SQLServerConnection sQLServerConnection = this.getPhysicalConnection();
        Properties properties = (Properties)sQLServerConnection.activeConnectionProperties.clone();
        properties.setProperty(SQLServerDriverBooleanProperty.SEND_STRING_PARAMETERS_AS_UNICODE.toString(), "true");
        properties.remove(SQLServerDriverStringProperty.SELECT_METHOD.toString());
        if (this.xaLogger.isLoggable(Level.FINER)) {
            this.xaLogger.finer("Creating an internal control connection for" + this.toString());
        }
        this.physicalControlConnection = new SQLServerConnection(this.toString());
        this.physicalControlConnection.connect(properties, null);
        if (this.xaLogger.isLoggable(Level.FINER)) {
            this.xaLogger.finer("Created an internal control connection" + this.physicalControlConnection.toString() + " for " + this.toString() + " Physical connection:" + this.getPhysicalConnection().toString());
        }
        if (this.xaLogger.isLoggable(Level.FINER)) {
            this.xaLogger.finer(sQLServerDataSource.toString() + " user:" + string);
        }
    }

    public synchronized XAResource getXAResource() throws SQLException {
        if (this.XAResource == null) {
            this.XAResource = new SQLServerXAResource(this.getPhysicalConnection(), this.physicalControlConnection, this.toString());
        }
        return this.XAResource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        SQLServerXAConnection sQLServerXAConnection = this;
        synchronized (sQLServerXAConnection) {
            if (this.XAResource != null) {
                this.XAResource.close();
                this.XAResource = null;
            }
            if (null != this.physicalControlConnection) {
                this.physicalControlConnection.close();
                this.physicalControlConnection = null;
            }
        }
        super.close();
    }
}

