package com.hyperscience.saas.api;


import com.hyperscience.saas.api.enums.DataSupportedMediaType;
import com.hyperscience.saas.api.enums.PayloadSupportedMediaType;
import java.io.IOException;
import java.util.Map;
import okhttp3.Response;
import org.apache.commons.collections4.MultiValuedMap;

/**
 * ApiController enables sending API calls to hyperscience saas platform.
 */
public interface ApiController {
  /**
   * Send HTTP GET request.
   *
   * @param url  - relative url to invoke
   * @param data - unique key value pairs to be encoded as query parameters.
   * @return - {@link okhttp3.Response} received by the server.
   * @throws IOException if fails to connect with the server.
   */
  Response get(String url, Map<String, String> data) throws IOException;


  /**
   * Send HTTP GET request.
   *
   * @param url  - relative url to invoke
   * @param data - MultiValueMap allows for duplicate keys to be encoded as query parameters.
   * @return - {@link okhttp3.Response} received by the server.
   * @throws IOException if fails to connect with the server.
   */
  Response get(String url, MultiValuedMap<String, String> data) throws IOException;

  /**
   * Send HTTP POST request.
   *
   * @param url         - relative url to invoke
   * @param data        - unique key value pairs to be encoded based on contentType
   * @param contentType - type of the request.
   * @return - {@link okhttp3.Response} received by the server.
   * @throws IOException if fails to connect with the server.
   */
  Response post(String url, Map<String, String> data,
                DataSupportedMediaType contentType)
      throws IOException;

  /**
   * Send HTTP POST request.
   *
   * @param url         - relative url to invoke
   * @param data        - MultiValueMap allows for duplicate keys to be encoded based on contentType
   * @param contentType - type of the request.
   * @return - {@link okhttp3.Response} received by the server.
   * @throws IOException if fails to connect with the server.
   */
  Response post(String url, MultiValuedMap<String, String> data,
                DataSupportedMediaType contentType)
      throws IOException;

  /**
   * Send HTTP POST request.
   *
   * @param url         - relative url to invoke
   * @param data        - Map capable of representing complex object structures to be serialized
   *                    based on contentType
   * @param contentType - type of the request.
   * @return - {@link okhttp3.Response} received by the server.
   * @throws IOException if fails to connect with the server.
   */
  Response post(String url, Map<String, Object> data,
                PayloadSupportedMediaType contentType)
      throws IOException;
}
