package com.hyperscience.saas.api;

import com.hyperscience.saas.api.enums.DataSupportedMediaType;
import com.hyperscience.saas.api.enums.HttpVerb;
import com.hyperscience.saas.api.enums.PayloadSupportedMediaType;
import com.hyperscience.saas.api.enums.SupportedMediaType;
import com.hyperscience.saas.auth.OauthService;
import com.hyperscience.saas.auth.OauthServiceImpl;
import com.hyperscience.saas.auth.model.Credentials;
import com.hyperscience.saas.config.Configuration;
import java.io.IOException;
import java.util.Map;
import okhttp3.Response;
import org.apache.commons.collections4.MultiValuedMap;

/**
 * Concrete implementation for {@link com.hyperscience.saas.api.ApiController}.
 */
public class ApiControllerImpl implements ApiController {
  RequestHandler requestHandler;

  /**
   * Create ApiController based on Configuration and Credentials.
   *
   * @param configuration - Configuration
   * @param credentials   - Credentials
   */
  public ApiControllerImpl(Configuration configuration, Credentials credentials) {
    try {
      OauthService oauthService = new OauthServiceImpl(configuration);
      requestHandler = new RequestHandlerImpl(credentials, configuration, oauthService);
      requestHandler.init();
    } catch (Exception ex) {
      throw new IllegalStateException("Failed to initialize ApiController!", ex);
    }
  }


  @Override
  public Response get(String url, Map<String, String> data) throws IOException {
    return requestHandler.handleRequest(
        HttpVerb.Get,
        url,
        (Map) data,
        null);
  }

  @Override
  public Response get(String url, MultiValuedMap<String, String> data) throws IOException {
    return requestHandler.handleRequest(
        HttpVerb.Get,
        url,
        (MultiValuedMap) data,
        null);
  }

  @Override
  public Response post(String url, Map<String, String> data,
                       DataSupportedMediaType contentType)
      throws IOException {
    return requestHandler.handleRequest(
        HttpVerb.Post,
        url,
        (Map) data,
        SupportedMediaType.valueOf(contentType.name()));
  }

  @Override
  public Response post(String url, MultiValuedMap<String, String> data,
                       DataSupportedMediaType contentType)
      throws IOException {
    return requestHandler.handleRequest(
        HttpVerb.Post,
        url,
        (MultiValuedMap) data,
        SupportedMediaType.valueOf(contentType.name()));
  }

  @Override
  public Response post(String url, Map<String, Object> data,
                       PayloadSupportedMediaType contentType)
      throws IOException {
    return requestHandler.handleRequest(
        HttpVerb.Post,
        url,
        data,
        SupportedMediaType.valueOf(contentType.name()));
  }
}
