package com.hyperscience.saas.api;

import com.hyperscience.saas.api.enums.HttpVerb;
import com.hyperscience.saas.api.enums.SupportedMediaType;
import java.io.IOException;
import java.util.Map;
import okhttp3.Response;
import org.apache.commons.collections4.MultiValuedMap;

/**
 * Request handler acts as interceptor of requests sent to the platform.
 */
interface RequestHandler {
  void init() throws IOException;

  Response handleRequest(HttpVerb httpVerb, String url, Map<String, Object> data,
                         SupportedMediaType contentType) throws IOException;

  Response handleRequest(HttpVerb httpVerb,
                         String url,
                         MultiValuedMap<String, Object> data,
                         SupportedMediaType contentType) throws IOException;
}
